/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.vaadin.ui.widgetprocessor.binding.simple;

import com.vaadin.data.Property;
import com.vaadin.ui.Component;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.metawidget.util.ClassUtils;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.WidgetBuilderUtils;
import org.metawidget.util.simple.PathUtils;
import org.metawidget.vaadin.ui.VaadinMetawidget;
import org.metawidget.vaadin.ui.widgetprocessor.binding.BindingConverter;
import org.metawidget.vaadin.ui.widgetprocessor.binding.simple.ConvertFromTo;
import org.metawidget.vaadin.ui.widgetprocessor.binding.simple.Converter;
import org.metawidget.vaadin.ui.widgetprocessor.binding.simple.FromStringConverter;
import org.metawidget.vaadin.ui.widgetprocessor.binding.simple.NumberConverter;
import org.metawidget.vaadin.ui.widgetprocessor.binding.simple.SimpleBindingProcessorConfig;
import org.metawidget.vaadin.ui.widgetprocessor.binding.simple.ToStringConverter;
import org.metawidget.widgetprocessor.iface.AdvancedWidgetProcessor;
import org.metawidget.widgetprocessor.iface.WidgetProcessorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleBindingProcessor
implements AdvancedWidgetProcessor<Component, VaadinMetawidget>,
BindingConverter {
    private final Map<ConvertFromTo, Converter<?, ?>> mConverters = CollectionUtils.newHashMap();

    public SimpleBindingProcessor() {
        this(new SimpleBindingProcessorConfig());
    }

    public SimpleBindingProcessor(SimpleBindingProcessorConfig simpleBindingProcessorConfig) {
        this.mConverters.put(new ConvertFromTo(String.class, Object.class), new FromStringConverter());
        this.mConverters.put(new ConvertFromTo(Object.class, String.class), new ToStringConverter());
        this.mConverters.put(new ConvertFromTo(Number.class, Number.class), new NumberConverter());
        if (simpleBindingProcessorConfig.getConverters() != null) {
            this.mConverters.putAll(simpleBindingProcessorConfig.getConverters());
        }
    }

    @Override
    public void onStartBuild(VaadinMetawidget vaadinMetawidget) {
        vaadinMetawidget.putClientProperty(SimpleBindingProcessor.class, null);
    }

    @Override
    public Component processWidget(Component component, String string, Map<String, String> map, VaadinMetawidget vaadinMetawidget) {
        Property property;
        if (component instanceof VaadinMetawidget) {
            State state = this.getState(vaadinMetawidget);
            if (state.nestedMetawidgets == null) {
                state.nestedMetawidgets = new HashSet<VaadinMetawidget>();
            }
            state.nestedMetawidgets.add((VaadinMetawidget)component);
            return component;
        }
        if (!(component instanceof Property)) {
            return component;
        }
        if ("true".equals(map.get("no-getter"))) {
            return component;
        }
        String string2 = map.get("type");
        if (string2 == null) {
            return component;
        }
        Class<?> clazz = ClassUtils.niceForName(string2);
        Object t = vaadinMetawidget.getToInspect();
        if (t == null) {
            return component;
        }
        String string3 = vaadinMetawidget.getPath();
        if ("property".equals(string) || "action".equals(string)) {
            string3 = string3 + '/' + map.get("name");
        }
        for (String string4 : property = PathUtils.parsePath(string3).getNamesAsArray()) {
            t = ClassUtils.getProperty(t, string4);
        }
        try {
            boolean bl;
            Property property2 = (Property)component;
            Class clazz2 = property2.getType();
            Converter converter = this.getConverter(clazz, clazz2);
            if (converter != null) {
                t = converter.convert(t, clazz2);
            }
            if (bl = property2.isReadOnly()) {
                property2.setReadOnly(false);
            }
            property2.setValue(t);
            if (bl) {
                property2.setReadOnly(true);
            }
            if (WidgetBuilderUtils.isReadOnly(map)) {
                return component;
            }
            State state = this.getState(vaadinMetawidget);
            if (state.bindings == null) {
                state.bindings = new HashSet<Object[]>();
            }
            state.bindings.add(new Object[]{property2, property, clazz});
        }
        catch (Exception exception) {
            throw WidgetProcessorException.newException(exception);
        }
        return component;
    }

    public void save(VaadinMetawidget vaadinMetawidget) {
        State state = this.getState(vaadinMetawidget);
        if (state.bindings != null) {
            Object object = vaadinMetawidget.getToInspect();
            if (object == null) {
                return;
            }
            for (Object[] objectArray : state.bindings) {
                Property property = (Property)objectArray[0];
                String[] stringArray = (String[])objectArray[1];
                Class clazz = (Class)objectArray[2];
                Object object2 = property.getValue();
                Converter converter = this.getConverter(property.getType(), clazz);
                if (converter != null) {
                    object2 = converter.convert(object2, clazz);
                }
                Object object3 = object;
                int n = stringArray.length;
                for (int i = 0; i < n - 1; ++i) {
                    if ((object3 = ClassUtils.getProperty(object3, stringArray[i])) != null) continue;
                    return;
                }
                ClassUtils.setProperty(object3, stringArray[n - 1], object2);
            }
        }
        if (state.nestedMetawidgets != null) {
            for (VaadinMetawidget vaadinMetawidget2 : state.nestedMetawidgets) {
                this.save(vaadinMetawidget2);
            }
        }
    }

    @Override
    public void onEndBuild(VaadinMetawidget vaadinMetawidget) {
    }

    @Override
    public Object convertFromString(String string, Class<?> clazz) {
        Converter<String, ?> converter = this.getConverter(String.class, clazz);
        if (converter != null) {
            return converter.convert(string, clazz);
        }
        return string;
    }

    State getState(VaadinMetawidget vaadinMetawidget) {
        State state = (State)vaadinMetawidget.getClientProperty(SimpleBindingProcessor.class);
        if (state == null) {
            state = new State();
            vaadinMetawidget.putClientProperty(SimpleBindingProcessor.class, state);
        }
        return state;
    }

    private <F, T> Converter<F, T> getConverter(Class<F> clazz, Class<T> clazz2) {
        Class<Object> clazz3 = clazz2;
        if (clazz3.isPrimitive()) {
            clazz3 = ClassUtils.getWrapperClass(clazz3);
        }
        while (clazz3 != null) {
            Class<Object> clazz4 = clazz;
            if (clazz4.isPrimitive()) {
                clazz4 = ClassUtils.getWrapperClass(clazz4);
            }
            while (clazz4 != null) {
                Converter<?, ?> converter = this.mConverters.get(new ConvertFromTo(clazz4, clazz3));
                if (converter != null) {
                    return converter;
                }
                clazz4 = clazz4.getSuperclass();
            }
            clazz3 = clazz3.getSuperclass();
        }
        return null;
    }

    static class State {
        Set<Object[]> bindings;
        Set<VaadinMetawidget> nestedMetawidgets;

        State() {
        }
    }
}

