/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.widgetbuilder.composite;

import java.util.Map;
import org.metawidget.widgetbuilder.composite.CompositeWidgetBuilderConfig;
import org.metawidget.widgetbuilder.iface.AdvancedWidgetBuilder;
import org.metawidget.widgetbuilder.iface.WidgetBuilder;
import org.metawidget.widgetbuilder.iface.WidgetBuilderException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeWidgetBuilder<W, M extends W>
implements AdvancedWidgetBuilder<W, M> {
    final WidgetBuilder<W, M>[] mWidgetBuilders;

    public CompositeWidgetBuilder(CompositeWidgetBuilderConfig<W, M> compositeWidgetBuilderConfig) {
        WidgetBuilder<W, M>[] widgetBuilderArray = compositeWidgetBuilderConfig.getWidgetBuilders();
        if (widgetBuilderArray == null || widgetBuilderArray.length < 2) {
            throw WidgetBuilderException.newException("CompositeWidgetBuilder needs at least two WidgetBuilders");
        }
        this.mWidgetBuilders = new WidgetBuilder[widgetBuilderArray.length];
        int n = widgetBuilderArray.length;
        for (int i = 0; i < n; ++i) {
            WidgetBuilder<W, M> widgetBuilder = widgetBuilderArray[i];
            for (int j = 0; j < i; ++j) {
                if (!this.mWidgetBuilders[j].equals(widgetBuilder)) continue;
                throw WidgetBuilderException.newException("CompositeWidgetBuilder's list of WidgetBuilders contains two of the same " + widgetBuilder.getClass().getName());
            }
            this.mWidgetBuilders[i] = widgetBuilder;
        }
    }

    @Override
    public void onStartBuild(M m) {
        for (WidgetBuilder<W, M> widgetBuilder : this.mWidgetBuilders) {
            if (!(widgetBuilder instanceof AdvancedWidgetBuilder)) continue;
            ((AdvancedWidgetBuilder)widgetBuilder).onStartBuild(m);
        }
    }

    @Override
    public W buildWidget(String string, Map<String, String> map, M m) {
        for (WidgetBuilder<W, M> widgetBuilder : this.mWidgetBuilders) {
            W w = widgetBuilder.buildWidget(string, map, m);
            if (w == null) continue;
            return w;
        }
        return null;
    }

    @Override
    public void onEndBuild(M m) {
        for (WidgetBuilder<W, M> widgetBuilder : this.mWidgetBuilders) {
            if (!(widgetBuilder instanceof AdvancedWidgetBuilder)) continue;
            ((AdvancedWidgetBuilder)widgetBuilder).onEndBuild(m);
        }
    }

    public WidgetBuilder<W, M>[] getWidgetBuilders() {
        WidgetBuilder[] widgetBuilderArray = new WidgetBuilder[this.mWidgetBuilders.length];
        System.arraycopy(this.mWidgetBuilders, 0, widgetBuilderArray, 0, this.mWidgetBuilders.length);
        return widgetBuilderArray;
    }
}

