/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.android.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.metawidget.android.AndroidConfigReader;
import org.metawidget.android.widget.AndroidValueAccessor;
import org.metawidget.android.widget.Facet;
import org.metawidget.android.widget.Stub;
import org.metawidget.android.widget.layout.TableLayout;
import org.metawidget.android.widget.layout.TextViewLayoutDecorator;
import org.metawidget.android.widget.layout.TextViewLayoutDecoratorConfig;
import org.metawidget.android.widget.widgetbuilder.AndroidWidgetBuilder;
import org.metawidget.android.widget.widgetbuilder.OverriddenWidgetBuilder;
import org.metawidget.android.widget.widgetbuilder.ReadOnlyWidgetBuilder;
import org.metawidget.config.iface.ConfigReader;
import org.metawidget.iface.MetawidgetException;
import org.metawidget.inspectionresultprocessor.iface.InspectionResultProcessor;
import org.metawidget.inspectionresultprocessor.sort.ComesAfterInspectionResultProcessor;
import org.metawidget.inspector.composite.CompositeInspector;
import org.metawidget.inspector.composite.CompositeInspectorConfig;
import org.metawidget.inspector.iface.Inspector;
import org.metawidget.inspector.propertytype.PropertyTypeInspector;
import org.metawidget.layout.iface.Layout;
import org.metawidget.pipeline.w3c.W3CPipeline;
import org.metawidget.util.ArrayUtils;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.simple.PathUtils;
import org.metawidget.util.simple.StringUtils;
import org.metawidget.widgetbuilder.composite.CompositeWidgetBuilder;
import org.metawidget.widgetbuilder.composite.CompositeWidgetBuilderConfig;
import org.metawidget.widgetbuilder.iface.WidgetBuilder;
import org.metawidget.widgetprocessor.iface.WidgetProcessor;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AndroidMetawidget
extends LinearLayout {
    private static Inspector DEFAULT_INSPECTOR;
    private static InspectionResultProcessor<AndroidMetawidget> DEFAULT_INSPECTIONRESULTPROCESSOR;
    private static WidgetBuilder<View, AndroidMetawidget> DEFAULT_WIDGETBUILDER;
    private static Layout<View, ViewGroup, AndroidMetawidget> DEFAULT_LAYOUT;
    private static ConfigReader DEFAULT_CONFIG_READER;
    private Object mToInspect;
    private String mPath;
    private Class<?> mBundle;
    private boolean mNeedToBuildWidgets;
    Element mLastInspection;
    private boolean mIgnoreAddRemove;
    private Set<View> mExistingViews;
    private Set<View> mExistingUnusedViews;
    private Map<String, Facet> mFacets;
    private Map<Object, Object> mClientProperties;
    private Pipeline mPipeline;

    public AndroidMetawidget(Context context) {
        super(context);
        this.initAndroidMetawidget(null);
    }

    public AndroidMetawidget(Context context, AttributeSet attributes) {
        super(context, attributes);
        this.initAndroidMetawidget(attributes);
    }

    private void initAndroidMetawidget(AttributeSet attributes) {
        this.mPipeline = this.newPipeline();
        this.setOrientation(1);
        if (DEFAULT_CONFIG_READER == null) {
            DEFAULT_CONFIG_READER = new AndroidConfigReader(this.getContext());
        }
        this.mPipeline.setConfigReader(DEFAULT_CONFIG_READER);
        if (attributes != null) {
            String readOnly;
            int config = attributes.getAttributeResourceValue(null, "config", 0);
            if (config != 0) {
                this.setConfig(config);
            }
            if ((readOnly = attributes.getAttributeValue(null, "readOnly")) != null && !"".equals(readOnly)) {
                this.mPipeline.setReadOnly(Boolean.parseBoolean(readOnly));
            }
        }
    }

    public void setToInspect(Object toInspect) {
        if (this.mToInspect == null) {
            if (this.mPath == null && toInspect != null) {
                this.mPath = toInspect.getClass().getName();
            }
        } else if (this.mToInspect.getClass().getName().equals(this.mPath)) {
            this.mPath = toInspect == null ? null : toInspect.getClass().getName();
        }
        this.mToInspect = toInspect;
        this.invalidateInspection();
    }

    public void setPath(String path) {
        this.mPath = path;
        this.invalidateInspection();
    }

    public String getPath() {
        return this.mPath;
    }

    public void setConfig(int config) {
        this.mPipeline.setConfig(config);
        this.invalidateInspection();
    }

    public void setInspector(Inspector inspector) {
        this.mPipeline.setInspector(inspector);
        this.invalidateInspection();
    }

    public String inspect(Object toInspect, String type, String ... names) {
        return this.mPipeline.inspect(toInspect, type, names);
    }

    public void setInspectionResultProcessors(InspectionResultProcessor<AndroidMetawidget> ... inspectionResultProcessors) {
        this.mPipeline.setInspectionResultProcessors(inspectionResultProcessors);
        this.invalidateInspection();
    }

    public void setWidgetBuilder(WidgetBuilder<View, AndroidMetawidget> widgetBuilder) {
        this.mPipeline.setWidgetBuilder(widgetBuilder);
        this.invalidateWidgets();
    }

    public void setWidgetProcessors(WidgetProcessor<View, AndroidMetawidget> ... widgetProcessors) {
        this.mPipeline.setWidgetProcessors(widgetProcessors);
        this.invalidateWidgets();
    }

    public void setLayout(Layout<View, ViewGroup, AndroidMetawidget> layout) {
        this.mPipeline.setLayout(layout);
        this.invalidateWidgets();
    }

    public void setBundle(Class<?> bundle) {
        this.mBundle = bundle;
        this.invalidateWidgets();
    }

    public String getLabelString(Map<String, String> attributes) {
        if (attributes == null) {
            return "";
        }
        String label = attributes.get("label");
        if (label != null) {
            if ("".equals(label)) {
                return null;
            }
            String localized = this.getLocalizedKey(StringUtils.camelCase(label));
            if (localized != null) {
                return localized.trim();
            }
            return label.trim();
        }
        String name = attributes.get("name");
        if (name != null) {
            String localized = this.getLocalizedKey(name);
            if (localized != null) {
                return localized.trim();
            }
            return StringUtils.uncamelCase(name);
        }
        return "";
    }

    public String getLocalizedKey(String key) {
        if (this.mBundle == null) {
            return null;
        }
        try {
            int id = (Integer)this.mBundle.getField(key).get(null);
            return ((Object)this.getContext().getResources().getText(id)).toString();
        }
        catch (Exception e) {
            return "???" + key + "???";
        }
    }

    public boolean isReadOnly() {
        return this.mPipeline.isReadOnly();
    }

    public void setReadOnly(boolean readOnly) {
        if (this.mPipeline.isReadOnly() == readOnly) {
            return;
        }
        this.mPipeline.setReadOnly(readOnly);
        this.invalidateWidgets();
    }

    public int getMaximumInspectionDepth() {
        return this.mPipeline.getMaximumInspectionDepth();
    }

    public void setMaximumInspectionDepth(int maximumInspectionDepth) {
        this.mPipeline.setMaximumInspectionDepth(maximumInspectionDepth);
        this.invalidateWidgets();
    }

    public void putClientProperty(Object key, Object value) {
        if (this.mClientProperties == null) {
            this.mClientProperties = CollectionUtils.newHashMap();
        }
        this.mClientProperties.put(key, value);
    }

    public <T> T getClientProperty(Object key) {
        if (this.mClientProperties == null) {
            return null;
        }
        return (T)this.mClientProperties.get(key);
    }

    public int getChildCount() {
        this.buildWidgets();
        return super.getChildCount();
    }

    public void addView(View child, LinearLayout.LayoutParams params) {
        if (!this.mIgnoreAddRemove) {
            this.invalidateWidgets();
        }
        super.addView(child, (ViewGroup.LayoutParams)params);
    }

    public void addView(View child) {
        if (!this.mIgnoreAddRemove) {
            this.invalidateWidgets();
        }
        super.addView(child);
    }

    public void removeAllViews() {
        if (!this.mIgnoreAddRemove) {
            this.invalidateWidgets();
        }
        super.removeAllViews();
    }

    public void removeView(View view) {
        if (!this.mIgnoreAddRemove) {
            this.invalidateWidgets();
        }
        super.removeView(view);
    }

    public View getChildAt(int index) {
        this.buildWidgets();
        return super.getChildAt(index);
    }

    public <T> T getValue(String ... names) {
        if (names == null || names.length == 0) {
            throw MetawidgetException.newException("No names specified");
        }
        View view = this.findViewWithTags(names);
        if (view == null) {
            throw MetawidgetException.newException("No View with tag " + ArrayUtils.toString(names));
        }
        return (T)this.getValue(view, this.mPipeline.getWidgetBuilder());
    }

    public void setValue(Object value, String ... names) {
        if (names == null || names.length == 0) {
            throw MetawidgetException.newException("No names specified");
        }
        View view = this.findViewWithTags(names);
        if (view == null) {
            throw MetawidgetException.newException("No View with tag " + ArrayUtils.toString(names));
        }
        if (!this.setValue(value, view, this.mPipeline.getWidgetBuilder())) {
            throw MetawidgetException.newException("Don't know how to setValue of a " + view.getClass().getName());
        }
    }

    public Facet getFacet(String name) {
        this.buildWidgets();
        return this.mFacets.get(name);
    }

    public Set<View> fetchExistingUnusedViews() {
        return this.mExistingUnusedViews;
    }

    protected Pipeline newPipeline() {
        return new Pipeline();
    }

    protected void configureDefaults() {
        try {
            if (this.mPipeline.getInspector() == null) {
                if (DEFAULT_INSPECTOR == null) {
                    Inspector annotationInspector = (Inspector)Class.forName("org.metawidget.inspector.annotation.MetawidgetAnnotationInspector").newInstance();
                    DEFAULT_INSPECTOR = new CompositeInspector(new CompositeInspectorConfig().setInspectors(new PropertyTypeInspector(), annotationInspector));
                }
                this.mPipeline.setInspector(DEFAULT_INSPECTOR);
            }
            if (this.mPipeline.getInspectionResultProcessors() == null) {
                if (DEFAULT_INSPECTIONRESULTPROCESSOR == null) {
                    DEFAULT_INSPECTIONRESULTPROCESSOR = new ComesAfterInspectionResultProcessor<AndroidMetawidget>();
                }
                this.mPipeline.addInspectionResultProcessor(DEFAULT_INSPECTIONRESULTPROCESSOR);
            }
            if (this.mPipeline.getWidgetBuilder() == null) {
                if (DEFAULT_WIDGETBUILDER == null) {
                    CompositeWidgetBuilderConfig config = new CompositeWidgetBuilderConfig().setWidgetBuilders(new OverriddenWidgetBuilder(), new ReadOnlyWidgetBuilder(), new AndroidWidgetBuilder());
                    DEFAULT_WIDGETBUILDER = new CompositeWidgetBuilder<View, AndroidMetawidget>(config);
                }
                this.setWidgetBuilder(DEFAULT_WIDGETBUILDER);
            }
            if (this.mPipeline.getLayout() == null) {
                if (DEFAULT_LAYOUT == null) {
                    DEFAULT_LAYOUT = new TextViewLayoutDecorator((TextViewLayoutDecoratorConfig)new TextViewLayoutDecoratorConfig().setLayout((Layout)new TableLayout()));
                }
                this.setLayout(DEFAULT_LAYOUT);
            }
        }
        catch (Exception e) {
            throw MetawidgetException.newException(e);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.buildWidgets();
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    protected void invalidateInspection() {
        this.mLastInspection = null;
        this.invalidateWidgets();
    }

    protected void invalidateWidgets() {
        if (this.mNeedToBuildWidgets) {
            return;
        }
        this.mNeedToBuildWidgets = true;
        this.postInvalidate();
    }

    protected void buildWidgets() {
        if (!this.mNeedToBuildWidgets) {
            return;
        }
        this.mPipeline.configure();
        this.mNeedToBuildWidgets = false;
        this.mIgnoreAddRemove = true;
        try {
            if (this.mLastInspection == null) {
                this.mLastInspection = this.inspect();
            }
            this.mPipeline.buildWidgets(this.mLastInspection);
        }
        catch (Exception e) {
            throw MetawidgetException.newException(e);
        }
        finally {
            this.mIgnoreAddRemove = false;
        }
    }

    protected void startBuild() {
        if (this.mExistingViews == null) {
            this.mExistingViews = CollectionUtils.newHashSet();
            this.mFacets = CollectionUtils.newHashMap();
            int length = this.getChildCount();
            for (int loop = 0; loop < length; ++loop) {
                View view = this.getChildAt(loop);
                if (view instanceof Facet) {
                    Facet facet = (Facet)view;
                    this.mFacets.put(facet.getName(), facet);
                    continue;
                }
                this.mExistingViews.add(view);
            }
        }
        this.removeAllViews();
        this.mExistingUnusedViews = CollectionUtils.newHashSet(this.mExistingViews);
    }

    protected void layoutWidget(View view, String elementName, Map<String, String> attributes) {
        String childName = attributes.get("name");
        view.setTag((Object)childName);
        if (this.mPipeline.getLayout() != null && view.getParent() != null) {
            ((ViewGroup)view.getParent()).removeView(view);
        }
    }

    protected void endBuild() {
        Layout<View, AndroidMetawidget, AndroidMetawidget> layout = this.mPipeline.getLayout();
        if (layout != null) {
            HashMap<String, String> noAttributes = CollectionUtils.newHashMap();
            for (View viewExisting : this.mExistingUnusedViews) {
                if (viewExisting.getParent() != null) {
                    ((ViewGroup)viewExisting.getParent()).removeView(viewExisting);
                }
                layout.layoutWidget(viewExisting, "property", noAttributes, this, this);
            }
        }
    }

    protected void initNestedMetawidget(AndroidMetawidget nestedMetawidget, Map<String, String> attributes) {
        this.mPipeline.initNestedPipeline(nestedMetawidget.mPipeline, attributes);
        nestedMetawidget.setPath(this.mPath + '/' + attributes.get("name"));
        nestedMetawidget.setBundle(this.mBundle);
        nestedMetawidget.setToInspect(this.mToInspect);
    }

    private Element inspect() {
        if (this.mPath == null) {
            return null;
        }
        PathUtils.TypeAndNames typeAndNames = PathUtils.parsePath(this.mPath);
        return (Element)this.mPipeline.inspectAsDom(this.mToInspect, typeAndNames.getType(), typeAndNames.getNamesAsArray());
    }

    private View findViewWithTags(String ... tags) {
        if (tags == null) {
            return null;
        }
        AndroidMetawidget viewgroup = this;
        int tagsLength = tags.length;
        for (int tagsLoop = 0; tagsLoop < tagsLength; ++tagsLoop) {
            String tag = tags[tagsLoop];
            View match = this.findViewWithTag((ViewGroup)viewgroup, tag);
            if (match == null) {
                return null;
            }
            if (tagsLoop == tagsLength - 1) {
                return match;
            }
            if (!(match instanceof ViewGroup)) {
                return null;
            }
            viewgroup = (ViewGroup)match;
        }
        return null;
    }

    private View findViewWithTag(ViewGroup viewgroup, Object tag) {
        int childLength = viewgroup.getChildCount();
        for (int childLoop = 0; childLoop < childLength; ++childLoop) {
            View child = viewgroup.getChildAt(childLoop);
            Object childTag = child.getTag();
            if (childTag == null && child instanceof ViewGroup) {
                View view = this.findViewWithTag((ViewGroup)child, tag);
                if (view == null) continue;
                return view;
            }
            if (!tag.equals(child.getTag())) continue;
            return child;
        }
        return null;
    }

    private Object getValue(View widget, WidgetBuilder<View, AndroidMetawidget> widgetBuilder) {
        if (widgetBuilder instanceof CompositeWidgetBuilder) {
            for (WidgetBuilder<View, AndroidMetawidget> widgetBuilder2 : ((CompositeWidgetBuilder)widgetBuilder).getWidgetBuilders()) {
                Object value = this.getValue(widget, widgetBuilder2);
                if (value == null) continue;
                return value;
            }
            return null;
        }
        if (widgetBuilder instanceof AndroidValueAccessor) {
            return ((AndroidValueAccessor)((Object)widgetBuilder)).getValue(widget);
        }
        return null;
    }

    private boolean setValue(Object value, View widget, WidgetBuilder<View, AndroidMetawidget> widgetBuilder) {
        if (widgetBuilder instanceof CompositeWidgetBuilder) {
            for (WidgetBuilder<View, AndroidMetawidget> widgetBuilder2 : ((CompositeWidgetBuilder)widgetBuilder).getWidgetBuilders()) {
                if (!this.setValue(value, widget, widgetBuilder2)) continue;
                return true;
            }
            return false;
        }
        if (widgetBuilder instanceof AndroidValueAccessor) {
            return ((AndroidValueAccessor)((Object)widgetBuilder)).setValue(value, widget);
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Pipeline
    extends W3CPipeline<View, ViewGroup, AndroidMetawidget> {
        protected Pipeline() {
        }

        @Override
        protected String getDefaultConfiguration() {
            return null;
        }

        @Override
        protected void configure() {
            try {
                if (this.getConfig() != null) {
                    this.getConfigReader().configure(AndroidMetawidget.this.getContext().getResources().openRawResource(((Integer)this.getConfig()).intValue()), (Object)AndroidMetawidget.this, new String[0]);
                }
                AndroidMetawidget.this.configureDefaults();
            }
            catch (Exception e) {
                throw MetawidgetException.newException(e);
            }
        }

        @Override
        protected void startBuild() {
            super.startBuild();
            AndroidMetawidget.this.startBuild();
        }

        @Override
        protected void layoutWidget(View view, String elementName, Map<String, String> attributes) {
            AndroidMetawidget.this.layoutWidget(view, elementName, attributes);
            super.layoutWidget(view, elementName, attributes);
        }

        @Override
        protected Map<String, String> getAdditionalAttributes(View view) {
            if (view instanceof Stub) {
                return ((Stub)view).getAttributes();
            }
            return null;
        }

        @Override
        public AndroidMetawidget buildNestedMetawidget(Map<String, String> attributes) throws Exception {
            Constructor<?> constructor = ((Object)((Object)AndroidMetawidget.this)).getClass().getConstructor(Context.class);
            AndroidMetawidget nestedMetawidget = (AndroidMetawidget)((Object)constructor.newInstance(AndroidMetawidget.this.getContext()));
            AndroidMetawidget.this.initNestedMetawidget(nestedMetawidget, attributes);
            return nestedMetawidget;
        }

        @Override
        protected void endBuild() {
            AndroidMetawidget.this.endBuild();
            super.endBuild();
        }

        @Override
        protected AndroidMetawidget getPipelineOwner() {
            return AndroidMetawidget.this;
        }
    }
}

