/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.gwt.client.ui;

import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.ListBox;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GwtUtils {
    public static boolean isPrimitive(String className) {
        if (GwtUtils.isIntegerPrimitive(className)) {
            return true;
        }
        if ("float".equals(className) || "double".equals(className)) {
            return true;
        }
        if ("boolean".equals(className)) {
            return true;
        }
        return "char".equals(className);
    }

    public static boolean isIntegerPrimitive(String className) {
        if ("byte".equals(className) || "short".equals(className)) {
            return true;
        }
        return "int".equals(className) || "long".equals(className);
    }

    public static boolean isPrimitiveWrapper(String className) {
        if (Byte.class.getName().equals(className) || Short.class.getName().equals(className)) {
            return true;
        }
        if (Integer.class.getName().equals(className) || Long.class.getName().equals(className)) {
            return true;
        }
        if (Float.class.getName().equals(className) || Double.class.getName().equals(className)) {
            return true;
        }
        if (Boolean.class.getName().equals(className)) {
            return true;
        }
        return Character.class.getName().equals(className);
    }

    public static boolean isCollection(String className) {
        if (Collection.class.getName().equals(className)) {
            return true;
        }
        if (List.class.getName().equals(className) || ArrayList.class.getName().equals(className)) {
            return true;
        }
        if (Set.class.getName().equals(className) || HashSet.class.getName().equals(className)) {
            return true;
        }
        return Map.class.getName().equals(className) || HashMap.class.getName().equals(className);
    }

    public static List<String> fromString(String collection, char separator) {
        if (collection == null || "".equals(collection)) {
            return Collections.emptyList();
        }
        ArrayList<String> split = new ArrayList<String>();
        for (String item : collection.split(String.valueOf(separator))) {
            split.add(item.trim());
        }
        if (collection.charAt(collection.length() - 1) == separator) {
            split.add("");
        }
        return split;
    }

    public static String toString(String[] collection, char separator) {
        if (collection == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (String item : collection) {
            if (builder.length() > 0) {
                builder.append(separator);
            }
            builder.append(item);
        }
        return builder.toString();
    }

    public static String toString(Collection<?> collection, char separator) {
        if (collection == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (Object item : collection) {
            if (builder.length() > 0) {
                builder.append(separator);
            }
            builder.append(item);
        }
        return builder.toString();
    }

    public static void setListBoxSelectedItem(ListBox listBox, String value) {
        int length = listBox.getItemCount();
        for (int loop = 0; loop < length; ++loop) {
            if (!value.equals(listBox.getValue(loop))) continue;
            listBox.setSelectedIndex(loop);
            return;
        }
    }

    public static void alert(Throwable caught) {
        StringBuilder builder = new StringBuilder(caught.getClass().getName());
        if (caught.getMessage() != null) {
            builder.append(": ");
            builder.append(caught.getMessage());
        }
        for (StackTraceElement item : caught.getStackTrace()) {
            builder.append("\n\t");
            builder.append(item);
        }
        Window.alert((String)builder.toString());
    }

    public static boolean isReadOnly(Map<String, String> attributes) {
        if ("true".equals(attributes.get("read-only"))) {
            return true;
        }
        return "true".equals(attributes.get("no-setter"));
    }

    public static String getActualClassOrType(Map<String, String> attributes) {
        String type = attributes.get("actual-class");
        if (type != null && !"".equals(type)) {
            return type;
        }
        type = attributes.get("type");
        if ("".equals(type)) {
            return null;
        }
        return type;
    }

    public static boolean needsEmptyLookupItem(Map<String, String> attributes) {
        if ("true".equals(attributes.get("lookup-has-empty-choice"))) {
            return true;
        }
        if ("true".equals(attributes.get("required"))) {
            return false;
        }
        String type = GwtUtils.getActualClassOrType(attributes);
        return type == null || !GwtUtils.isPrimitive(type);
    }

    public static String stripSection(Map<String, String> attributes) {
        String sections = attributes.remove("section");
        if (sections == null) {
            return null;
        }
        List<String> sectionAsArray = GwtUtils.fromString(sections, ',');
        switch (sectionAsArray.size()) {
            case 0: {
                return "";
            }
            case 1: {
                return sectionAsArray.get(0);
            }
        }
        String section = sectionAsArray.remove(0);
        attributes.put("section", GwtUtils.toString(sectionAsArray, ','));
        return section;
    }

    private GwtUtils() {
    }
}

