/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.vaadin.ui.widgetbuilder;

import com.vaadin.ui.Button;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.PasswordField;
import com.vaadin.ui.PopupDateField;
import com.vaadin.ui.Select;
import com.vaadin.ui.Slider;
import com.vaadin.ui.TextArea;
import com.vaadin.ui.TextField;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.metawidget.util.ClassUtils;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.WidgetBuilderUtils;
import org.metawidget.vaadin.ui.Stub;
import org.metawidget.vaadin.ui.VaadinMetawidget;
import org.metawidget.vaadin.ui.widgetprocessor.binding.BindingConverter;
import org.metawidget.widgetbuilder.iface.WidgetBuilder;
import org.metawidget.widgetbuilder.iface.WidgetBuilderException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VaadinWidgetBuilder
implements WidgetBuilder<Component, VaadinMetawidget> {
    @Override
    public Component buildWidget(String elementName, Map<String, String> attributes, VaadinMetawidget metawidget) {
        if ("true".equals(attributes.get("hidden"))) {
            return new Stub();
        }
        if ("action".equals(elementName)) {
            return new Button();
        }
        Class<?> clazz = WidgetBuilderUtils.getActualClassOrType(attributes, String.class);
        if (Boolean.class.equals(clazz) && "true".equals(attributes.get("required"))) {
            return new CheckBox();
        }
        String lookup = attributes.get("lookup");
        if (lookup != null && !"".equals(lookup)) {
            return this.createSelectComponent(attributes, lookup, metawidget);
        }
        if (clazz != null) {
            if (clazz.isPrimitive()) {
                if (Boolean.TYPE.equals(clazz)) {
                    return new CheckBox();
                }
                if (Character.TYPE.equals(clazz)) {
                    TextField textField = new TextField();
                    textField.setMaxLength(1);
                    return textField;
                }
                String minimumValue = attributes.get("minimum-value");
                String maximumValue = attributes.get("maximum-value");
                if (minimumValue != null && !"".equals(minimumValue) && maximumValue != null && !"".equals(maximumValue)) {
                    Slider slider = new Slider();
                    slider.setMin(Double.parseDouble(minimumValue));
                    try {
                        slider.setValue(slider.getMin());
                    }
                    catch (Slider.ValueOutOfBoundsException e) {
                        throw WidgetBuilderException.newException(e);
                    }
                    slider.setMax(Double.parseDouble(maximumValue));
                    return slider;
                }
                return this.createTextField(attributes);
            }
            if (String.class.equals(clazz)) {
                if ("true".equals(attributes.get("masked"))) {
                    return new PasswordField();
                }
                if ("true".equals(attributes.get("large"))) {
                    return new TextArea();
                }
                return this.createTextField(attributes);
            }
            if (Character.class.isAssignableFrom(clazz)) {
                TextField textField = new TextField();
                textField.setMaxLength(1);
                return textField;
            }
            if (Date.class.equals(clazz)) {
                return new PopupDateField();
            }
            if (Number.class.isAssignableFrom(clazz)) {
                return this.createTextField(attributes);
            }
            if (Collection.class.isAssignableFrom(clazz)) {
                return new Stub();
            }
        }
        if ("true".equals(attributes.get("dont-expand"))) {
            return this.createTextField(attributes);
        }
        return null;
    }

    private TextField createTextField(Map<String, String> attributes) {
        TextField textField = new TextField();
        String maximumLength = attributes.get("maximum-length");
        if (maximumLength != null && !"".equals(maximumLength)) {
            textField.setMaxLength(Integer.parseInt(attributes.get("maximum-length")));
        }
        return textField;
    }

    private Component createSelectComponent(Map<String, String> attributes, String lookup, VaadinMetawidget metawidget) {
        String type;
        Select select = new Select();
        if (!WidgetBuilderUtils.needsEmptyLookupItem(attributes)) {
            select.setNullSelectionAllowed(false);
        }
        List<String> values = CollectionUtils.fromString(lookup);
        Map<String, String> labelsMap = null;
        String lookupLabels = attributes.get("lookup-labels");
        if (lookupLabels != null && !"".equals(lookupLabels)) {
            labelsMap = CollectionUtils.newHashMap(values, CollectionUtils.fromString(attributes.get("lookup-labels")));
        }
        Class<?> clazz = (type = attributes.get("type")) != null ? ClassUtils.niceForName(type) : null;
        BindingConverter bindingConverter = metawidget.getWidgetProcessor(BindingConverter.class);
        for (String value : values) {
            Object convertedValue = value;
            if (bindingConverter != null && clazz != null) {
                convertedValue = bindingConverter.convertFromString(value, clazz);
            }
            select.addItem(convertedValue);
            if (labelsMap == null) continue;
            select.setItemCaption(convertedValue, labelsMap.get(value));
        }
        if (!WidgetBuilderUtils.needsEmptyLookupItem(attributes)) {
            select.setRequired(true);
        }
        return select;
    }
}

