/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.util;

import java.util.Map;
import org.metawidget.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WidgetBuilderUtils {
    public static boolean isReadOnly(Map<String, String> attributes) {
        if ("true".equals(attributes.get("read-only"))) {
            return true;
        }
        return "true".equals(attributes.get("no-setter"));
    }

    public static Class<?> getActualClassOrType(Map<String, String> attributes, Class<?> defaultClass) {
        return WidgetBuilderUtils.getActualClassOrType(attributes, defaultClass, null);
    }

    public static Class<?> getActualClassOrType(Map<String, String> attributes, Class<?> defaultClass, ClassLoader classLoader) {
        String type = attributes.get("actual-class");
        if ((type == null || "".equals(type)) && ((type = attributes.get("type")) == null || "".equals(type))) {
            return defaultClass;
        }
        return ClassUtils.niceForName(type, classLoader);
    }

    public static String getComponentType(Map<String, String> attributes) {
        String parameterizedType = attributes.get("parameterized-type");
        if (parameterizedType != null) {
            return parameterizedType;
        }
        Class<?> clazz = WidgetBuilderUtils.getActualClassOrType(attributes, null);
        if (clazz == null) {
            return null;
        }
        if (clazz.isArray()) {
            return clazz.getComponentType().getName();
        }
        return null;
    }

    public static boolean needsEmptyLookupItem(Map<String, String> attributes) {
        if ("true".equals(attributes.get("lookup-has-empty-choice"))) {
            return true;
        }
        if ("true".equals(attributes.get("required"))) {
            return false;
        }
        Class<?> clazz = WidgetBuilderUtils.getActualClassOrType(attributes, null);
        return clazz == null || !clazz.isPrimitive();
    }

    private WidgetBuilderUtils() {
    }
}

