/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.swt.layout;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.metawidget.layout.iface.LayoutException;
import org.metawidget.util.simple.ObjectUtils;
import org.metawidget.util.simple.StringUtils;

public class GridLayoutConfig {
    private int mNumberOfColumns = 1;
    private int mLabelAlignment = 16384;
    private Color mLabelForeground;
    private Font mLabelFont;
    private String mLabelSuffix = StringUtils.SEPARATOR_COLON;
    private int mRequiredAlignment = 0x1000000;
    private String mRequiredText = "*";

    public GridLayoutConfig setNumberOfColumns(int numberOfColumns) {
        if (numberOfColumns < 1) {
            throw LayoutException.newException("numberOfColumns must be >= 1");
        }
        this.mNumberOfColumns = numberOfColumns;
        return this;
    }

    public GridLayoutConfig setLabelAlignment(int labelAlignment) {
        this.mLabelAlignment = labelAlignment;
        return this;
    }

    public GridLayoutConfig setLabelForeground(Color labelForeground) {
        this.mLabelForeground = labelForeground;
        return this;
    }

    public GridLayoutConfig setLabelFont(Font labelFont) {
        this.mLabelFont = labelFont;
        return this;
    }

    public GridLayoutConfig setLabelSuffix(String labelSuffix) {
        this.mLabelSuffix = labelSuffix;
        return this;
    }

    public GridLayoutConfig setRequiredAlignment(int requiredAlignment) {
        this.mRequiredAlignment = requiredAlignment;
        return this;
    }

    public GridLayoutConfig setRequiredText(String requiredText) {
        this.mRequiredText = requiredText;
        return this;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!ObjectUtils.nullSafeClassEquals(this, that)) {
            return false;
        }
        if (this.mNumberOfColumns != ((GridLayoutConfig)that).mNumberOfColumns) {
            return false;
        }
        if (this.mLabelAlignment != ((GridLayoutConfig)that).mLabelAlignment) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals(this.mLabelFont, ((GridLayoutConfig)that).mLabelFont)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals(this.mLabelForeground, ((GridLayoutConfig)that).mLabelForeground)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals(this.mLabelSuffix, ((GridLayoutConfig)that).mLabelSuffix)) {
            return false;
        }
        if (this.mRequiredAlignment != ((GridLayoutConfig)that).mRequiredAlignment) {
            return false;
        }
        return ObjectUtils.nullSafeEquals(this.mRequiredText, ((GridLayoutConfig)that).mRequiredText);
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + this.mNumberOfColumns;
        hashCode = 31 * hashCode + this.mLabelAlignment;
        hashCode = 31 * hashCode + ObjectUtils.nullSafeHashCode(this.mLabelFont);
        hashCode = 31 * hashCode + ObjectUtils.nullSafeHashCode(this.mLabelForeground);
        hashCode = 31 * hashCode + ObjectUtils.nullSafeHashCode(this.mLabelSuffix);
        hashCode = 31 * hashCode + this.mRequiredAlignment;
        hashCode = 31 * hashCode + ObjectUtils.nullSafeHashCode(this.mRequiredText);
        return hashCode;
    }

    protected int getNumberOfColumns() {
        return this.mNumberOfColumns;
    }

    protected int getLabelAlignment() {
        return this.mLabelAlignment;
    }

    protected Color getLabelForeground() {
        return this.mLabelForeground;
    }

    protected Font getLabelFont() {
        return this.mLabelFont;
    }

    protected String getLabelSuffix() {
        return this.mLabelSuffix;
    }

    protected int getRequiredAlignment() {
        return this.mRequiredAlignment;
    }

    protected String getRequiredText() {
        return this.mRequiredText;
    }
}

