/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.statically.faces.component.widgetprocessor;

import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import org.metawidget.statically.StaticXmlMetawidget;
import org.metawidget.statically.StaticXmlWidget;
import org.metawidget.statically.faces.component.ValueHolder;
import org.metawidget.statically.faces.component.html.CoreWidget;
import org.metawidget.util.ClassUtils;
import org.metawidget.widgetprocessor.iface.WidgetProcessor;
import org.metawidget.widgetprocessor.iface.WidgetProcessorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardConverterProcessor
implements WidgetProcessor<StaticXmlWidget, StaticXmlMetawidget> {
    @Override
    public StaticXmlWidget processWidget(StaticXmlWidget widget, String elementName, Map<String, String> attributes, StaticXmlMetawidget metawidget) {
        if ("action".equals(elementName)) {
            return widget;
        }
        if (!(widget instanceof ValueHolder)) {
            return widget;
        }
        String converterId = attributes.get("faces-converter");
        if (converterId != null) {
            ((ValueHolder)((Object)widget)).setConverter(converterId);
            return widget;
        }
        CoreWidget converter = null;
        String type = attributes.get("type");
        Class<Serializable> clazz = null;
        if (type != null && (clazz = ClassUtils.niceForName(type)) != null && clazz.isAssignableFrom(Date.class)) {
            converter = this.getDateTimeConverter(converter);
        }
        if (attributes.containsKey("date-style")) {
            converter = this.getDateTimeConverter(converter);
            converter.putAttribute("dateStyle", attributes.get("date-style"));
        }
        if (attributes.containsKey("datetime-pattern")) {
            converter = this.getDateTimeConverter(converter);
            converter.putAttribute("pattern", attributes.get("datetime-pattern"));
        }
        if (attributes.containsKey("time-style")) {
            converter = this.getDateTimeConverter(converter);
            converter.putAttribute("timeStyle", attributes.get("time-style"));
        }
        if (attributes.containsKey("time-zone")) {
            converter = this.getDateTimeConverter(converter);
            converter.putAttribute("timeZone", attributes.get("time-zone"));
        }
        if (attributes.containsKey("datetime-type")) {
            converter = this.getDateTimeConverter(converter);
            converter.putAttribute("type", attributes.get("datetime-type"));
        }
        if (clazz == null || clazz.isAssignableFrom(Number.class) || clazz.isPrimitive()) {
            if (attributes.containsKey("currency-code")) {
                converter = this.getNumberConverter(converter);
                converter.putAttribute("currencyCode", attributes.get("currency-code"));
            }
            if (attributes.containsKey("currency-symbol")) {
                converter = this.getNumberConverter(converter);
                converter.putAttribute("currencySymbol", attributes.get("currency-symbol"));
            }
            if (attributes.containsKey("number-uses-grouping-separators")) {
                converter = this.getNumberConverter(converter);
                converter.putAttribute("groupingUsed", attributes.get("number-uses-grouping-separators"));
            }
            if (attributes.containsKey("minimum-integer-digits")) {
                converter = this.getNumberConverter(converter);
                converter.putAttribute("minIntegerDigits", attributes.get("minimum-integer-digits"));
            }
            if (attributes.containsKey("maximum-integer-digits")) {
                converter = this.getNumberConverter(converter);
                converter.putAttribute("maxIntegerDigits", attributes.get("maximum-integer-digits"));
            }
            if (attributes.containsKey("minimum-fractional-digits")) {
                converter = this.getNumberConverter(converter);
                converter.putAttribute("minFractionDigits", attributes.get("minimum-fractional-digits"));
            }
            if (attributes.containsKey("maximum-fractional-digits")) {
                converter = this.getNumberConverter(converter);
                converter.putAttribute("maxFractionDigits", attributes.get("maximum-fractional-digits"));
            }
            if (attributes.containsKey("number-pattern")) {
                converter = this.getNumberConverter(converter);
                converter.putAttribute("pattern", attributes.get("number-pattern"));
            }
            if (attributes.containsKey("number-type")) {
                converter = this.getNumberConverter(converter);
                converter.putAttribute("type", attributes.get("number-type"));
            }
        }
        if (converter != null) {
            if (attributes.containsKey("locale")) {
                converter.putAttribute("locale", attributes.get("locale"));
            }
            widget.getChildren().add(converter);
        }
        return widget;
    }

    private CoreWidget getDateTimeConverter(CoreWidget existingConverter) {
        if (existingConverter != null) {
            if (!(existingConverter instanceof ConvertDateTimeWidget)) {
                throw WidgetProcessorException.newException("Unable to set date/time attributes on a " + existingConverter);
            }
            return existingConverter;
        }
        return new ConvertDateTimeWidget();
    }

    private CoreWidget getNumberConverter(CoreWidget existingConverter) {
        if (existingConverter != null) {
            if (!(existingConverter instanceof ConvertNumberWidget)) {
                throw WidgetProcessorException.newException("Unable to set number attributes on a " + existingConverter);
            }
            return existingConverter;
        }
        return new ConvertNumberWidget();
    }

    public static class ConvertNumberWidget
    extends CoreWidget {
        public ConvertNumberWidget() {
            super("convertNumber");
        }
    }

    public static class ConvertDateTimeWidget
    extends CoreWidget {
        public ConvertDateTimeWidget() {
            super("convertDateTime");
        }
    }
}

