/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.android.widget.widgetprocessor.reflection;

import android.view.View;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import org.metawidget.android.widget.AndroidMetawidget;
import org.metawidget.android.widget.Stub;
import org.metawidget.util.ClassUtils;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.WidgetBuilderUtils;
import org.metawidget.util.simple.PathUtils;
import org.metawidget.widgetprocessor.iface.AdvancedWidgetProcessor;
import org.metawidget.widgetprocessor.iface.WidgetProcessorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionBindingProcessor
implements AdvancedWidgetProcessor<View, AndroidMetawidget> {
    @Override
    public void onStartBuild(AndroidMetawidget metawidget) {
        metawidget.putClientProperty(ReflectionBindingProcessor.class, null);
    }

    @Override
    public View processWidget(View view, String elementName, Map<String, String> attributes, AndroidMetawidget metawidget) {
        if (view instanceof AndroidMetawidget) {
            State state = this.getState(metawidget);
            if (state.nestedMetawidgets == null) {
                state.nestedMetawidgets = CollectionUtils.newHashSet();
            }
            state.nestedMetawidgets.add((AndroidMetawidget)view);
            return view;
        }
        if (!"action".equals(elementName)) {
            return view;
        }
        if (view instanceof Stub) {
            return view;
        }
        if (WidgetBuilderUtils.isReadOnly(attributes)) {
            return view;
        }
        BoundAction action = new BoundAction(metawidget.getToInspect(), metawidget.getPath(), attributes.get("name"));
        view.setOnClickListener((View.OnClickListener)action);
        State state = this.getState(metawidget);
        if (state.actions == null) {
            state.actions = CollectionUtils.newHashSet();
        }
        state.actions.add(action);
        return view;
    }

    @Override
    public void onEndBuild(AndroidMetawidget metawidget) {
    }

    private State getState(AndroidMetawidget metawidget) {
        State state = (State)metawidget.getClientProperty(ReflectionBindingProcessor.class);
        if (state == null) {
            state = new State();
            metawidget.putClientProperty(ReflectionBindingProcessor.class, state);
        }
        return state;
    }

    static class BoundAction
    implements View.OnClickListener {
        private Object mBindTo;
        private String[] mNames;
        private Method mAction;

        public BoundAction(Object bindTo, String path, String name) {
            this.mBindTo = bindTo;
            if (path == null) {
                return;
            }
            this.mNames = PathUtils.parsePath(path).getNamesAsArray();
            Object traverse = this.mBindTo;
            for (String subName : this.mNames) {
                if (traverse == null) {
                    return;
                }
                traverse = ClassUtils.getProperty(traverse, subName);
            }
            try {
                this.mAction = traverse.getClass().getMethod(name, null);
            }
            catch (Exception e) {
                throw WidgetProcessorException.newException(e);
            }
        }

        public void onClick(View viewClicked) {
            Object traverse = this.mBindTo;
            for (String name : this.mNames) {
                if (traverse == null) {
                    return;
                }
                traverse = ClassUtils.getProperty(traverse, name);
            }
            try {
                this.mAction.invoke(traverse, (Object[])null);
            }
            catch (Exception e) {
                throw WidgetProcessorException.newException(e);
            }
        }
    }

    static class State {
        Set<BoundAction> actions;
        Set<AndroidMetawidget> nestedMetawidgets;

        State() {
        }
    }
}

