/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.layout.decorator;

import java.util.Map;
import org.metawidget.layout.decorator.LayoutDecorator;
import org.metawidget.layout.decorator.LayoutDecoratorConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NestedSectionLayoutDecorator<W, C extends W, M extends C>
extends LayoutDecorator<W, C, M> {
    protected NestedSectionLayoutDecorator(LayoutDecoratorConfig<W, C, M> config) {
        super(config);
    }

    @Override
    public void startContainerLayout(C container, M metawidget) {
        super.startContainerLayout(container, metawidget);
        State<C> state = this.getState(container, metawidget);
        state.setCurrentSection(null);
        state.setCurrentSectionWidget(null);
    }

    @Override
    public void layoutWidget(W widget, String elementName, Map<String, String> attributes, C container, M metawidget) {
        String section = this.stripSection(attributes);
        State<C> state = this.getState(container, metawidget);
        if (this.isIgnored(widget) || section == null || section.equals(state.getCurrentSection())) {
            if (state.getCurrentSectionWidget() == null) {
                super.layoutWidget(widget, elementName, attributes, container, metawidget);
            } else {
                super.layoutWidget(widget, elementName, attributes, state.getCurrentSectionWidget(), metawidget);
            }
            return;
        }
        C previousSectionWidget = state.getCurrentSectionWidget();
        if (state.getCurrentSectionWidget() != null) {
            super.endContainerLayout(state.getCurrentSectionWidget(), metawidget);
        }
        state.setCurrentSection(section);
        state.setCurrentSectionWidget(null);
        if ("".equals(section)) {
            super.layoutWidget(widget, elementName, attributes, container, metawidget);
            return;
        }
        state.setCurrentSectionWidget(this.createSectionWidget(previousSectionWidget, section, attributes, container, metawidget));
        super.startContainerLayout(state.getCurrentSectionWidget(), metawidget);
        super.layoutWidget(widget, elementName, attributes, state.getCurrentSectionWidget(), metawidget);
    }

    @Override
    public void endContainerLayout(C container, M metawidget) {
        State<C> state = this.getState(container, metawidget);
        if (state.getCurrentSectionWidget() != null) {
            super.endContainerLayout(state.getCurrentSectionWidget(), metawidget);
        }
        super.endContainerLayout(container, metawidget);
        state.setCurrentSection(null);
        state.setCurrentSectionWidget(null);
    }

    protected abstract String stripSection(Map<String, String> var1);

    protected abstract State<C> getState(C var1, M var2);

    protected abstract boolean isIgnored(W var1);

    protected abstract C createSectionWidget(C var1, String var2, Map<String, String> var3, C var4, M var5);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class State<C> {
        private String mCurrentSection;
        private C mCurrentSectionWidget;

        public String getCurrentSection() {
            return this.mCurrentSection;
        }

        public void setCurrentSection(String currentSection) {
            this.mCurrentSection = currentSection;
        }

        public C getCurrentSectionWidget() {
            return this.mCurrentSectionWidget;
        }

        public void setCurrentSectionWidget(C currentSectionWidget) {
            this.mCurrentSectionWidget = currentSectionWidget;
        }
    }
}

