/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.statically;

import java.io.IOException;
import java.io.Writer;

public final class StaticUtils {
    private StaticUtils() {
    }

    public static class LeadingSpaceWriter
    extends Writer {
        private Writer mWriter;
        private boolean mWriteLeadingSpace = true;

        public LeadingSpaceWriter(Writer writer) {
            this.mWriter = writer;
        }

        public void write(char[] characters, int offset, int length) throws IOException {
            int end = offset + length;
            for (int loop = offset; loop < end; ++loop) {
                if (this.mWriteLeadingSpace) {
                    this.mWriter.write(32);
                    this.mWriteLeadingSpace = false;
                }
                this.mWriter.write(characters, loop, 1);
            }
        }

        public void flush() throws IOException {
            this.mWriter.flush();
        }

        public void close() throws IOException {
            this.mWriter.close();
        }
    }

    public static class IndentedWriter
    extends Writer {
        private Writer mWriter;
        private int mIndent;
        private boolean mWriteIndent = true;

        public IndentedWriter(Writer writer, int initialIndent) {
            this.mWriter = writer;
            this.mIndent = initialIndent;
        }

        public void indent() {
            ++this.mIndent;
        }

        public void outdent() {
            if (this.mIndent == 0) {
                return;
            }
            --this.mIndent;
        }

        public void write(char[] characters, int offset, int length) throws IOException {
            int end = offset + length;
            for (int loop = offset; loop < end; ++loop) {
                if (this.mWriteIndent) {
                    this.mWriteIndent = false;
                    for (int indent = 0; indent < this.mIndent; ++indent) {
                        this.mWriter.write(9);
                    }
                }
                this.mWriter.write(characters, loop, 1);
                if (characters[loop] != '\n') continue;
                this.mWriteIndent = true;
            }
        }

        public void flush() throws IOException {
            this.mWriter.flush();
        }

        public void close() throws IOException {
            this.mWriter.close();
        }

        public String toString() {
            return this.mWriter.toString();
        }
    }
}

