/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.vaadin.ui.widgetprocessor;

import com.vaadin.data.Validatable;
import com.vaadin.data.Validator;
import com.vaadin.data.validator.AbstractValidator;
import com.vaadin.ui.AbstractField;
import com.vaadin.ui.Component;
import java.util.Map;
import org.metawidget.util.ClassUtils;
import org.metawidget.util.WidgetBuilderUtils;
import org.metawidget.vaadin.ui.VaadinMetawidget;
import org.metawidget.widgetprocessor.iface.WidgetProcessor;
import org.metawidget.widgetprocessor.iface.WidgetProcessorException;

public class MinimumMaximumValidatorProcessor
implements WidgetProcessor<Component, VaadinMetawidget> {
    @Override
    public Component processWidget(Component component, String elementName, Map<String, String> attributes, VaadinMetawidget metawidget) {
        if (!(component instanceof AbstractField)) {
            return component;
        }
        String minimumValue = attributes.get("minimum-value");
        String maximumValue = attributes.get("maximum-value");
        if ((minimumValue == null || "".equals(minimumValue)) && (maximumValue == null || "".equals(maximumValue))) {
            return component;
        }
        Class<Number> clazz = WidgetBuilderUtils.getActualClassOrType(attributes, null);
        if (clazz == null) {
            return component;
        }
        if (!clazz.isPrimitive() && !Number.class.isAssignableFrom(clazz)) {
            return component;
        }
        if (Character.TYPE.equals(clazz) || Boolean.TYPE.equals(clazz)) {
            return component;
        }
        Class<Number> numberClass = clazz;
        ((Validatable)component).addValidator((Validator)new MinimumMaximumValidator(numberClass, minimumValue, maximumValue));
        return component;
    }

    private static class MinimumMaximumValidator
    extends AbstractValidator<Number> {
        private Class<Number> mNumberType;
        private Object mMinimum;
        private Object mMaximum;

        public MinimumMaximumValidator(Class<Number> numberType, String minimum, String maximum) {
            super("");
            this.mNumberType = numberType;
            this.mMinimum = ClassUtils.parseNumber(numberType, minimum);
            this.mMaximum = ClassUtils.parseNumber(numberType, maximum);
            if (this.mMinimum == null) {
                this.setErrorMessage("Must be less than " + this.mMaximum);
            } else if (this.mMaximum == null) {
                this.setErrorMessage("Must be greater than " + this.mMinimum);
            } else {
                this.setErrorMessage("Must be between " + this.mMinimum + " and " + this.mMaximum);
            }
        }

        public boolean isValidValue(Number value) {
            if (value == null) {
                return !this.mNumberType.isPrimitive();
            }
            if (Byte.TYPE.equals(this.mNumberType) || Byte.class.equals(this.mNumberType)) {
                if (this.mMinimum != null && (Byte)value < (Byte)this.mMinimum) {
                    return false;
                }
                if (this.mMaximum != null && (Byte)value > (Byte)this.mMaximum) {
                    return false;
                }
            } else if (Short.TYPE.equals(this.mNumberType) || Short.class.equals(this.mNumberType)) {
                if (this.mMinimum != null && (Short)value < (Short)this.mMinimum) {
                    return false;
                }
                if (this.mMaximum != null && (Short)value > (Short)this.mMaximum) {
                    return false;
                }
            } else if (Integer.TYPE.equals(this.mNumberType) || Integer.class.equals(this.mNumberType)) {
                if (this.mMinimum != null && value.intValue() < (Integer)this.mMinimum) {
                    return false;
                }
                if (this.mMaximum != null && value.intValue() > (Integer)this.mMaximum) {
                    return false;
                }
            } else if (Long.TYPE.equals(this.mNumberType) || Long.class.equals(this.mNumberType)) {
                if (this.mMinimum != null && (Long)value < (Long)this.mMinimum) {
                    return false;
                }
                if (this.mMaximum != null && (Long)value > (Long)this.mMaximum) {
                    return false;
                }
            } else if (Float.TYPE.equals(this.mNumberType) || Float.class.equals(this.mNumberType)) {
                if (this.mMinimum != null && ((Float)value).floatValue() < ((Float)this.mMinimum).floatValue()) {
                    return false;
                }
                if (this.mMaximum != null && ((Float)value).floatValue() > ((Float)this.mMaximum).floatValue()) {
                    return false;
                }
            } else if (Double.TYPE.equals(this.mNumberType) || Double.class.equals(this.mNumberType)) {
                if (this.mMinimum != null && (Double)value < (Double)this.mMinimum) {
                    return false;
                }
                if (this.mMaximum != null && (Double)value > (Double)this.mMaximum) {
                    return false;
                }
            } else {
                throw WidgetProcessorException.newException(this.mNumberType + " cannot be validated within min/max");
            }
            return true;
        }

        public Class<Number> getType() {
            return this.mNumberType;
        }

        protected boolean isValidType(Object value) {
            return true;
        }
    }
}

