/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.impl.actionstyle.swing;

import java.awt.event.ActionEvent;
import java.lang.reflect.Method;
import org.jdesktop.application.Action;
import org.metawidget.inspector.iface.InspectorException;
import org.metawidget.inspector.impl.BaseTraitStyleConfig;
import org.metawidget.inspector.impl.actionstyle.MethodActionStyle;

public class SwingAppFrameworkActionStyle
extends MethodActionStyle {
    public SwingAppFrameworkActionStyle() {
        this(new BaseTraitStyleConfig());
    }

    public SwingAppFrameworkActionStyle(BaseTraitStyleConfig config) {
        super(config);
    }

    protected boolean matchAction(Method method) {
        if (method.getDeclaringClass().getPackage().getName().startsWith("org.jdesktop")) {
            return false;
        }
        Action action = method.getAnnotation(Action.class);
        if (action == null) {
            return false;
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length > 1) {
            throw InspectorException.newException("@Action " + method + " must not have more than one parameter");
        }
        if (parameterTypes.length == 1 && !parameterTypes[0].equals(ActionEvent.class)) {
            throw InspectorException.newException("@Action " + method + " parameter must be a " + ActionEvent.class.getName());
        }
        return true;
    }
}

