/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.statically;

import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.metawidget.iface.MetawidgetException;
import org.metawidget.statically.StaticMetawidget;
import org.metawidget.statically.StaticUtils;
import org.metawidget.statically.StaticWidget;
import org.metawidget.statically.StaticXmlWidget;
import org.metawidget.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StaticXmlMetawidget
extends StaticMetawidget
implements StaticXmlWidget {
    private Map<String, String> mAttributes;
    private String mTextContent;

    @Override
    public void putAttribute(String name, String value) {
        if (this.mAttributes == null) {
            this.mAttributes = CollectionUtils.newTreeMap();
        }
        this.mAttributes.put(name, value);
    }

    @Override
    public String getAttribute(String name) {
        if (this.mAttributes == null) {
            return null;
        }
        return this.mAttributes.get(name);
    }

    @Override
    public String getPrefix() {
        return "m";
    }

    @Override
    public Map<String, String> getAdditionalNamespaceURIs() {
        return null;
    }

    @Override
    public String getTextContent() {
        return this.mTextContent;
    }

    @Override
    public void setTextContent(String textContent) {
        this.mTextContent = textContent;
    }

    @Override
    public void write(Writer writer, int initialIndent) {
        super.write(writer, initialIndent);
        if (this.mTextContent != null) {
            Writer writerToUse = writer;
            if (initialIndent >= 0) {
                writerToUse = new StaticUtils.IndentedWriter(writer, initialIndent);
            }
            try {
                writerToUse.write(this.mTextContent);
            }
            catch (Exception e) {
                throw MetawidgetException.newException(e);
            }
        }
    }

    @Override
    public String getNamespaceURI() {
        return null;
    }

    public Map<String, String> getNamespaces() {
        HashMap<String, String> namespaces = CollectionUtils.newHashMap();
        this.populateNamespaces(this, namespaces);
        return namespaces;
    }

    private void populateNamespaces(StaticXmlWidget xmlWidget, Map<String, String> namespaces) {
        for (StaticWidget child : xmlWidget.getChildren()) {
            StaticXmlWidget xmlChild = (StaticXmlWidget)child;
            String prefix = xmlChild.getPrefix();
            String namespaceURI = xmlChild.getNamespaceURI();
            if (prefix != null && namespaceURI != null) {
                namespaces.put(prefix, namespaceURI);
            }
            if (xmlChild.getAdditionalNamespaceURIs() != null) {
                namespaces.putAll(xmlChild.getAdditionalNamespaceURIs());
            }
            this.populateNamespaces(xmlChild, namespaces);
        }
    }
}

