/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.vaadin.ui.widgetprocessor.binding.reflection;

import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Map;
import org.metawidget.util.ClassUtils;
import org.metawidget.util.WidgetBuilderUtils;
import org.metawidget.util.simple.PathUtils;
import org.metawidget.vaadin.ui.Stub;
import org.metawidget.vaadin.ui.VaadinMetawidget;
import org.metawidget.widgetprocessor.iface.WidgetProcessor;
import org.metawidget.widgetprocessor.iface.WidgetProcessorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionBindingProcessor
implements WidgetProcessor<Component, VaadinMetawidget>,
Serializable {
    @Override
    public Component processWidget(Component component, String elementName, Map<String, String> attributes, VaadinMetawidget metawidget) {
        String[] names;
        if (!"action".equals(elementName)) {
            return component;
        }
        if (component instanceof Stub) {
            return component;
        }
        if (!(component instanceof Button)) {
            throw WidgetProcessorException.newException("ReflectionBindingProcessor only supports binding actions to Buttons");
        }
        if (WidgetBuilderUtils.isReadOnly(attributes)) {
            return component;
        }
        if (metawidget == null) {
            return component;
        }
        Object toInspect = metawidget.getToInspect();
        if (toInspect == null) {
            return component;
        }
        Button button = (Button)component;
        for (String name : names = PathUtils.parsePath(metawidget.getPath()).getNamesAsArray()) {
            if ((toInspect = ClassUtils.getProperty(toInspect, name)) != null) continue;
            return component;
        }
        final Object fireActionOn = toInspect;
        final Class<?> fireActionOnClass = fireActionOn.getClass();
        final String actionName = attributes.get("name");
        button.addListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent event) {
                try {
                    Method method = fireActionOnClass.getMethod(actionName, null);
                    method.invoke(fireActionOn, (Object[])null);
                }
                catch (Exception e) {
                    throw WidgetProcessorException.newException(e);
                }
            }
        });
        return component;
    }
}

