// Metawidget
//
// This file is dual licensed under both the LGPL
// (http://www.gnu.org/licenses/lgpl-2.1.html) and the EPL
// (http://www.eclipse.org/org/documents/epl-v10.php). As a
// recipient of Metawidget, you may choose to receive it under either
// the LGPL or the EPL.
//
// Commercial licenses are also available. See http://metawidget.org
// for details.

package org.metawidget.statically.faces.component.html.layout;

import org.metawidget.util.simple.ObjectUtils;

/**
 * Configures a HtmlPanelGridLayout prior to use. Once instantiated, Layouts are immutable.
 *
 * @author <a href="http://kennardconsulting.com">Richard Kennard</a>
 */

public class HtmlPanelGridLayoutConfig {

	//
	// Private members
	//

	private String[]	mColumnStyleClasses;

	private String		mMessageStyleClass;

	//
	// Public methods
	//

	/**
	 * Array of CSS style classes to apply to table columns in order of: label column, component
	 * column, required column.
	 *
	 * @return this, as part of a fluent interface
	 */

	public HtmlPanelGridLayoutConfig setColumnStyleClasses( String... columnStyleClasses ) {

		mColumnStyleClasses = columnStyleClasses;

		return this;
	}

	/**
	 * CSS style class to apply to <tt>h:message</tt>
	 *
	 * @return this, as part of a fluent interface
	 */

	public HtmlPanelGridLayoutConfig setMessageStyleClass( String messageStyleClass ) {

		mMessageStyleClass = messageStyleClass;

		return this;
	}

	@Override
	public boolean equals( Object that ) {

		if ( this == that ) {
			return true;
		}

		if ( !ObjectUtils.nullSafeClassEquals( this, that ) ) {
			return false;
		}

		if ( !ObjectUtils.nullSafeEquals( mColumnStyleClasses, ( (HtmlPanelGridLayoutConfig) that ).mColumnStyleClasses ) ) {
			return false;
		}

		if ( !ObjectUtils.nullSafeEquals( mMessageStyleClass, ( (HtmlPanelGridLayoutConfig) that ).mMessageStyleClass ) ) {
			return false;
		}

		return true;
	}

	@Override
	public int hashCode() {

		int hashCode = 1;
		hashCode = 31 * hashCode + ObjectUtils.nullSafeHashCode( mColumnStyleClasses );
		hashCode = 31 * hashCode + ObjectUtils.nullSafeHashCode( mMessageStyleClass );

		return hashCode;
	}

	//
	// Protected methods
	//

	protected String[] getColumnStyleClasses() {

		return mColumnStyleClasses;
	}

	protected String getMessageStyleClass() {

		return mMessageStyleClass;
	}
}
