/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.composite;

import org.metawidget.inspector.composite.CompositeInspectorConfig;
import org.metawidget.inspector.iface.DomInspector;
import org.metawidget.inspector.iface.Inspector;
import org.metawidget.inspector.iface.InspectorException;
import org.metawidget.util.ArrayUtils;
import org.metawidget.util.LogUtils;
import org.metawidget.util.XmlUtils;
import org.metawidget.util.simple.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeInspector
implements DomInspector<Element> {
    private static final LogUtils.Log LOG = LogUtils.getLog(CompositeInspector.class);
    final Inspector[] mInspectors;

    public CompositeInspector(CompositeInspectorConfig config) {
        Inspector[] inspectors = config.getInspectors();
        if (inspectors == null || inspectors.length == 0) {
            throw InspectorException.newException("CompositeInspector needs at least one Inspector");
        }
        this.mInspectors = new Inspector[inspectors.length];
        int length = inspectors.length;
        for (int loop = 0; loop < length; ++loop) {
            Inspector inspector = inspectors[loop];
            for (int checkDuplicates = 0; checkDuplicates < loop; ++checkDuplicates) {
                if (!this.mInspectors[checkDuplicates].equals(inspector)) continue;
                throw InspectorException.newException("CompositeInspector's list of Inspectors contains two of the same " + inspector.getClass().getName());
            }
            this.mInspectors[loop] = inspector;
        }
    }

    @Override
    public final String inspect(Object toInspect, String type, String ... names) {
        return this.inspect(null, toInspect, type, names);
    }

    public final String inspect(String master, Object toInspect, String type, String ... names) {
        Element element = this.inspectAsDom(XmlUtils.documentFromString(master), toInspect, type, names);
        if (element == null) {
            return null;
        }
        return XmlUtils.nodeToString((Node)element, false);
    }

    @Override
    public final Element inspectAsDom(Object toInspect, String type, String ... names) {
        return this.inspectAsDom(null, toInspect, type, names);
    }

    public Element inspectAsDom(Document masterDocument, Object toInspect, String type, String ... names) {
        try {
            Document masterDocumentToUse = this.runInspectors(masterDocument, toInspect, type, names);
            if (masterDocumentToUse == null || !masterDocumentToUse.hasChildNodes()) {
                if (toInspect != null && type != null && LOG.isWarnEnabled()) {
                    LOG.warn("No inspectors matched path == {0}{1}", type, ArrayUtils.toString(names, StringUtils.SEPARATOR_FORWARD_SLASH, true, false));
                }
                return null;
            }
            if (LOG.isDebugEnabled()) {
                String formattedXml = XmlUtils.documentToString(masterDocumentToUse, true);
                LOG.debug("Inspected {0}{1}\r\n{2}", type, ArrayUtils.toString(names, StringUtils.SEPARATOR_FORWARD_SLASH, true, false), formattedXml);
            }
            Element root = masterDocumentToUse.getDocumentElement();
            if (toInspect != null && type != null && LOG.isWarnEnabled() && !root.hasChildNodes()) {
                LOG.warn("No inspectors matched path == {0}{1}", type, ArrayUtils.toString(names, StringUtils.SEPARATOR_FORWARD_SLASH, true, false));
                return root;
            }
            return root;
        }
        catch (Exception e) {
            throw InspectorException.newException(e);
        }
    }

    protected Document runInspectors(Document masterDocument, Object toInspect, String type, String ... names) throws Exception {
        Document masterDocumentToUse = masterDocument;
        for (Inspector inspector : this.mInspectors) {
            Document inspectionDocument = this.runInspector(inspector, toInspect, type, names);
            masterDocumentToUse = this.combineInspectionResult(masterDocumentToUse, inspectionDocument);
        }
        return masterDocumentToUse;
    }

    protected Document runInspector(Inspector inspector, Object toInspect, String type, String ... names) throws Exception {
        if (inspector instanceof DomInspector) {
            DomInspector domInspector = (DomInspector)inspector;
            Element element = (Element)domInspector.inspectAsDom(toInspect, type, names);
            if (element == null) {
                return null;
            }
            if (LOG.isTraceEnabled()) {
                String xml = XmlUtils.nodeToString((Node)element, true);
                LOG.trace("{0} inspected {1}{2}\r\n{3}", inspector.getClass(), type, ArrayUtils.toString(names, StringUtils.SEPARATOR_FORWARD_SLASH, true, false), xml);
            }
            return element.getOwnerDocument();
        }
        String xml = inspector.inspect(toInspect, type, names);
        if (xml == null) {
            return null;
        }
        LOG.trace("{0} inspected {1}{2}\r\n{3}", inspector.getClass(), type, ArrayUtils.toString(names, StringUtils.SEPARATOR_FORWARD_SLASH, true, false), xml);
        return XmlUtils.documentFromString(xml);
    }

    protected Document combineInspectionResult(Document masterDocument, Document inspectionDocument) {
        if (inspectionDocument == null || !inspectionDocument.hasChildNodes()) {
            return masterDocument;
        }
        if (masterDocument == null || !masterDocument.hasChildNodes()) {
            return inspectionDocument;
        }
        XmlUtils.combineElements(masterDocument.getDocumentElement(), inspectionDocument.getDocumentElement(), "type", "name");
        return masterDocument;
    }
}

