/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.jsp.tagext.html.widgetbuilder.struts;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.jsp.tagext.BodyTag;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.struts.taglib.html.CheckboxTag;
import org.apache.struts.taglib.html.OptionTag;
import org.apache.struts.taglib.html.OptionsTag;
import org.apache.struts.taglib.html.PasswordTag;
import org.apache.struts.taglib.html.SelectTag;
import org.apache.struts.taglib.html.TextTag;
import org.apache.struts.taglib.html.TextareaTag;
import org.metawidget.jsp.JspUtils;
import org.metawidget.jsp.tagext.MetawidgetTag;
import org.metawidget.jsp.tagext.html.HtmlStubTag;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.WidgetBuilderUtils;
import org.metawidget.widgetbuilder.iface.WidgetBuilder;
import org.metawidget.widgetbuilder.iface.WidgetBuilderException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StrutsWidgetBuilder
implements WidgetBuilder<Tag, MetawidgetTag> {
    private static final List<Boolean> LIST_BOOLEAN_VALUES = CollectionUtils.unmodifiableList(Boolean.TRUE, Boolean.FALSE);

    @Override
    public Tag buildWidget(String elementName, Map<String, String> attributes, MetawidgetTag metawidget) {
        if ("true".equals(attributes.get("hidden"))) {
            attributes.put("metawidget-needs-hidden-field", "true");
            return new HtmlStubTag();
        }
        if ("action".equals(elementName)) {
            return new HtmlStubTag();
        }
        Class<?> clazz = WidgetBuilderUtils.getActualClassOrType(attributes, String.class);
        if (Boolean.class.equals(clazz) && "true".equals(attributes.get("required"))) {
            return new CheckboxTag();
        }
        String strutsLookup = attributes.get("struts-lookup-name");
        if (strutsLookup != null) {
            return this.createSelectTag(strutsLookup, attributes.get("struts-lookup-property"), attributes);
        }
        String lookup = attributes.get("lookup");
        if (lookup != null && !"".equals(lookup)) {
            return this.createSelectTag(CollectionUtils.fromString(lookup), CollectionUtils.fromString(attributes.get("lookup-labels")), attributes);
        }
        if (clazz != null) {
            if (clazz.isPrimitive()) {
                if (Boolean.TYPE.equals(clazz)) {
                    return new CheckboxTag();
                }
                if (Character.TYPE.equals(clazz)) {
                    TextTag textTag = new TextTag();
                    textTag.setMaxlength("1");
                    return textTag;
                }
                return this.createTextTag(attributes);
            }
            if (String.class.equals(clazz)) {
                if ("true".equals(attributes.get("masked"))) {
                    PasswordTag passwordTag = new PasswordTag();
                    String maximumLength = attributes.get("maximum-length");
                    if (maximumLength != null) {
                        passwordTag.setMaxlength(maximumLength);
                    }
                    return passwordTag;
                }
                if ("true".equals(attributes.get("large"))) {
                    return new TextareaTag();
                }
                return this.createTextTag(attributes);
            }
            if (Character.class.equals(clazz)) {
                TextTag textTag = new TextTag();
                textTag.setMaxlength("1");
                return textTag;
            }
            if (Date.class.equals(clazz)) {
                return this.createTextTag(attributes);
            }
            if (Boolean.class.equals(clazz)) {
                return this.createSelectTag(LIST_BOOLEAN_VALUES, null, attributes);
            }
            if (Number.class.isAssignableFrom(clazz)) {
                return this.createTextTag(attributes);
            }
            if (Collection.class.isAssignableFrom(clazz)) {
                return new HtmlStubTag();
            }
        }
        if ("true".equals(attributes.get("dont-expand"))) {
            return this.createTextTag(attributes);
        }
        return null;
    }

    private TextTag createTextTag(Map<String, String> attributes) {
        TextTag textTag = new TextTag();
        String maximumLength = attributes.get("maximum-length");
        if (maximumLength != null) {
            textTag.setMaxlength(maximumLength);
        }
        return textTag;
    }

    private Tag createSelectTag(String name, String property, Map<String, String> attributes) {
        String labelProperty;
        SelectTag select = new SelectTag();
        if (WidgetBuilderUtils.needsEmptyLookupItem(attributes)) {
            OptionTag emptyOption = new OptionTag();
            emptyOption.setValue("");
            JspUtils.addDeferredChild((TagSupport)select, (Tag)emptyOption);
        }
        OptionsTag optionsTag = new OptionsTag();
        optionsTag.setName(name);
        optionsTag.setProperty(property);
        String labelName = attributes.get("struts-lookup-label-name");
        if (labelName != null) {
            optionsTag.setLabelName(labelName);
        }
        if ((labelProperty = attributes.get("struts-lookup-label-property")) != null) {
            optionsTag.setLabelProperty(labelProperty);
        }
        JspUtils.addDeferredChild((TagSupport)select, (Tag)optionsTag);
        return select;
    }

    private Tag createSelectTag(List<?> values, List<String> labels, Map<String, String> attributes) {
        if (labels != null && !labels.isEmpty() && labels.size() != values.size()) {
            throw WidgetBuilderException.newException("Labels list must be same size as values list");
        }
        SelectTag select = new SelectTag();
        if (WidgetBuilderUtils.needsEmptyLookupItem(attributes)) {
            OptionTag emptyOption = new OptionTag();
            emptyOption.setValue("");
            JspUtils.addDeferredChild((TagSupport)select, (Tag)emptyOption);
        }
        int length = values.size();
        for (int loop = 0; loop < length; ++loop) {
            OptionTag optionTag = new OptionTag();
            optionTag.setValue(String.valueOf(values.get(loop)));
            if (labels != null && !labels.isEmpty()) {
                JspUtils.setBodyContent((BodyTag)optionTag, labels.get(loop));
            }
            JspUtils.addDeferredChild((TagSupport)select, (Tag)optionTag);
        }
        return select;
    }
}

