/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.test.model.annotatedaddressbook;

import java.util.Set;
import org.metawidget.inspector.annotation.UiAttribute;
import org.metawidget.inspector.annotation.UiComesAfter;
import org.metawidget.inspector.annotation.UiHidden;
import org.metawidget.inspector.annotation.UiLarge;
import org.metawidget.inspector.annotation.UiRequired;
import org.metawidget.inspector.annotation.UiSection;
import org.metawidget.test.model.annotatedaddressbook.Address;
import org.metawidget.test.model.annotatedaddressbook.Communication;
import org.metawidget.test.model.annotatedaddressbook.Gender;
import org.metawidget.util.simple.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Contact
implements Comparable<Contact> {
    private long mId;
    private String mTitle;
    private String mFirstname;
    private String mSurname;
    private Gender mGender;
    private Address mAddress;
    private Set<Communication> mCommunications;
    private String mNotes;

    public Contact() {
        this(null, null, null);
    }

    public Contact(String title, String firstname, String surname) {
        this.mTitle = title;
        this.mFirstname = firstname;
        this.mSurname = surname;
        this.mAddress = new Address();
        this.mAddress.setOwner(this);
    }

    @UiHidden
    public long getId() {
        return this.mId;
    }

    public void setId(long id) {
        this.mId = id;
    }

    @UiRequired
    public String getTitle() {
        return this.mTitle;
    }

    public void setTitle(String title) {
        this.mTitle = title;
    }

    @UiComesAfter(value={"title"})
    @UiRequired
    public String getFirstname() {
        return this.mFirstname;
    }

    public void setFirstname(String firstname) {
        this.mFirstname = firstname;
    }

    @UiComesAfter(value={"firstname"})
    @UiRequired
    @UiAttribute(name={"maximum-length"}, value="50")
    public String getSurname() {
        return this.mSurname;
    }

    public void setSurname(String surname) {
        this.mSurname = surname;
    }

    @UiHidden
    public String getFullname() {
        StringBuilder builder = new StringBuilder();
        if (this.mTitle != null) {
            builder.append(this.mTitle);
        }
        if (this.mFirstname != null) {
            if (builder.length() > 0) {
                builder.append(' ');
            }
            builder.append(this.mFirstname);
        }
        if (this.mSurname != null) {
            if (builder.length() > 0) {
                builder.append(' ');
            }
            builder.append(this.mSurname);
        }
        return builder.toString();
    }

    @UiComesAfter(value={"dateOfBirth", "surname", "company"})
    public Gender getGender() {
        return this.mGender;
    }

    public void setGender(Gender gender) {
        this.mGender = gender;
    }

    @UiComesAfter(value={"gender"})
    @UiSection(value={"Contact Details"})
    public Address getAddress() {
        return this.mAddress;
    }

    public void setAddress(Address address) {
        this.mAddress = address;
    }

    @UiComesAfter(value={"address"})
    public Set<Communication> getCommunications() {
        return this.mCommunications;
    }

    public void setCommunications(Set<Communication> communications) {
        this.mCommunications = communications;
    }

    @UiComesAfter
    @UiSection(value={"Other"})
    @UiLarge
    public String getNotes() {
        return this.mNotes;
    }

    public void setNotes(String notes) {
        this.mNotes = notes;
    }

    @Override
    public int compareTo(Contact that) {
        return ObjectUtils.nullSafeCompareTo((Comparable)((Object)this.getFirstname()), (Object)that.getFirstname());
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!ObjectUtils.nullSafeClassEquals((Object)this, (Object)that)) {
            return false;
        }
        Contact contactThat = (Contact)that;
        if (this.mId == 0L) {
            if (contactThat.mId != 0L) {
                return false;
            }
            return super.equals(contactThat);
        }
        return this.mId == contactThat.mId;
    }

    public int hashCode() {
        if (this.mId == 0L) {
            return super.hashCode();
        }
        int hashCode = 1;
        hashCode = 31 * hashCode + (int)(this.mId ^ this.mId >>> 32);
        return hashCode;
    }

    public String toString() {
        return this.getFullname();
    }
}

