/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.impl.actionstyle.metawidget;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import junit.framework.TestCase;
import org.metawidget.inspector.annotation.UiAction;
import org.metawidget.inspector.iface.InspectorException;
import org.metawidget.inspector.impl.BaseTraitStyle;
import org.metawidget.inspector.impl.actionstyle.Action;
import org.metawidget.inspector.impl.actionstyle.metawidget.MetawidgetActionStyle;
import org.metawidget.inspector.impl.actionstyle.metawidget.MetawidgetActionStyleTest$Proxied_$;
import org.metawidget.util.CollectionUtils;

public class MetawidgetActionStyleTest
extends TestCase {
    public void testMetawidgetActionStyle() {
        MetawidgetActionStyle actionStyle = new MetawidgetActionStyle();
        Map actions = actionStyle.getActions(Foo.class.getName());
        MetawidgetActionStyleTest.assertEquals((int)actions.size(), (int)1);
        MetawidgetActionStyleTest.assertEquals((String)"bar", (String)((Action)actions.get("bar")).toString());
        try {
            actionStyle.getActions(BadFoo.class.getName());
            MetawidgetActionStyleTest.fail();
        }
        catch (InspectorException e) {
            MetawidgetActionStyleTest.assertEquals((String)"@UiAction public abstract void org.metawidget.inspector.impl.actionstyle.metawidget.MetawidgetActionStyleTest$BadFoo.bar(java.lang.String) must not take any parameters", (String)e.getMessage());
        }
    }

    public void testInterfaceBasedActionStyle() {
        MetawidgetActionStyle actionStyle = new MetawidgetActionStyle();
        Map actions = actionStyle.getActions(Proxied_$$_javassist_.class.getName());
        MetawidgetActionStyleTest.assertTrue((boolean)(actions instanceof TreeMap));
        MetawidgetActionStyleTest.assertTrue((boolean)((Action)actions.get("bar1")).isAnnotationPresent(UiAction.class));
        MetawidgetActionStyleTest.assertTrue((boolean)((Action)actions.get("baz")).isAnnotationPresent(UiAction.class));
        MetawidgetActionStyleTest.assertEquals((int)actions.size(), (int)2);
        actions = actionStyle.getActions(new InterfaceBar(){

            public void baz() {
            }
        }.getClass().getName());
        MetawidgetActionStyleTest.assertTrue((boolean)(actions instanceof TreeMap));
        MetawidgetActionStyleTest.assertTrue((boolean)((Action)actions.get("baz")).isAnnotationPresent(UiAction.class));
        MetawidgetActionStyleTest.assertEquals((int)actions.size(), (int)1);
    }

    public void testIsExcluded() {
        final ArrayList isExcluded = CollectionUtils.newArrayList();
        MetawidgetActionStyle actionStyle = new MetawidgetActionStyle(){

            protected boolean isExcludedBaseType(Class<?> classToExclude) {
                isExcluded.add(classToExclude);
                return super.isExcludedBaseType(classToExclude);
            }

            protected boolean isExcludedReturnType(Class<?> clazz) {
                isExcluded.add(clazz);
                return super.isExcludedReturnType(clazz);
            }

            protected boolean isExcludedName(String name) {
                isExcluded.add(name);
                return super.isExcludedName(name);
            }
        };
        actionStyle.getActions(Proxied_$$_javassist_.class.getName());
        MetawidgetActionStyleTest.assertEquals(InterfaceFoo.class, isExcluded.get(0));
        MetawidgetActionStyleTest.assertEquals(Void.TYPE, isExcluded.get(1));
        MetawidgetActionStyleTest.assertEquals((Object)"bar1", isExcluded.get(2));
        MetawidgetActionStyleTest.assertEquals(InterfaceBar.class, isExcluded.get(3));
        MetawidgetActionStyleTest.assertEquals(Void.TYPE, isExcluded.get(4));
        MetawidgetActionStyleTest.assertEquals((Object)"baz", isExcluded.get(5));
        MetawidgetActionStyleTest.assertEquals((int)6, (int)isExcluded.size());
    }

    public void testClearCache() throws Exception {
        MetawidgetActionStyle actionStyle = new MetawidgetActionStyle();
        Field propertiesCacheField = BaseTraitStyle.class.getDeclaredField("mCache");
        propertiesCacheField.setAccessible(true);
        MetawidgetActionStyleTest.assertEquals((int)0, (int)((Map)propertiesCacheField.get(actionStyle)).size());
        actionStyle.getActions(Foo.class.getName());
        MetawidgetActionStyleTest.assertEquals((int)1, (int)((Map)propertiesCacheField.get(actionStyle)).size());
        actionStyle.clearCache();
        MetawidgetActionStyleTest.assertEquals((int)0, (int)((Map)propertiesCacheField.get(actionStyle)).size());
    }

    static interface InterfaceBar {
        @UiAction
        public void baz();
    }

    static interface InterfaceFoo {
        @UiAction
        public void bar1();

        public void bar2();
    }

    abstract class BadFoo {
        BadFoo() {
        }

        @UiAction
        public abstract void bar(String var1);
    }

    abstract class Foo {
        Foo() {
        }

        @UiAction
        public abstract void bar();

        @UiAction
        protected abstract void shouldntFindMe();

        @UiAction
        private void shouldntFindMeEither() {
        }
    }
}

