/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.annotation;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import junit.framework.TestCase;
import org.metawidget.inspector.annotation.MetawidgetAnnotationInspector;
import org.metawidget.inspector.annotation.UiAction;
import org.metawidget.inspector.annotation.UiAttribute;
import org.metawidget.inspector.annotation.UiAttributes;
import org.metawidget.inspector.annotation.UiComesAfter;
import org.metawidget.inspector.annotation.UiDontExpand;
import org.metawidget.inspector.annotation.UiHidden;
import org.metawidget.inspector.annotation.UiLabel;
import org.metawidget.inspector.annotation.UiLarge;
import org.metawidget.inspector.annotation.UiLookup;
import org.metawidget.inspector.annotation.UiMasked;
import org.metawidget.inspector.annotation.UiReadOnly;
import org.metawidget.inspector.annotation.UiRequired;
import org.metawidget.inspector.annotation.UiSection;
import org.metawidget.inspector.annotation.UiWide;
import org.metawidget.inspector.iface.InspectorException;
import org.metawidget.inspector.impl.BaseObjectInspector;
import org.metawidget.inspector.impl.BaseObjectInspectorConfig;
import org.metawidget.inspector.impl.propertystyle.PropertyStyle;
import org.metawidget.inspector.impl.propertystyle.javabean.JavaBeanPropertyStyle;
import org.metawidget.test.model.annotatedaddressbook.Address;
import org.metawidget.util.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MetawidgetAnnotationInspectorTest
extends TestCase {
    private MetawidgetAnnotationInspector mInspector;

    public void setUp() {
        this.mInspector = new MetawidgetAnnotationInspector();
    }

    public void testInspection() {
        String inspect = this.mInspector.inspect((Object)new Address(), Address.class.getName(), new String[0]);
        this.internalTestInspection(XmlUtils.documentFromString((String)inspect));
        Element domInspect = this.mInspector.inspectAsDom((Object)new Address(), Address.class.getName(), new String[0]);
        MetawidgetAnnotationInspectorTest.assertEquals((String)inspect, (String)XmlUtils.nodeToString((Node)domInspect, (boolean)false));
        this.internalTestInspection(domInspect.getOwnerDocument());
    }

    private void internalTestInspection(Document document) {
        MetawidgetAnnotationInspectorTest.assertEquals((String)"inspection-result", (String)document.getFirstChild().getNodeName());
        Element entity = (Element)document.getDocumentElement().getFirstChild();
        MetawidgetAnnotationInspectorTest.assertEquals((String)"entity", (String)entity.getNodeName());
        MetawidgetAnnotationInspectorTest.assertEquals((String)Address.class.getName(), (String)entity.getAttribute("type"));
        MetawidgetAnnotationInspectorTest.assertFalse((boolean)entity.hasAttribute("name"));
        Element property = (Element)entity.getFirstChild();
        MetawidgetAnnotationInspectorTest.assertEquals((String)"property", (String)property.getNodeName());
        MetawidgetAnnotationInspectorTest.assertEquals((String)"city", (String)property.getAttribute("name"));
        property = (Element)property.getNextSibling();
        MetawidgetAnnotationInspectorTest.assertEquals((String)"property", (String)property.getNodeName());
        MetawidgetAnnotationInspectorTest.assertEquals((String)"owner", (String)property.getAttribute("name"));
        MetawidgetAnnotationInspectorTest.assertEquals((String)"true", (String)property.getAttribute("hidden"));
        property = (Element)property.getNextSibling();
        MetawidgetAnnotationInspectorTest.assertEquals((String)"property", (String)property.getNodeName());
        MetawidgetAnnotationInspectorTest.assertEquals((String)"postcode", (String)property.getAttribute("name"));
        property = (Element)property.getNextSibling();
        MetawidgetAnnotationInspectorTest.assertEquals((String)"property", (String)property.getNodeName());
        MetawidgetAnnotationInspectorTest.assertEquals((String)"state", (String)property.getAttribute("name"));
        MetawidgetAnnotationInspectorTest.assertEquals((String)"Anytown,Cyberton,Lostville,Whereverton", (String)property.getAttribute("lookup"));
        property = (Element)property.getNextSibling();
        MetawidgetAnnotationInspectorTest.assertEquals((String)"property", (String)property.getNodeName());
        MetawidgetAnnotationInspectorTest.assertEquals((String)"street", (String)property.getAttribute("name"));
    }

    public void testImaginaryEntity() {
        String xml = this.mInspector.inspect((Object)new Foo(), Foo.class.getName(), new String[0]);
        Document document = XmlUtils.documentFromString((String)xml);
        MetawidgetAnnotationInspectorTest.assertEquals((String)"inspection-result", (String)document.getFirstChild().getNodeName());
        Element entity = (Element)document.getDocumentElement().getFirstChild();
        MetawidgetAnnotationInspectorTest.assertEquals((String)"entity", (String)entity.getNodeName());
        MetawidgetAnnotationInspectorTest.assertEquals((String)Foo.class.getName(), (String)entity.getAttribute("type"));
        Element property = (Element)entity.getFirstChild().getNextSibling();
        MetawidgetAnnotationInspectorTest.assertEquals((String)"property", (String)property.getNodeName());
        MetawidgetAnnotationInspectorTest.assertEquals((String)"string1", (String)property.getAttribute("name"));
        MetawidgetAnnotationInspectorTest.assertEquals((String)"bar", (String)property.getAttribute("label"));
        MetawidgetAnnotationInspectorTest.assertEquals((String)"bar1", (String)property.getAttribute("foo1"));
        MetawidgetAnnotationInspectorTest.assertEquals((String)"bar2", (String)property.getAttribute("foo2"));
        MetawidgetAnnotationInspectorTest.assertEquals((String)"true", (String)property.getAttribute("read-only"));
        MetawidgetAnnotationInspectorTest.assertEquals((String)"true", (String)property.getAttribute("hidden"));
        MetawidgetAnnotationInspectorTest.assertEquals((String)"Foo", (String)property.getAttribute("section"));
        MetawidgetAnnotationInspectorTest.assertEquals((String)"true", (String)property.getAttribute("masked"));
        MetawidgetAnnotationInspectorTest.assertEquals((String)"true", (String)property.getAttribute("dont-expand"));
        MetawidgetAnnotationInspectorTest.assertEquals((String)"true", (String)property.getAttribute("large"));
        MetawidgetAnnotationInspectorTest.assertEquals((String)"object1", (String)property.getAttribute("comes-after"));
        MetawidgetAnnotationInspectorTest.assertEquals((int)11, (int)property.getAttributes().getLength());
        property = XmlUtils.getNextSiblingElement((Element)property);
        MetawidgetAnnotationInspectorTest.assertEquals((String)"property", (String)property.getNodeName());
        MetawidgetAnnotationInspectorTest.assertEquals((String)"string2", (String)property.getAttribute("name"));
        MetawidgetAnnotationInspectorTest.assertEquals((String)"abc-def", (String)property.getAttribute("abc"));
        MetawidgetAnnotationInspectorTest.assertEquals((String)"abc-def", (String)property.getAttribute("def"));
        MetawidgetAnnotationInspectorTest.assertEquals((String)"ghi-jkl", (String)property.getAttribute("ghi"));
        MetawidgetAnnotationInspectorTest.assertEquals((String)"ghi-jkl", (String)property.getAttribute("jkl"));
        MetawidgetAnnotationInspectorTest.assertEquals((String)"mno-pqr", (String)property.getAttribute("mno"));
        MetawidgetAnnotationInspectorTest.assertEquals((String)"mno-pqr", (String)property.getAttribute("pqr"));
        MetawidgetAnnotationInspectorTest.assertEquals((int)7, (int)property.getAttributes().getLength());
        Element action = XmlUtils.getNextSiblingElement((Element)property);
        MetawidgetAnnotationInspectorTest.assertEquals((String)"action", (String)action.getNodeName());
        MetawidgetAnnotationInspectorTest.assertEquals((String)"doNothing", (String)action.getAttribute("name"));
        MetawidgetAnnotationInspectorTest.assertEquals((String)"Bar", (String)action.getAttribute("section"));
        MetawidgetAnnotationInspectorTest.assertEquals((String)"string1", (String)action.getAttribute("comes-after"));
        MetawidgetAnnotationInspectorTest.assertEquals((int)3, (int)action.getAttributes().getLength());
        MetawidgetAnnotationInspectorTest.assertEquals(null, (Object)action.getNextSibling());
    }

    public void testLookup() {
        MetawidgetAnnotationInspector inspector = new MetawidgetAnnotationInspector();
        Document document = XmlUtils.documentFromString((String)inspector.inspect((Object)new Foo(), Foo.class.getName(), new String[0]));
        MetawidgetAnnotationInspectorTest.assertEquals((String)"inspection-result", (String)document.getFirstChild().getNodeName());
        Element entity = (Element)document.getDocumentElement().getFirstChild();
        MetawidgetAnnotationInspectorTest.assertEquals((String)"entity", (String)entity.getNodeName());
        MetawidgetAnnotationInspectorTest.assertEquals((String)Foo.class.getName(), (String)entity.getAttribute("type"));
        MetawidgetAnnotationInspectorTest.assertFalse((boolean)entity.hasAttribute("name"));
        Element property = (Element)entity.getFirstChild();
        MetawidgetAnnotationInspectorTest.assertEquals((String)"property", (String)property.getNodeName());
        MetawidgetAnnotationInspectorTest.assertEquals((String)"object1", (String)property.getAttribute("name"));
        MetawidgetAnnotationInspectorTest.assertEquals((String)"foo\\,,bar", (String)property.getAttribute("lookup"));
        MetawidgetAnnotationInspectorTest.assertEquals((String)"true", (String)property.getAttribute("required"));
        MetawidgetAnnotationInspectorTest.assertEquals((String)"true", (String)property.getAttribute("wide"));
        MetawidgetAnnotationInspectorTest.assertEquals((int)property.getAttributes().getLength(), (int)4);
        property = (Element)property.getNextSibling();
        MetawidgetAnnotationInspectorTest.assertEquals((String)"string1", (String)property.getAttribute("name"));
        MetawidgetAnnotationInspectorTest.assertEquals((String)"bar", (String)property.getAttribute("label"));
        MetawidgetAnnotationInspectorTest.assertEquals((String)"bar1", (String)property.getAttribute("foo1"));
        MetawidgetAnnotationInspectorTest.assertEquals((String)"bar2", (String)property.getAttribute("foo2"));
        MetawidgetAnnotationInspectorTest.assertEquals((String)"true", (String)property.getAttribute("hidden"));
        MetawidgetAnnotationInspectorTest.assertEquals((String)"true", (String)property.getAttribute("read-only"));
        MetawidgetAnnotationInspectorTest.assertEquals((String)"true", (String)property.getAttribute("dont-expand"));
        MetawidgetAnnotationInspectorTest.assertEquals((String)"Foo", (String)property.getAttribute("section"));
        MetawidgetAnnotationInspectorTest.assertEquals((String)"true", (String)property.getAttribute("masked"));
        MetawidgetAnnotationInspectorTest.assertEquals((String)"true", (String)property.getAttribute("large"));
        MetawidgetAnnotationInspectorTest.assertEquals((String)"object1", (String)property.getAttribute("comes-after"));
        MetawidgetAnnotationInspectorTest.assertEquals((int)property.getAttributes().getLength(), (int)11);
    }

    public void testBadAction() {
        try {
            this.mInspector.inspect((Object)new BadAction1(), BadAction1.class.getName(), new String[0]);
            MetawidgetAnnotationInspectorTest.fail();
        }
        catch (InspectorException e) {
            MetawidgetAnnotationInspectorTest.assertEquals((String)"@UiAction public void org.metawidget.inspector.annotation.MetawidgetAnnotationInspectorTest$BadAction1.doNothing(java.lang.String) must not take any parameters", (String)e.getMessage());
        }
    }

    public void testInspectString() {
        MetawidgetAnnotationInspectorTest.assertEquals(null, (String)this.mInspector.inspect((Object)"foo", String.class.getName(), new String[0]));
        String xml = this.mInspector.inspect((Object)new Foo(), Foo.class.getName(), new String[]{"string1"});
        Document document = XmlUtils.documentFromString((String)xml);
        MetawidgetAnnotationInspectorTest.assertEquals((String)"inspection-result", (String)document.getFirstChild().getNodeName());
        Element entity = (Element)document.getDocumentElement().getFirstChild();
        MetawidgetAnnotationInspectorTest.assertEquals((String)"entity", (String)entity.getNodeName());
        MetawidgetAnnotationInspectorTest.assertEquals((String)String.class.getName(), (String)entity.getAttribute("type"));
        MetawidgetAnnotationInspectorTest.assertEquals((String)"string1", (String)entity.getAttribute("name"));
        MetawidgetAnnotationInspectorTest.assertEquals((String)"bar", (String)entity.getAttribute("label"));
    }

    public void testInspectParent() {
        MetawidgetAnnotationInspector inspector = new MetawidgetAnnotationInspector();
        Document document = XmlUtils.documentFromString((String)inspector.inspect((Object)new PropertyAndTraitAnnotation(), PropertyAndTraitAnnotation.class.getName(), new String[]{"foo"}));
        MetawidgetAnnotationInspectorTest.assertEquals((String)"inspection-result", (String)document.getFirstChild().getNodeName());
        Element entity = (Element)document.getDocumentElement().getFirstChild();
        MetawidgetAnnotationInspectorTest.assertEquals((String)"entity", (String)entity.getNodeName());
        MetawidgetAnnotationInspectorTest.assertEquals((String)String.class.getName(), (String)entity.getAttribute("type"));
        MetawidgetAnnotationInspectorTest.assertEquals((String)"foo", (String)entity.getAttribute("name"));
        MetawidgetAnnotationInspectorTest.assertEquals((String)"true", (String)entity.getAttribute("masked"));
        MetawidgetAnnotationInspectorTest.assertEquals((String)"Foo", (String)entity.getAttribute("label"));
        MetawidgetAnnotationInspectorTest.assertEquals((int)4, (int)entity.getAttributes().getLength());
        MetawidgetAnnotationInspectorTest.assertEquals((int)0, (int)entity.getChildNodes().getLength());
        MetawidgetAnnotationInspectorTest.assertEquals(null, (String)inspector.inspect(null, PropertyAndTraitAnnotation.class.getName(), new String[]{"foo"}));
    }

    public void testNullPropertyStyle() throws Exception {
        MetawidgetAnnotationInspector inspector = new MetawidgetAnnotationInspector();
        Method getPropertiesMethod = BaseObjectInspector.class.getDeclaredMethod("getProperties", String.class);
        getPropertiesMethod.setAccessible(true);
        try {
            MetawidgetAnnotationInspectorTest.assertTrue((boolean)((Map)getPropertiesMethod.invoke((Object)inspector, new Object[]{null})).isEmpty());
            MetawidgetAnnotationInspectorTest.fail();
        }
        catch (InvocationTargetException e) {
            MetawidgetAnnotationInspectorTest.assertTrue((boolean)(e.getCause() instanceof NullPointerException));
        }
        inspector = new MetawidgetAnnotationInspector(new BaseObjectInspectorConfig().setPropertyStyle(null));
        MetawidgetAnnotationInspectorTest.assertTrue((boolean)((Map)getPropertiesMethod.invoke((Object)inspector, new Object[]{null})).isEmpty());
        MetawidgetAnnotationInspectorTest.assertEquals((int)0, (int)((Map)getPropertiesMethod.invoke((Object)inspector, Foo.class.getName())).size());
        inspector = new MetawidgetAnnotationInspector(new BaseObjectInspectorConfig().setPropertyStyle((PropertyStyle)new JavaBeanPropertyStyle()));
        MetawidgetAnnotationInspectorTest.assertEquals((int)3, (int)((Map)getPropertiesMethod.invoke((Object)inspector, Foo.class.getName())).size());
    }

    public void testNullActionStyle() throws Exception {
        MetawidgetAnnotationInspector inspector = new MetawidgetAnnotationInspector();
        Method getActionsMethod = BaseObjectInspector.class.getDeclaredMethod("getActions", String.class);
        getActionsMethod.setAccessible(true);
        try {
            MetawidgetAnnotationInspectorTest.assertTrue((boolean)((Map)getActionsMethod.invoke((Object)inspector, new Object[]{null})).isEmpty());
            MetawidgetAnnotationInspectorTest.fail();
        }
        catch (InvocationTargetException e) {
            MetawidgetAnnotationInspectorTest.assertTrue((boolean)(e.getCause() instanceof NullPointerException));
        }
        BaseObjectInspectorConfig config = new BaseObjectInspectorConfig();
        config.setActionStyle(null);
        inspector = new MetawidgetAnnotationInspector(config);
        MetawidgetAnnotationInspectorTest.assertTrue((boolean)((Map)getActionsMethod.invoke((Object)inspector, new Object[]{null})).isEmpty());
        MetawidgetAnnotationInspectorTest.assertEquals((int)0, (int)((Map)getActionsMethod.invoke((Object)inspector, Foo.class.getName())).size());
        inspector = new MetawidgetAnnotationInspector(new BaseObjectInspectorConfig().setPropertyStyle((PropertyStyle)new JavaBeanPropertyStyle()));
        MetawidgetAnnotationInspectorTest.assertEquals((int)1, (int)((Map)getActionsMethod.invoke((Object)inspector, Foo.class.getName())).size());
    }

    public void testSuperclassAnnotations() throws Exception {
        MetawidgetAnnotationInspector inspector = new MetawidgetAnnotationInspector();
        Document document = XmlUtils.documentFromString((String)inspector.inspect((Object)new SubFoo(), SubFoo.class.getName(), new String[0]));
        MetawidgetAnnotationInspectorTest.assertEquals((String)"inspection-result", (String)document.getFirstChild().getNodeName());
        Element entity = (Element)document.getDocumentElement().getFirstChild();
        MetawidgetAnnotationInspectorTest.assertEquals((String)"entity", (String)entity.getNodeName());
        MetawidgetAnnotationInspectorTest.assertEquals((String)SubFoo.class.getName(), (String)entity.getAttribute("type"));
        Element action = XmlUtils.getChildWithAttributeValue((Element)entity, (String)"name", (String)"doNothing");
        MetawidgetAnnotationInspectorTest.assertEquals((String)"action", (String)action.getNodeName());
        MetawidgetAnnotationInspectorTest.assertEquals((String)"string1", (String)action.getAttribute("comes-after"));
        MetawidgetAnnotationInspectorTest.assertEquals((String)"Bar", (String)action.getAttribute("section"));
        MetawidgetAnnotationInspectorTest.assertEquals((int)3, (int)action.getAttributes().getLength());
    }

    public void testAlphabeticalMethods() {
        String xml = this.mInspector.inspect(null, AlphabeticalMethods.class.getName(), new String[0]);
        Document document = XmlUtils.documentFromString((String)xml);
        MetawidgetAnnotationInspectorTest.assertEquals((String)"inspection-result", (String)document.getFirstChild().getNodeName());
        Element entity = (Element)document.getDocumentElement().getFirstChild();
        MetawidgetAnnotationInspectorTest.assertEquals((String)"entity", (String)entity.getNodeName());
        MetawidgetAnnotationInspectorTest.assertEquals((String)AlphabeticalMethods.class.getName(), (String)entity.getAttribute("type"));
        MetawidgetAnnotationInspectorTest.assertEquals((int)3, (int)entity.getChildNodes().getLength());
        Element property = (Element)entity.getFirstChild();
        MetawidgetAnnotationInspectorTest.assertEquals((String)"action", (String)property.getNodeName());
        MetawidgetAnnotationInspectorTest.assertEquals((String)"action", (String)property.getAttribute("name"));
        MetawidgetAnnotationInspectorTest.assertEquals((int)1, (int)property.getAttributes().getLength());
        property = (Element)property.getNextSibling();
        MetawidgetAnnotationInspectorTest.assertEquals((String)"action", (String)property.getNodeName());
        MetawidgetAnnotationInspectorTest.assertEquals((String)"WEPKey", (String)property.getAttribute("name"));
        MetawidgetAnnotationInspectorTest.assertEquals((int)1, (int)property.getAttributes().getLength());
        property = (Element)property.getNextSibling();
        MetawidgetAnnotationInspectorTest.assertEquals((String)"action", (String)property.getNodeName());
        MetawidgetAnnotationInspectorTest.assertEquals((String)"wepKey", (String)property.getAttribute("name"));
        MetawidgetAnnotationInspectorTest.assertEquals((int)1, (int)property.getAttributes().getLength());
    }

    public static class AlphabeticalMethods {
        @UiAction
        public void action() {
        }

        @UiAction
        public void wepKey() {
        }

        @UiAction
        public void WEPKey() {
        }
    }

    public static class SubFoo
    extends Foo {
        public void doNothing() {
        }
    }

    public static class BadAction1 {
        @UiAction
        public void doNothing(String foo) {
        }
    }

    public static class Foo {
        @UiRequired
        @UiLookup(value={"foo,", "bar"})
        @UiWide
        public Object getObject1() {
            return null;
        }

        @UiLabel(value="bar")
        @UiAttributes(value={@UiAttribute(name={"foo1"}, value="bar1"), @UiAttribute(name={"foo2"}, value="bar2")})
        @UiHidden
        @UiReadOnly
        @UiDontExpand
        @UiSection(value={"Foo"})
        @UiMasked
        @UiComesAfter(value={"object1"})
        @UiLarge
        public String getString1() {
            return null;
        }

        @UiAttribute(name={"abc", "def"}, value="abc-def")
        @UiAttributes(value={@UiAttribute(name={"ghi", "jkl"}, value="ghi-jkl"), @UiAttribute(name={"mno", "pqr"}, value="mno-pqr")})
        public String getString2() {
            return null;
        }

        @UiAction
        @UiComesAfter(value={"string1"})
        @UiSection(value={"Bar"})
        public void doNothing() {
        }
    }

    public static class PropertyAndTraitAnnotation {
        @UiMasked
        @UiLabel(value="Foo")
        public String getFoo() {
            return null;
        }
    }
}

