/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.java5;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.metawidget.inspector.impl.BaseObjectInspector;
import org.metawidget.inspector.impl.BaseObjectInspectorConfig;
import org.metawidget.inspector.impl.propertystyle.Property;
import org.metawidget.util.ClassUtils;
import org.metawidget.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Java5Inspector
extends BaseObjectInspector {
    public Java5Inspector() {
        this(new BaseObjectInspectorConfig());
    }

    public Java5Inspector(BaseObjectInspectorConfig config) {
        super(config);
    }

    protected boolean shouldInspectPropertyAsEntity(Property property) {
        return true;
    }

    protected Map<String, String> inspectEntity(String declaredClass, String actualClass) throws Exception {
        HashMap attributes = CollectionUtils.newHashMap();
        Class actualClazz = ClassUtils.niceForName((String)actualClass);
        if (actualClazz != null && Enum.class.isAssignableFrom(actualClazz)) {
            Method methodValues = actualClazz.getMethod("values", new Class[0]);
            Enum[] enums = (Enum[])methodValues.invoke((Object)actualClazz, new Object[0]);
            ArrayList lookup = CollectionUtils.newArrayList();
            ArrayList lookupLabels = CollectionUtils.newArrayList();
            for (Enum anEnum : enums) {
                lookup.add(anEnum.name());
                lookupLabels.add(anEnum.toString());
            }
            attributes.put("lookup", CollectionUtils.toString((Collection)lookup));
            attributes.put("lookup-labels", CollectionUtils.toString((Collection)lookupLabels));
            if (actualClazz.isEnum()) {
                attributes.put("type", actualClazz.getName());
            } else {
                attributes.put("type", actualClazz.getSuperclass().getName());
            }
        }
        return attributes;
    }

    protected Map<String, String> inspectProperty(Property property) throws Exception {
        HashMap attributes = CollectionUtils.newHashMap();
        String genericType = property.getGenericType();
        if (genericType != null) {
            attributes.put("parameterized-type", genericType);
        }
        return attributes;
    }
}

