/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.impl.propertystyle.javassist;

import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.bytecode.MethodInfo;
import org.metawidget.inspector.iface.InspectorException;
import org.metawidget.inspector.impl.propertystyle.Property;
import org.metawidget.inspector.impl.propertystyle.javabean.JavaBeanPropertyStyle;
import org.metawidget.inspector.impl.propertystyle.javabean.JavaBeanPropertyStyleConfig;
import org.metawidget.util.CollectionUtils;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavassistPropertyStyle
extends JavaBeanPropertyStyle {
    public JavassistPropertyStyle() {
    }

    public JavassistPropertyStyle(JavaBeanPropertyStyleConfig config) {
        super(config);
    }

    protected Map<String, Property> inspectProperties(String type) {
        try {
            TreeMap lineNumberedProperties = CollectionUtils.newTreeMap();
            ClassPool pool = ClassPool.getDefault();
            CtClass ctClass = pool.get(type);
            Map properties = super.inspectProperties(type);
            for (Property property : properties.values()) {
                String propertyName = property.getName();
                if (property instanceof JavaBeanPropertyStyle.JavaBeanProperty) {
                    CtMethod ctMethod = null;
                    JavaBeanPropertyStyle.JavaBeanProperty javaBeanProperty = (JavaBeanPropertyStyle.JavaBeanProperty)property;
                    Method method = javaBeanProperty.getReadMethod();
                    if (method != null) {
                        ctMethod = this.getCtMethod(ctClass, method, new CtClass[0]);
                    } else {
                        method = javaBeanProperty.getWriteMethod();
                        ctMethod = this.getCtMethod(ctClass, method, new CtClass[]{pool.get(property.getType())});
                    }
                    MethodInfo methodInfo = ctMethod.getMethodInfo();
                    int lineNumber = methodInfo.getLineNumber(0);
                    if (lineNumber == -1 && !ctClass.isInterface()) {
                        throw InspectorException.newException((String)new StringBuffer().append("Line number information for ").append(type).append(" not available. Did you compile without debug info?").toString());
                    }
                    lineNumberedProperties.put(new ClassAndLineNumberAndName(method.getDeclaringClass(), lineNumber, propertyName), property);
                    continue;
                }
                if (property instanceof JavaBeanPropertyStyle.FieldProperty) {
                    JavaBeanPropertyStyle.FieldProperty fieldProperty = (JavaBeanPropertyStyle.FieldProperty)property;
                    lineNumberedProperties.put(new ClassAndLineNumberAndName(fieldProperty.getField().getDeclaringClass(), 0, propertyName), property);
                    continue;
                }
                throw InspectorException.newException((String)new StringBuffer().append("Unknown property type ").append(property.getClass()).toString());
            }
            LinkedHashMap sortedProperties = CollectionUtils.newLinkedHashMap();
            for (Property property : lineNumberedProperties.values()) {
                sortedProperties.put(property.getName(), property);
            }
            return sortedProperties;
        }
        catch (Exception e) {
            throw InspectorException.newException((Throwable)e);
        }
    }

    private CtMethod getCtMethod(CtClass ctClass, Method method, CtClass[] parameters) throws NotFoundException {
        CtClass superClass = ctClass;
        while (true) {
            try {
                return superClass.getDeclaredMethod(method.getName(), parameters);
            }
            catch (NotFoundException e) {
                superClass = superClass.getSuperclass();
                continue;
            }
            break;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClassAndLineNumberAndName
    implements Comparable<ClassAndLineNumberAndName> {
        private Class<?> mClass;
        private int mLineNumber;
        private String mName;

        public ClassAndLineNumberAndName(Class<?> clazz, int lineNumber, String name) {
            this.mClass = clazz;
            this.mLineNumber = lineNumber;
            this.mName = name;
        }

        @Override
        public int compareTo(ClassAndLineNumberAndName that) {
            if (!this.mClass.equals(that.mClass)) {
                if (this.mClass.isAssignableFrom(that.mClass)) {
                    return -1;
                }
                return 1;
            }
            if (this.mLineNumber != that.mLineNumber) {
                return this.mLineNumber - that.mLineNumber;
            }
            return this.mName.compareTo(that.mName);
        }

        @Override
        public /* synthetic */ int compareTo(Object x0) {
            return this.compareTo((ClassAndLineNumberAndName)x0);
        }
    }
}

