/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.jpa;

import java.util.HashMap;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Temporal;
import javax.persistence.Transient;
import javax.persistence.Version;
import org.metawidget.inspector.impl.BaseObjectInspector;
import org.metawidget.inspector.impl.BaseObjectInspectorConfig;
import org.metawidget.inspector.impl.propertystyle.Property;
import org.metawidget.inspector.jpa.JpaInspectorConfig;
import org.metawidget.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaInspector
extends BaseObjectInspector {
    private final boolean mHideIds;
    private final boolean mHideVersions;
    private final boolean mHideTransients;

    public JpaInspector() {
        this(new JpaInspectorConfig());
    }

    public JpaInspector(JpaInspectorConfig jpaInspectorConfig) {
        super((BaseObjectInspectorConfig)jpaInspectorConfig);
        this.mHideIds = jpaInspectorConfig.isHideIds();
        this.mHideVersions = jpaInspectorConfig.isHideVersions();
        this.mHideTransients = jpaInspectorConfig.isHideTransients();
    }

    protected Map<String, String> inspectProperty(Property property) throws Exception {
        String string;
        Object object;
        OneToOne oneToOne;
        Column column;
        HashMap hashMap = CollectionUtils.newHashMap();
        if (property.isAnnotationPresent(Lob.class)) {
            hashMap.put("large", "true");
        }
        if ((column = (Column)property.getAnnotation(Column.class)) != null) {
            if (!column.nullable()) {
                hashMap.put("required", "true");
            }
            if (column.length() != 255) {
                hashMap.put("maximum-length", String.valueOf(column.length()));
            }
        }
        if ((oneToOne = (OneToOne)property.getAnnotation(OneToOne.class)) != null) {
            if (!oneToOne.optional()) {
                hashMap.put("required", "true");
            }
            if (!"".equals(object = oneToOne.mappedBy())) {
                hashMap.put("inverse-relationship", object);
            }
        }
        if ((object = (OneToMany)property.getAnnotation(OneToMany.class)) != null && !"".equals(string = object.mappedBy())) {
            hashMap.put("inverse-relationship", string);
        }
        if ((string = (ManyToOne)property.getAnnotation(ManyToOne.class)) != null && !string.optional()) {
            hashMap.put("required", "true");
        }
        if (this.mHideIds && property.isAnnotationPresent(Id.class)) {
            hashMap.put("hidden", "true");
        } else if (this.mHideIds && property.isAnnotationPresent(EmbeddedId.class)) {
            hashMap.put("hidden", "true");
        } else if (this.mHideVersions && property.isAnnotationPresent(Version.class)) {
            hashMap.put("hidden", "true");
        } else if (this.mHideTransients && property.isAnnotationPresent(Transient.class)) {
            hashMap.put("hidden", "true");
        }
        Temporal temporal = (Temporal)property.getAnnotation(Temporal.class);
        if (temporal != null) {
            switch (temporal.value()) {
                case DATE: {
                    hashMap.put("datetime-type", "date");
                    break;
                }
                case TIME: {
                    hashMap.put("datetime-type", "time");
                    break;
                }
                case TIMESTAMP: {
                    hashMap.put("datetime-type", "both");
                }
            }
        }
        return hashMap;
    }
}

