/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.seam;

import java.io.InputStream;
import java.util.ArrayList;
import org.metawidget.config.ResourceResolver;
import org.metawidget.inspector.iface.Inspector;
import org.metawidget.inspector.iface.InspectorException;
import org.metawidget.inspector.impl.BaseXmlInspectorConfig;
import org.metawidget.inspector.jbpm.PageflowInspector;
import org.metawidget.inspector.seam.SeamInspectorConfig;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SeamInspector
implements Inspector {
    private static final String JBPM_ELEMENT = "jbpm";
    private static final String PAGEFLOW_DEFINITIONS_ELEMENT = "pageflow-definitions";
    private final PageflowInspector mPageflowInspector;

    public SeamInspector() {
        this(new SeamInspectorConfig());
    }

    public SeamInspector(SeamInspectorConfig config) {
        Element root;
        try {
            Document documentParsed = XmlUtils.parse((InputStream)config.getComponentsInputStream());
            root = documentParsed.getDocumentElement();
        }
        catch (Exception e) {
            throw InspectorException.newException((Throwable)e);
        }
        ResourceResolver resolver = config.getResourceResolver();
        ArrayList pageflowDefinitionStreams = CollectionUtils.newArrayList();
        Element pageflowValue = XmlUtils.getChildNamed((Element)root, (String[])new String[]{JBPM_ELEMENT, PAGEFLOW_DEFINITIONS_ELEMENT, "value"});
        while (pageflowValue != null) {
            pageflowDefinitionStreams.add(resolver.openResource(pageflowValue.getTextContent()));
            pageflowValue = XmlUtils.getSiblingNamed((Element)pageflowValue, (String)"value");
        }
        if (pageflowDefinitionStreams.isEmpty()) {
            this.mPageflowInspector = null;
        } else {
            BaseXmlInspectorConfig jpdlConfig = new BaseXmlInspectorConfig();
            jpdlConfig.setInputStreams(pageflowDefinitionStreams.toArray(new InputStream[pageflowDefinitionStreams.size()]));
            this.mPageflowInspector = new PageflowInspector(jpdlConfig);
        }
    }

    public String inspect(Object toInspect, String type, String[] names) {
        if (this.mPageflowInspector != null) {
            return this.mPageflowInspector.inspect(toInspect, type, names);
        }
        return null;
    }
}

