/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.swing.widgetprocessor.binding.beansbinding;

import java.awt.Component;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Converter;
import org.jdesktop.beansbinding.Property;
import org.metawidget.swing.SwingMetawidget;
import org.metawidget.swing.widgetprocessor.binding.BindingConverter;
import org.metawidget.swing.widgetprocessor.binding.beansbinding.BeansBindingProcessorConfig;
import org.metawidget.swing.widgetprocessor.binding.beansbinding.BooleanConverter;
import org.metawidget.swing.widgetprocessor.binding.beansbinding.NumberConverter;
import org.metawidget.swing.widgetprocessor.binding.beansbinding.ReadOnlyToStringConverter;
import org.metawidget.util.ClassUtils;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.WidgetBuilderUtils;
import org.metawidget.util.simple.ObjectUtils;
import org.metawidget.util.simple.PathUtils;
import org.metawidget.widgetprocessor.iface.AdvancedWidgetProcessor;
import org.metawidget.widgetprocessor.iface.WidgetProcessorException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeansBindingProcessor
implements AdvancedWidgetProcessor<JComponent, SwingMetawidget>,
BindingConverter {
    private final AutoBinding.UpdateStrategy mUpdateStrategy;
    private final Map<ConvertFromTo<?, ?>, Converter<?, ?>> mConverters = CollectionUtils.newHashMap();
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$org$metawidget$swing$widgetprocessor$binding$beansbinding$BeansBindingProcessor;

    public BeansBindingProcessor() {
        this(new BeansBindingProcessorConfig());
    }

    public BeansBindingProcessor(BeansBindingProcessorConfig config) {
        this.mUpdateStrategy = config.getUpdateStrategy();
        this.registerConverter(class$java$lang$Byte == null ? (class$java$lang$Byte = BeansBindingProcessor.class$("java.lang.Byte")) : class$java$lang$Byte, class$java$lang$String == null ? (class$java$lang$String = BeansBindingProcessor.class$("java.lang.String")) : class$java$lang$String, new NumberConverter(class$java$lang$Byte == null ? (class$java$lang$Byte = BeansBindingProcessor.class$("java.lang.Byte")) : class$java$lang$Byte));
        this.registerConverter(class$java$lang$Short == null ? (class$java$lang$Short = BeansBindingProcessor.class$("java.lang.Short")) : class$java$lang$Short, class$java$lang$String == null ? (class$java$lang$String = BeansBindingProcessor.class$("java.lang.String")) : class$java$lang$String, new NumberConverter(class$java$lang$Short == null ? (class$java$lang$Short = BeansBindingProcessor.class$("java.lang.Short")) : class$java$lang$Short));
        this.registerConverter(class$java$lang$Integer == null ? (class$java$lang$Integer = BeansBindingProcessor.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$String == null ? (class$java$lang$String = BeansBindingProcessor.class$("java.lang.String")) : class$java$lang$String, new NumberConverter(class$java$lang$Integer == null ? (class$java$lang$Integer = BeansBindingProcessor.class$("java.lang.Integer")) : class$java$lang$Integer));
        this.registerConverter(class$java$lang$Long == null ? (class$java$lang$Long = BeansBindingProcessor.class$("java.lang.Long")) : class$java$lang$Long, class$java$lang$String == null ? (class$java$lang$String = BeansBindingProcessor.class$("java.lang.String")) : class$java$lang$String, new NumberConverter(class$java$lang$Long == null ? (class$java$lang$Long = BeansBindingProcessor.class$("java.lang.Long")) : class$java$lang$Long));
        this.registerConverter(class$java$lang$Float == null ? (class$java$lang$Float = BeansBindingProcessor.class$("java.lang.Float")) : class$java$lang$Float, class$java$lang$String == null ? (class$java$lang$String = BeansBindingProcessor.class$("java.lang.String")) : class$java$lang$String, new NumberConverter(class$java$lang$Float == null ? (class$java$lang$Float = BeansBindingProcessor.class$("java.lang.Float")) : class$java$lang$Float));
        this.registerConverter(class$java$lang$Double == null ? (class$java$lang$Double = BeansBindingProcessor.class$("java.lang.Double")) : class$java$lang$Double, class$java$lang$String == null ? (class$java$lang$String = BeansBindingProcessor.class$("java.lang.String")) : class$java$lang$String, new NumberConverter(class$java$lang$Double == null ? (class$java$lang$Double = BeansBindingProcessor.class$("java.lang.Double")) : class$java$lang$Double));
        this.registerConverter(class$java$lang$Boolean == null ? (class$java$lang$Boolean = BeansBindingProcessor.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$String == null ? (class$java$lang$String = BeansBindingProcessor.class$("java.lang.String")) : class$java$lang$String, new BooleanConverter());
        if (config.getConverters() != null) {
            this.mConverters.putAll(config.getConverters());
        }
    }

    public void onStartBuild(SwingMetawidget metawidget) {
        State state = this.getState(metawidget);
        if (state.bindings != null) {
            for (Binding<Object, ?, ? extends Component, ?> binding : state.bindings) {
                binding.unbind();
            }
        }
        metawidget.putClientProperty((Object)(class$org$metawidget$swing$widgetprocessor$binding$beansbinding$BeansBindingProcessor == null ? (class$org$metawidget$swing$widgetprocessor$binding$beansbinding$BeansBindingProcessor = BeansBindingProcessor.class$("org.metawidget.swing.widgetprocessor.binding.beansbinding.BeansBindingProcessor")) : class$org$metawidget$swing$widgetprocessor$binding$beansbinding$BeansBindingProcessor), null);
    }

    public JComponent processWidget(JComponent component, String elementName, Map<String, String> attributes, SwingMetawidget metawidget) {
        JComponent componentToBind = component;
        if (componentToBind instanceof JScrollPane) {
            componentToBind = (JComponent)((JScrollPane)componentToBind).getViewport().getView();
        }
        if (componentToBind instanceof SwingMetawidget) {
            State state = this.getState(metawidget);
            if (state.nestedMetawidgets == null) {
                state.nestedMetawidgets = CollectionUtils.newHashSet();
            }
            state.nestedMetawidgets.add((SwingMetawidget)component);
            return component;
        }
        this.typesafeAdd(componentToBind, elementName, attributes, metawidget);
        return component;
    }

    public void rebind(Object toRebind, SwingMetawidget metawidget) {
        metawidget.updateToInspectWithoutInvalidate(toRebind);
        State state = this.getState(metawidget);
        if (state.bindings != null) {
            for (Binding<Object, ?, ? extends Component, ?> binding : state.bindings) {
                binding.unbind();
                binding.setSourceObject(toRebind);
                binding.bind();
                Binding.SyncFailure failure = binding.refresh();
                if (failure == null) continue;
                throw WidgetProcessorException.newException((String)failure.getType().toString());
            }
        }
        if (state.nestedMetawidgets != null) {
            for (SwingMetawidget swingMetawidget : state.nestedMetawidgets) {
                this.rebind(toRebind, swingMetawidget);
            }
        }
    }

    public void save(SwingMetawidget metawidget) {
        State state = this.getState(metawidget);
        if (state.bindings != null) {
            for (Binding<Object, ?, ? extends Component, ?> binding : state.bindings) {
                Object sourceObject = binding.getSourceObject();
                BeanProperty sourceProperty = (BeanProperty)binding.getSourceProperty();
                if (!sourceProperty.isWriteable(sourceObject) || binding.getConverter() instanceof ReadOnlyToStringConverter) continue;
                try {
                    Binding.SyncFailure failure = binding.save();
                    if (failure == null) continue;
                    throw WidgetProcessorException.newException((Throwable)failure.getConversionException());
                }
                catch (ClassCastException e) {
                    throw WidgetProcessorException.newException((String)new StringBuffer().append("When saving from ").append(((Component)binding.getTargetObject()).getClass().getName()).append(" to ").append(sourceProperty).append(" (have you used BeansBindingProcessorConfig.setConverter?)").toString(), (Throwable)e);
                }
            }
        }
        if (state.nestedMetawidgets != null) {
            for (SwingMetawidget swingMetawidget : state.nestedMetawidgets) {
                this.save(swingMetawidget);
            }
        }
    }

    public Object convertFromString(String value, Class<?> expectedType) {
        Converter converterFromString = this.getConverter(class$java$lang$String == null ? (class$java$lang$String = BeansBindingProcessor.class$("java.lang.String")) : class$java$lang$String, expectedType);
        if (converterFromString != null) {
            return converterFromString.convertForward((Object)value);
        }
        Converter converterToString = this.getConverter(expectedType, class$java$lang$String == null ? (class$java$lang$String = BeansBindingProcessor.class$("java.lang.String")) : class$java$lang$String);
        if (converterToString != null) {
            return converterToString.convertReverse((Object)value);
        }
        return value;
    }

    public void onEndBuild(SwingMetawidget metawidget) {
    }

    private <S, T> void registerConverter(Class<S> source, Class<T> target, Converter<S, T> converter) {
        this.mConverters.put(new ConvertFromTo<S, T>(source, target), converter);
    }

    private <SS, SV, TS extends Component, TV> void typesafeAdd(TS component, String elementName, Map<String, String> attributes, SwingMetawidget metawidget) {
        String componentProperty = metawidget.getValueProperty(component);
        if (componentProperty == null) {
            return;
        }
        Object source = metawidget.getToInspect();
        String sourceProperty = PathUtils.parsePath((String)metawidget.getPath()).getNames().replace('/', '.');
        if ("property".equals(elementName)) {
            if (sourceProperty.length() > 0) {
                sourceProperty = new StringBuffer().append(sourceProperty).append('.').toString();
            }
            sourceProperty = new StringBuffer().append(sourceProperty).append(attributes.get("name")).toString();
        }
        BeanProperty propertySource = BeanProperty.create((String)sourceProperty);
        BeanProperty propertyTarget = BeanProperty.create((String)componentProperty);
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)this.mUpdateStrategy, (Object)source, (Property)propertySource, component, (Property)propertyTarget);
        Class target = propertyTarget.getWriteType(component);
        Object converter = null;
        if (propertySource.isWriteable(source)) {
            Class sourceClass = propertySource.getWriteType(source);
            converter = this.getConverter(sourceClass, target);
        } else if (propertySource.isReadable(source)) {
            Object value = propertySource.getValue(source);
            if (value != null) {
                Class<?> sourceClass = value.getClass();
                converter = this.getConverter(sourceClass, target);
            }
        } else {
            throw WidgetProcessorException.newException((String)new StringBuffer().append("Property '").append(sourceProperty).append("' has no getter and no setter (or parent is null)").toString());
        }
        if (converter == null && WidgetBuilderUtils.isReadOnly(attributes) && target.equals(class$java$lang$String == null ? (class$java$lang$String = BeansBindingProcessor.class$("java.lang.String")) : class$java$lang$String)) {
            converter = new ReadOnlyToStringConverter();
        }
        binding.setConverter(converter);
        try {
            binding.bind();
        }
        catch (ClassCastException e) {
            throw WidgetProcessorException.newException((String)new StringBuffer().append("When binding ").append(metawidget.getPath()).append('/').append(sourceProperty).append(" to ").append(component.getClass()).append(".").append(componentProperty).append(" (have you used BeansBindingProcessorConfig.setConverter?)").toString(), (Throwable)e);
        }
        State state = this.getState(metawidget);
        if (state.bindings == null) {
            state.bindings = CollectionUtils.newHashSet();
        }
        state.bindings.add((Binding<Object, ?, Component, ?>)binding);
    }

    private <SV, TV> Converter<SV, TV> getConverter(Class<SV> sourceClass, Class<TV> targetClass) {
        Class sourceClassTraversal = sourceClass;
        Class targetClassTraversal = targetClass;
        if (sourceClassTraversal.isPrimitive()) {
            sourceClassTraversal = ClassUtils.getWrapperClass(sourceClassTraversal);
        }
        if (targetClassTraversal.isPrimitive()) {
            targetClassTraversal = ClassUtils.getWrapperClass(targetClassTraversal);
        }
        while (sourceClassTraversal != null) {
            Converter<?, ?> converter = this.mConverters.get(new ConvertFromTo(sourceClassTraversal, targetClassTraversal));
            if (converter != null) {
                return converter;
            }
            sourceClassTraversal = sourceClassTraversal.getSuperclass();
        }
        return null;
    }

    private State getState(SwingMetawidget metawidget) {
        State state = (State)metawidget.getClientProperty((Object)(class$org$metawidget$swing$widgetprocessor$binding$beansbinding$BeansBindingProcessor == null ? (class$org$metawidget$swing$widgetprocessor$binding$beansbinding$BeansBindingProcessor = BeansBindingProcessor.class$("org.metawidget.swing.widgetprocessor.binding.beansbinding.BeansBindingProcessor")) : class$org$metawidget$swing$widgetprocessor$binding$beansbinding$BeansBindingProcessor));
        if (state == null) {
            state = new State();
            metawidget.putClientProperty((Object)(class$org$metawidget$swing$widgetprocessor$binding$beansbinding$BeansBindingProcessor == null ? (class$org$metawidget$swing$widgetprocessor$binding$beansbinding$BeansBindingProcessor = BeansBindingProcessor.class$("org.metawidget.swing.widgetprocessor.binding.beansbinding.BeansBindingProcessor")) : class$org$metawidget$swing$widgetprocessor$binding$beansbinding$BeansBindingProcessor), (Object)state);
        }
        return state;
    }

    public /* synthetic */ void onEndBuild(Object x0) {
        this.onEndBuild((SwingMetawidget)x0);
    }

    public /* synthetic */ void onStartBuild(Object x0) {
        this.onStartBuild((SwingMetawidget)x0);
    }

    public /* synthetic */ Object processWidget(Object x0, String x1, Map x2, Object x3) {
        return this.processWidget((JComponent)x0, x1, (Map<String, String>)x2, (SwingMetawidget)x3);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ConvertFromTo<S, T> {
        private Class<S> mSource;
        private Class<T> mTarget;

        public ConvertFromTo(Class<S> source, Class<T> target) {
            this.mSource = source;
            this.mTarget = target;
        }

        public boolean equals(Object that) {
            if (this == that) {
                return true;
            }
            if (that == null) {
                return false;
            }
            if (this.getClass() != that.getClass()) {
                return false;
            }
            if (!ObjectUtils.nullSafeEquals(this.mSource, ((ConvertFromTo)that).mSource)) {
                return false;
            }
            return ObjectUtils.nullSafeEquals(this.mTarget, ((ConvertFromTo)that).mTarget);
        }

        public int hashCode() {
            int hashCode = 1;
            hashCode = 31 * hashCode + ObjectUtils.nullSafeHashCode((Object)new Integer(this.mSource.hashCode()));
            hashCode = 31 * hashCode + ObjectUtils.nullSafeHashCode((Object)new Integer(this.mTarget.hashCode()));
            return hashCode;
        }
    }

    static class State {
        Set<Binding<Object, ?, ? extends Component, ?>> bindings;
        Set<SwingMetawidget> nestedMetawidgets;

        State() {
        }
    }
}

