/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.swing.widgetprocessor.binding.beansbinding;

import java.awt.Component;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Converter;
import org.jdesktop.beansbinding.Property;
import org.metawidget.swing.SwingMetawidget;
import org.metawidget.swing.widgetprocessor.binding.BindingConverter;
import org.metawidget.swing.widgetprocessor.binding.beansbinding.BeansBindingProcessorConfig;
import org.metawidget.swing.widgetprocessor.binding.beansbinding.BooleanConverter;
import org.metawidget.swing.widgetprocessor.binding.beansbinding.NumberConverter;
import org.metawidget.swing.widgetprocessor.binding.beansbinding.ReadOnlyToStringConverter;
import org.metawidget.util.ClassUtils;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.WidgetBuilderUtils;
import org.metawidget.util.simple.ObjectUtils;
import org.metawidget.util.simple.PathUtils;
import org.metawidget.widgetprocessor.iface.AdvancedWidgetProcessor;
import org.metawidget.widgetprocessor.iface.WidgetProcessorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeansBindingProcessor
implements AdvancedWidgetProcessor<JComponent, SwingMetawidget>,
BindingConverter {
    private final AutoBinding.UpdateStrategy mUpdateStrategy;
    private final Map<ConvertFromTo<?, ?>, Converter<?, ?>> mConverters = CollectionUtils.newHashMap();

    public BeansBindingProcessor() {
        this(new BeansBindingProcessorConfig());
    }

    public BeansBindingProcessor(BeansBindingProcessorConfig config) {
        this.mUpdateStrategy = config.getUpdateStrategy();
        this.registerConverter(Byte.class, String.class, new NumberConverter<Byte>(Byte.class));
        this.registerConverter(Short.class, String.class, new NumberConverter<Short>(Short.class));
        this.registerConverter(Integer.class, String.class, new NumberConverter<Integer>(Integer.class));
        this.registerConverter(Long.class, String.class, new NumberConverter<Long>(Long.class));
        this.registerConverter(Float.class, String.class, new NumberConverter<Float>(Float.class));
        this.registerConverter(Double.class, String.class, new NumberConverter<Double>(Double.class));
        this.registerConverter(Boolean.class, String.class, new BooleanConverter());
        if (config.getConverters() != null) {
            this.mConverters.putAll(config.getConverters());
        }
    }

    public void onStartBuild(SwingMetawidget metawidget) {
        State state = this.getState(metawidget);
        if (state.bindings != null) {
            for (Binding<Object, ?, ? extends Component, ?> binding : state.bindings) {
                binding.unbind();
            }
        }
        metawidget.putClientProperty(BeansBindingProcessor.class, null);
    }

    public JComponent processWidget(JComponent component, String elementName, Map<String, String> attributes, SwingMetawidget metawidget) {
        JComponent componentToBind = component;
        if (componentToBind instanceof JScrollPane) {
            componentToBind = (JComponent)((JScrollPane)componentToBind).getViewport().getView();
        }
        if (componentToBind instanceof SwingMetawidget) {
            State state = this.getState(metawidget);
            if (state.nestedMetawidgets == null) {
                state.nestedMetawidgets = CollectionUtils.newHashSet();
            }
            state.nestedMetawidgets.add((SwingMetawidget)component);
            return component;
        }
        this.typesafeAdd(componentToBind, elementName, attributes, metawidget);
        return component;
    }

    public void rebind(Object toRebind, SwingMetawidget metawidget) {
        metawidget.updateToInspectWithoutInvalidate(toRebind);
        State state = this.getState(metawidget);
        if (state.bindings != null) {
            for (Binding<Object, ?, ? extends Component, ?> binding : state.bindings) {
                binding.unbind();
                binding.setSourceObject(toRebind);
                Binding<Object, ?, ? extends Component, ?> binding2 = this.processBinding(binding, metawidget);
                if (binding2 == null) continue;
                binding2.bind();
                Binding.SyncFailure failure = binding2.refresh();
                if (failure == null) continue;
                throw WidgetProcessorException.newException((String)failure.getType().toString());
            }
        }
        if (state.nestedMetawidgets != null) {
            for (SwingMetawidget swingMetawidget : state.nestedMetawidgets) {
                this.rebind(toRebind, swingMetawidget);
            }
        }
    }

    public void save(SwingMetawidget metawidget) {
        State state = this.getState(metawidget);
        if (state.bindings != null) {
            for (Binding<Object, ?, ? extends Component, ?> binding : state.bindings) {
                Object sourceObject = binding.getSourceObject();
                BeanProperty sourceProperty = (BeanProperty)binding.getSourceProperty();
                if (!sourceProperty.isWriteable(sourceObject) || binding.getConverter() instanceof ReadOnlyToStringConverter) continue;
                try {
                    Binding.SyncFailure failure = binding.save();
                    if (failure == null) continue;
                    throw WidgetProcessorException.newException((Throwable)failure.getConversionException());
                }
                catch (ClassCastException e) {
                    throw WidgetProcessorException.newException((String)("When saving from " + ((Component)binding.getTargetObject()).getClass() + " to " + sourceProperty + " (have you used BeansBindingProcessorConfig.setConverter?)"), (Throwable)e);
                }
            }
        }
        if (state.nestedMetawidgets != null) {
            for (SwingMetawidget swingMetawidget : state.nestedMetawidgets) {
                this.save(swingMetawidget);
            }
        }
    }

    public Object convertFromString(String value, Class<?> expectedType) {
        if (String.class.equals(expectedType)) {
            return value;
        }
        Converter<String, ?> converterFromString = this.getConverter(String.class, expectedType);
        if (converterFromString != null) {
            return converterFromString.convertForward((Object)value);
        }
        Converter<?, String> converterToString = this.getConverter(expectedType, String.class);
        if (converterToString != null) {
            return converterToString.convertReverse((Object)value);
        }
        return value;
    }

    public void onEndBuild(SwingMetawidget metawidget) {
    }

    protected <SS, SV, TS extends Component, TV> Binding<SS, SV, TS, TV> processBinding(Binding<SS, SV, TS, TV> binding, SwingMetawidget metawidget) {
        return binding;
    }

    private <S, T> void registerConverter(Class<S> source, Class<T> target, Converter<S, T> converter) {
        this.mConverters.put(new ConvertFromTo<S, T>(source, target), converter);
    }

    private <SS, SV, TS extends Component, TV> void typesafeAdd(TS component, String elementName, Map<String, String> attributes, SwingMetawidget metawidget) {
        String componentProperty = metawidget.getValueProperty(component);
        if (componentProperty == null) {
            return;
        }
        Object source = metawidget.getToInspect();
        String sourceProperty = PathUtils.parsePath((String)metawidget.getPath()).getNames().replace('/', '.');
        if ("property".equals(elementName)) {
            if (sourceProperty.length() > 0) {
                sourceProperty = sourceProperty + '.';
            }
            sourceProperty = sourceProperty + attributes.get("name");
        }
        BeanProperty propertySource = BeanProperty.create((String)sourceProperty);
        BeanProperty propertyTarget = BeanProperty.create((String)componentProperty);
        Binding<SS, SV, TS, TV> binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)this.mUpdateStrategy, (Object)source, (Property)propertySource, component, (Property)propertyTarget);
        Class target = propertyTarget.getWriteType(component);
        Object converter = null;
        if (propertySource.isWriteable(source)) {
            Class sourceClass = propertySource.getWriteType(source);
            converter = this.getConverter(sourceClass, target);
        } else if (propertySource.isReadable(source)) {
            Object value = propertySource.getValue(source);
            if (value != null) {
                Class<?> sourceClass = value.getClass();
                converter = this.getConverter(sourceClass, target);
            }
        } else {
            throw WidgetProcessorException.newException((String)("Property '" + sourceProperty + "' has no getter and no setter (or parent is null)"));
        }
        if (converter == null && WidgetBuilderUtils.isReadOnly(attributes) && target.equals(String.class)) {
            converter = new ReadOnlyToStringConverter();
        }
        binding.setConverter(converter);
        binding = this.processBinding(binding, metawidget);
        if (binding == null) {
            return;
        }
        try {
            binding.bind();
        }
        catch (ClassCastException e) {
            throw WidgetProcessorException.newException((String)("When binding " + metawidget.getPath() + '/' + sourceProperty + " to " + component.getClass() + "." + componentProperty + " (have you used BeansBindingProcessorConfig.setConverter?)"), (Throwable)e);
        }
        State state = this.getState(metawidget);
        if (state.bindings == null) {
            state.bindings = CollectionUtils.newHashSet();
        }
        state.bindings.add(binding);
    }

    private <SV, TV> Converter<SV, TV> getConverter(Class<SV> sourceClass, Class<TV> targetClass) {
        Class sourceClassTraversal = sourceClass;
        Class targetClassTraversal = targetClass;
        if (sourceClassTraversal.isPrimitive()) {
            sourceClassTraversal = ClassUtils.getWrapperClass(sourceClassTraversal);
        }
        if (targetClassTraversal.isPrimitive()) {
            targetClassTraversal = ClassUtils.getWrapperClass(targetClassTraversal);
        }
        while (sourceClassTraversal != null) {
            Converter<?, ?> converter = this.mConverters.get(new ConvertFromTo(sourceClassTraversal, targetClassTraversal));
            if (converter != null) {
                return converter;
            }
            sourceClassTraversal = sourceClassTraversal.getSuperclass();
        }
        return null;
    }

    private State getState(SwingMetawidget metawidget) {
        State state = (State)metawidget.getClientProperty(BeansBindingProcessor.class);
        if (state == null) {
            state = new State();
            metawidget.putClientProperty(BeansBindingProcessor.class, (Object)state);
        }
        return state;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ConvertFromTo<S, T> {
        private Class<S> mSource;
        private Class<T> mTarget;

        public ConvertFromTo(Class<S> source, Class<T> target) {
            this.mSource = source;
            this.mTarget = target;
        }

        public boolean equals(Object that) {
            if (this == that) {
                return true;
            }
            if (that == null) {
                return false;
            }
            if (this.getClass() != that.getClass()) {
                return false;
            }
            if (!ObjectUtils.nullSafeEquals(this.mSource, ((ConvertFromTo)that).mSource)) {
                return false;
            }
            return ObjectUtils.nullSafeEquals(this.mTarget, ((ConvertFromTo)that).mTarget);
        }

        public int hashCode() {
            int hashCode = 1;
            hashCode = 31 * hashCode + ObjectUtils.nullSafeHashCode((Object)this.mSource.hashCode());
            hashCode = 31 * hashCode + ObjectUtils.nullSafeHashCode((Object)this.mTarget.hashCode());
            return hashCode;
        }
    }

    static class State {
        Set<Binding<Object, ?, ? extends Component, ?>> bindings;
        Set<SwingMetawidget> nestedMetawidgets;

        State() {
        }
    }
}

