/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.swing.layout;

import java.awt.Color;
import java.awt.Font;
import org.metawidget.layout.iface.LayoutException;
import org.metawidget.util.simple.ObjectUtils;

public class GridBagLayoutConfig {
    private int mNumberOfColumns = 1;
    private int mLabelAlignment = 2;
    private Color mLabelForeground;
    private Font mLabelFont;
    private boolean mSupportMnemonics = true;
    private String mLabelSuffix = ":";
    private int mRequiredAlignment = 0;
    private String mRequiredText = "*";

    public GridBagLayoutConfig setNumberOfColumns(int numberOfColumns) {
        if (numberOfColumns < 0) {
            throw LayoutException.newException((String)"numberOfColumns must be >= 0");
        }
        this.mNumberOfColumns = numberOfColumns;
        return this;
    }

    public GridBagLayoutConfig setLabelAlignment(int labelAlignment) {
        this.mLabelAlignment = labelAlignment;
        return this;
    }

    public GridBagLayoutConfig setLabelForeground(Color labelForeground) {
        this.mLabelForeground = labelForeground;
        return this;
    }

    public GridBagLayoutConfig setLabelFont(Font labelFont) {
        this.mLabelFont = labelFont;
        return this;
    }

    public GridBagLayoutConfig setSupportMnemonics(boolean supportMnemonics) {
        this.mSupportMnemonics = supportMnemonics;
        return this;
    }

    public GridBagLayoutConfig setLabelSuffix(String labelSuffix) {
        this.mLabelSuffix = labelSuffix;
        return this;
    }

    public GridBagLayoutConfig setRequiredAlignment(int requiredAlignment) {
        this.mRequiredAlignment = requiredAlignment;
        return this;
    }

    public GridBagLayoutConfig setRequiredText(String requiredText) {
        this.mRequiredText = requiredText;
        return this;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!ObjectUtils.nullSafeClassEquals((Object)this, (Object)that)) {
            return false;
        }
        if (this.mNumberOfColumns != ((GridBagLayoutConfig)that).mNumberOfColumns) {
            return false;
        }
        if (this.mLabelAlignment != ((GridBagLayoutConfig)that).mLabelAlignment) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.mLabelFont, (Object)((GridBagLayoutConfig)that).mLabelFont)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.mLabelForeground, (Object)((GridBagLayoutConfig)that).mLabelForeground)) {
            return false;
        }
        if (this.mSupportMnemonics != ((GridBagLayoutConfig)that).mSupportMnemonics) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.mLabelSuffix, (Object)((GridBagLayoutConfig)that).mLabelSuffix)) {
            return false;
        }
        if (this.mRequiredAlignment != ((GridBagLayoutConfig)that).mRequiredAlignment) {
            return false;
        }
        return ObjectUtils.nullSafeEquals((Object)this.mRequiredText, (Object)((GridBagLayoutConfig)that).mRequiredText);
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + this.mNumberOfColumns;
        hashCode = 31 * hashCode + this.mLabelAlignment;
        hashCode = 31 * hashCode + ObjectUtils.nullSafeHashCode((Object)this.mLabelFont);
        hashCode = 31 * hashCode + ObjectUtils.nullSafeHashCode((Object)this.mLabelForeground);
        hashCode = 31 * hashCode + ObjectUtils.nullSafeHashCode((Object)this.mSupportMnemonics);
        hashCode = 31 * hashCode + ObjectUtils.nullSafeHashCode((Object)this.mLabelSuffix);
        hashCode = 31 * hashCode + this.mRequiredAlignment;
        hashCode = 31 * hashCode + ObjectUtils.nullSafeHashCode((Object)this.mRequiredText);
        return hashCode;
    }

    protected int getNumberOfColumns() {
        return this.mNumberOfColumns;
    }

    protected int getLabelAlignment() {
        return this.mLabelAlignment;
    }

    protected Color getLabelForeground() {
        return this.mLabelForeground;
    }

    protected Font getLabelFont() {
        return this.mLabelFont;
    }

    protected boolean isSupportMnemonics() {
        return this.mSupportMnemonics;
    }

    protected String getLabelSuffix() {
        return this.mLabelSuffix;
    }

    protected int getRequiredAlignment() {
        return this.mRequiredAlignment;
    }

    protected String getRequiredText() {
        return this.mRequiredText;
    }
}

