/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.swing.widgetprocessor.binding.reflection;

import java.awt.event.ActionEvent;
import java.lang.reflect.Method;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import org.metawidget.swing.Stub;
import org.metawidget.swing.SwingMetawidget;
import org.metawidget.util.ClassUtils;
import org.metawidget.util.WidgetBuilderUtils;
import org.metawidget.util.simple.PathUtils;
import org.metawidget.widgetprocessor.iface.WidgetProcessor;
import org.metawidget.widgetprocessor.iface.WidgetProcessorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionBindingProcessor
implements WidgetProcessor<JComponent, SwingMetawidget> {
    public JComponent processWidget(JComponent component, String elementName, Map<String, String> attributes, SwingMetawidget metawidget) {
        String[] names;
        if (!"action".equals(elementName)) {
            return component;
        }
        if (component instanceof Stub) {
            return component;
        }
        if (!(component instanceof AbstractButton)) {
            throw WidgetProcessorException.newException((String)"ReflectionBindingProcessor only supports binding actions to AbstractButtons");
        }
        if (WidgetBuilderUtils.isReadOnly(attributes)) {
            return component;
        }
        if (metawidget == null) {
            return component;
        }
        Object toInspect = metawidget.getToInspect();
        if (toInspect == null) {
            return component;
        }
        AbstractButton button = (AbstractButton)component;
        for (String name : names = PathUtils.parsePath((String)metawidget.getPath()).getNamesAsArray()) {
            if ((toInspect = ClassUtils.getProperty(toInspect, (String)name)) != null) continue;
            return component;
        }
        final Object fireActionOn = toInspect;
        final Class<?> fireActionOnClass = fireActionOn.getClass();
        final String actionName = attributes.get("name");
        button.setAction(new AbstractAction(button.getText()){

            public void actionPerformed(ActionEvent e) {
                try {
                    try {
                        Method parameterlessActionMethod = fireActionOnClass.getMethod(actionName, null);
                        parameterlessActionMethod.invoke(fireActionOn, (Object[])null);
                    }
                    catch (NoSuchMethodException exception1) {
                        Method parameterizedActionMethod = fireActionOnClass.getMethod(actionName, ActionEvent.class);
                        parameterizedActionMethod.invoke(fireActionOn, new ActionEvent(fireActionOn, 0, actionName));
                    }
                }
                catch (Exception exception2) {
                    throw WidgetProcessorException.newException((Throwable)exception2);
                }
            }
        });
        return component;
    }
}

