/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.swing.layout;

import java.awt.Color;
import java.awt.Font;
import org.metawidget.layout.iface.LayoutException;
import org.metawidget.util.simple.ObjectUtils;

public class GridBagLayoutConfig {
    private int mNumberOfColumns = 1;
    private int mLabelAlignment = 2;
    private Color mLabelForeground;
    private Font mLabelFont;
    private boolean mSupportMnemonics = true;
    private String mLabelSuffix = ":";
    private int mRequiredAlignment = 0;
    private String mRequiredText = "*";

    public GridBagLayoutConfig setNumberOfColumns(int n) {
        if (n < 0) {
            throw LayoutException.newException((String)"numberOfColumns must be >= 0");
        }
        this.mNumberOfColumns = n;
        return this;
    }

    public GridBagLayoutConfig setLabelAlignment(int n) {
        this.mLabelAlignment = n;
        return this;
    }

    public GridBagLayoutConfig setLabelForeground(Color color) {
        this.mLabelForeground = color;
        return this;
    }

    public GridBagLayoutConfig setLabelFont(Font font) {
        this.mLabelFont = font;
        return this;
    }

    public GridBagLayoutConfig setSupportMnemonics(boolean bl) {
        this.mSupportMnemonics = bl;
        return this;
    }

    public GridBagLayoutConfig setLabelSuffix(String string) {
        this.mLabelSuffix = string;
        return this;
    }

    public GridBagLayoutConfig setRequiredAlignment(int n) {
        this.mRequiredAlignment = n;
        return this;
    }

    public GridBagLayoutConfig setRequiredText(String string) {
        this.mRequiredText = string;
        return this;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!ObjectUtils.nullSafeClassEquals((Object)this, (Object)object)) {
            return false;
        }
        if (this.mNumberOfColumns != ((GridBagLayoutConfig)object).mNumberOfColumns) {
            return false;
        }
        if (this.mLabelAlignment != ((GridBagLayoutConfig)object).mLabelAlignment) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.mLabelFont, (Object)((GridBagLayoutConfig)object).mLabelFont)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.mLabelForeground, (Object)((GridBagLayoutConfig)object).mLabelForeground)) {
            return false;
        }
        if (this.mSupportMnemonics != ((GridBagLayoutConfig)object).mSupportMnemonics) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.mLabelSuffix, (Object)((GridBagLayoutConfig)object).mLabelSuffix)) {
            return false;
        }
        if (this.mRequiredAlignment != ((GridBagLayoutConfig)object).mRequiredAlignment) {
            return false;
        }
        return ObjectUtils.nullSafeEquals((Object)this.mRequiredText, (Object)((GridBagLayoutConfig)object).mRequiredText);
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.mNumberOfColumns;
        n = 31 * n + this.mLabelAlignment;
        n = 31 * n + ObjectUtils.nullSafeHashCode((Object)this.mLabelFont);
        n = 31 * n + ObjectUtils.nullSafeHashCode((Object)this.mLabelForeground);
        n = 31 * n + ObjectUtils.nullSafeHashCode((Object)this.mSupportMnemonics);
        n = 31 * n + ObjectUtils.nullSafeHashCode((Object)this.mLabelSuffix);
        n = 31 * n + this.mRequiredAlignment;
        n = 31 * n + ObjectUtils.nullSafeHashCode((Object)this.mRequiredText);
        return n;
    }

    protected int getNumberOfColumns() {
        return this.mNumberOfColumns;
    }

    protected int getLabelAlignment() {
        return this.mLabelAlignment;
    }

    protected Color getLabelForeground() {
        return this.mLabelForeground;
    }

    protected Font getLabelFont() {
        return this.mLabelFont;
    }

    protected boolean isSupportMnemonics() {
        return this.mSupportMnemonics;
    }

    protected String getLabelSuffix() {
        return this.mLabelSuffix;
    }

    protected int getRequiredAlignment() {
        return this.mRequiredAlignment;
    }

    protected String getRequiredText() {
        return this.mRequiredText;
    }
}

