/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.swing.widgetbuilder;

import java.awt.Component;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.text.JTextComponent;
import org.metawidget.swing.Stub;
import org.metawidget.swing.SwingMetawidget;
import org.metawidget.swing.SwingValuePropertyProvider;
import org.metawidget.swing.widgetprocessor.binding.BindingConverter;
import org.metawidget.util.ClassUtils;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.WidgetBuilderUtils;
import org.metawidget.widgetbuilder.iface.WidgetBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwingWidgetBuilder
implements WidgetBuilder<JComponent, SwingMetawidget>,
SwingValuePropertyProvider {
    @Override
    public String getValueProperty(Component component) {
        if (component instanceof JComboBox) {
            return "selectedItem";
        }
        if (component instanceof JTextComponent) {
            return "text";
        }
        if (component instanceof JSpinner) {
            return "value";
        }
        if (component instanceof JSlider) {
            return "value";
        }
        if (component instanceof JCheckBox) {
            return "selected";
        }
        return null;
    }

    public JComponent buildWidget(String string, Map<String, String> map, SwingMetawidget swingMetawidget) {
        if ("true".equals(map.get("hidden"))) {
            return new Stub();
        }
        if ("action".equals(string)) {
            return new JButton(swingMetawidget.getLabelString(map));
        }
        Class clazz = WidgetBuilderUtils.getActualClassOrType(map, String.class);
        if (Boolean.class.equals((Object)clazz) && "true".equals(map.get("required"))) {
            return new JCheckBox();
        }
        String string2 = map.get("lookup");
        if (string2 != null && !"".equals(string2)) {
            JComboBox<Object> jComboBox = new JComboBox<Object>();
            if (WidgetBuilderUtils.needsEmptyLookupItem(map)) {
                jComboBox.addItem(null);
            }
            List list = CollectionUtils.fromString((String)string2);
            ArrayList arrayList = CollectionUtils.newArrayList();
            BindingConverter bindingConverter = swingMetawidget.getWidgetProcessor(BindingConverter.class);
            for (Object object : list) {
                Object object2 = bindingConverter == null ? object : bindingConverter.convertFromString((String)object, clazz);
                jComboBox.addItem(object2);
                arrayList.add(object2);
            }
            String string3 = map.get("lookup-labels");
            if (string3 != null && !"".equals(string3)) {
                Object object;
                object = CollectionUtils.newHashMap((List)arrayList, (List)CollectionUtils.fromString((String)map.get("lookup-labels")));
                jComboBox.setEditor(new LookupComboBoxEditor((Map<Object, String>)object));
                jComboBox.setRenderer(new LookupComboBoxRenderer((Map<Object, String>)object));
            }
            return jComboBox;
        }
        if (clazz != null) {
            if (clazz.isPrimitive()) {
                Object object;
                if (Boolean.TYPE.equals(clazz)) {
                    return new JCheckBox();
                }
                if (Character.TYPE.equals(clazz)) {
                    return new JTextField();
                }
                String string4 = map.get("minimum-value");
                String string5 = map.get("maximum-value");
                if (string4 != null && !"".equals(string4) && string5 != null && !"".equals(string5)) {
                    JSlider jSlider = new JSlider();
                    jSlider.setMinimum(Integer.parseInt(string4));
                    jSlider.setValue(jSlider.getMinimum());
                    jSlider.setMaximum(Integer.parseInt(string5));
                    return jSlider;
                }
                Comparable comparable = string4 != null && !"".equals(string4) ? (object = (Comparable)ClassUtils.parseNumber((Class)clazz, (String)string4)) : (object = (Comparable)ClassUtils.getNumberMinValue((Class)clazz));
                Comparable comparable2 = string5 != null && !"".equals(string5) ? (object = (Comparable)ClassUtils.parseNumber((Class)clazz, (String)string5)) : (object = (Comparable)ClassUtils.getNumberMaxValue((Class)clazz));
                object = map.containsKey("maximum-fractional-digits") ? (Number)Math.pow(10.0, -Integer.parseInt(map.get("maximum-fractional-digits"))) : (Number)(Float.TYPE.equals(clazz) || Float.class.equals((Object)clazz) ? (Number)Float.valueOf(0.1f) : (Number)(Double.TYPE.equals(clazz) || Double.class.equals((Object)clazz) ? (Number)Float.valueOf(0.1f) : (Number)1));
                Number number = (Number)ClassUtils.parseNumber((Class)clazz, (String)"0");
                if (comparable.compareTo(number) > 0) {
                    number = (Number)((Object)comparable);
                } else if (comparable2.compareTo(number) < 0) {
                    number = (Number)((Object)comparable2);
                }
                JSpinner jSpinner = new JSpinner(new SpinnerNumberModel(number, comparable, comparable2, (Number)object));
                JSpinner.NumberEditor numberEditor = (JSpinner.NumberEditor)jSpinner.getEditor();
                numberEditor.getTextField().setColumns(0);
                DecimalFormat decimalFormat = numberEditor.getFormat();
                if (map.containsKey("minimum-fractional-digits")) {
                    decimalFormat.setMinimumFractionDigits(Integer.parseInt(map.get("minimum-fractional-digits")));
                }
                if (map.containsKey("maximum-fractional-digits")) {
                    decimalFormat.setMaximumFractionDigits(Integer.parseInt(map.get("maximum-fractional-digits")));
                }
                if (map.containsKey("minimum-integer-digits")) {
                    decimalFormat.setMinimumIntegerDigits(Integer.parseInt(map.get("minimum-integer-digits")));
                }
                if (map.containsKey("maximum-integer-digits")) {
                    decimalFormat.setMaximumIntegerDigits(Integer.parseInt(map.get("maximum-integer-digits")));
                }
                return jSpinner;
            }
            if (String.class.equals((Object)clazz)) {
                if ("true".equals(map.get("masked"))) {
                    return new JPasswordField();
                }
                if ("true".equals(map.get("large"))) {
                    JTextArea jTextArea = new JTextArea();
                    jTextArea.setLineWrap(true);
                    jTextArea.setWrapStyleWord(true);
                    jTextArea.setRows(2);
                    return new JScrollPane(jTextArea);
                }
                return new JTextField();
            }
            if (Character.class.isAssignableFrom(clazz)) {
                return new JTextField();
            }
            if (Date.class.equals((Object)clazz)) {
                return new JTextField();
            }
            if (Number.class.isAssignableFrom(clazz)) {
                return new JTextField();
            }
            if (Collection.class.isAssignableFrom(clazz)) {
                return new Stub();
            }
        }
        if ("true".equals(map.get("dont-expand"))) {
            return new JTextField();
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LookupComboBoxRenderer
    extends BasicComboBoxRenderer {
        private Map<Object, String> mLookups;

        public LookupComboBoxRenderer(Map<Object, String> map) {
            if (map == null) {
                throw new NullPointerException("lookups");
            }
            this.mLookups = map;
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            String string = this.mLookups.get(object);
            if (string != null) {
                ((JLabel)component).setText(string);
            }
            return component;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LookupComboBoxEditor
    extends BasicComboBoxEditor {
        private Map<Object, String> mLookups;

        public LookupComboBoxEditor(Map<Object, String> map) {
            if (map == null) {
                throw new NullPointerException("lookups");
            }
            this.mLookups = map;
        }

        @Override
        public void setItem(Object object) {
            super.setItem(this.mLookups.get(object));
        }
    }
}

