/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.swing;

import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.beans.Beans;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import org.metawidget.iface.Immutable;
import org.metawidget.iface.MetawidgetException;
import org.metawidget.inspectionresultprocessor.iface.InspectionResultProcessor;
import org.metawidget.inspector.iface.Inspector;
import org.metawidget.layout.iface.Layout;
import org.metawidget.pipeline.base.BasePipeline;
import org.metawidget.pipeline.w3c.W3CPipeline;
import org.metawidget.swing.Facet;
import org.metawidget.swing.Stub;
import org.metawidget.swing.SwingValuePropertyProvider;
import org.metawidget.util.ArrayUtils;
import org.metawidget.util.ClassUtils;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.simple.PathUtils;
import org.metawidget.util.simple.StringUtils;
import org.metawidget.widgetbuilder.composite.CompositeWidgetBuilder;
import org.metawidget.widgetbuilder.iface.WidgetBuilder;
import org.metawidget.widgetprocessor.iface.WidgetProcessor;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwingMetawidget
extends JComponent {
    private static final Stroke STROKE_DOTTED = new BasicStroke(1.0f, 1, 1, 0.0f, new float[]{3.0f}, 0.0f);
    private Object mToInspect;
    private String mPath;
    private ResourceBundle mBundle;
    private boolean mNeedToBuildWidgets;
    private Element mLastInspectionResult;
    private boolean mIgnoreAddRemove;
    private List<JComponent> mExistingComponents = CollectionUtils.newArrayList();
    private List<JComponent> mExistingUnusedComponents;
    private Map<String, Facet> mFacets = CollectionUtils.newHashMap();
    Pipeline mPipeline = this.newPipeline();

    public void setToInspect(Object toInspect) {
        this.updateToInspectWithoutInvalidate(toInspect);
        this.invalidateInspection();
    }

    public void updateToInspectWithoutInvalidate(Object toInspect) {
        if (this.mToInspect == null) {
            if (this.mPath == null && toInspect != null) {
                this.mPath = toInspect.getClass().getName();
            }
        } else if (this.mToInspect.getClass().getName().equals(this.mPath)) {
            this.mPath = toInspect == null ? null : toInspect.getClass().getName();
        }
        this.mToInspect = toInspect;
    }

    public <T> T getToInspect() {
        return (T)this.mToInspect;
    }

    public void setPath(String path) {
        this.mPath = path;
        this.invalidateInspection();
    }

    public String getPath() {
        return this.mPath;
    }

    public void setConfig(String config) {
        this.mPipeline.setConfig(config);
        this.invalidateInspection();
    }

    public void setInspector(Inspector inspector) {
        this.mPipeline.setInspector(inspector);
        this.invalidateInspection();
    }

    public String inspect(Object toInspect, String type, String ... names) {
        return this.mPipeline.inspect(toInspect, type, names);
    }

    public void addInspectionResultProcessor(InspectionResultProcessor<SwingMetawidget> inspectionResultProcessor) {
        this.mPipeline.addInspectionResultProcessor(inspectionResultProcessor);
        this.invalidateInspection();
    }

    public void removeInspectionResultProcessor(InspectionResultProcessor<SwingMetawidget> inspectionResultProcessor) {
        this.mPipeline.removeInspectionResultProcessor(inspectionResultProcessor);
        this.invalidateInspection();
    }

    public void setInspectionResultProcessors(InspectionResultProcessor<SwingMetawidget> ... inspectionResultProcessors) {
        this.mPipeline.setInspectionResultProcessors(inspectionResultProcessors);
        this.invalidateInspection();
    }

    public void setWidgetBuilder(WidgetBuilder<JComponent, SwingMetawidget> widgetBuilder) {
        this.mPipeline.setWidgetBuilder(widgetBuilder);
        this.invalidateWidgets();
    }

    public WidgetBuilder<JComponent, SwingMetawidget> getWidgetBuilder() {
        this.buildWidgets();
        return this.mPipeline.getWidgetBuilder();
    }

    public void addWidgetProcessor(WidgetProcessor<JComponent, SwingMetawidget> widgetProcessor) {
        this.mPipeline.addWidgetProcessor(widgetProcessor);
        this.invalidateWidgets();
    }

    public void removeWidgetProcessor(WidgetProcessor<JComponent, SwingMetawidget> widgetProcessor) {
        this.mPipeline.removeWidgetProcessor(widgetProcessor);
        this.invalidateWidgets();
    }

    public void setWidgetProcessors(WidgetProcessor<JComponent, SwingMetawidget> ... widgetProcessors) {
        this.mPipeline.setWidgetProcessors(widgetProcessors);
        this.invalidateWidgets();
    }

    public <T> T getWidgetProcessor(Class<T> widgetProcessorClass) {
        this.buildWidgets();
        return (T)this.mPipeline.getWidgetProcessor(widgetProcessorClass);
    }

    public void setMetawidgetLayout(Layout<JComponent, JComponent, SwingMetawidget> layout) {
        this.mPipeline.setLayout(layout);
        this.invalidateWidgets();
    }

    public Layout<JComponent, JComponent, SwingMetawidget> getMetawidgetLayout() {
        this.buildWidgets();
        return this.mPipeline.getLayout();
    }

    public void setBundle(ResourceBundle bundle) {
        this.mBundle = bundle;
        this.invalidateWidgets();
    }

    public String getLabelString(Map<String, String> attributes) {
        if (attributes == null) {
            return "";
        }
        String label = attributes.get("label");
        if (label != null) {
            if ("".equals(label)) {
                return null;
            }
            String localized = this.getLocalizedKey(StringUtils.camelCase((String)label));
            if (localized != null) {
                return localized.trim();
            }
            return label.trim();
        }
        String name = attributes.get("name");
        if (name != null) {
            String localized = this.getLocalizedKey(name);
            if (localized != null) {
                return localized.trim();
            }
            return StringUtils.uncamelCase((String)name);
        }
        return "";
    }

    public String getLocalizedKey(String key) {
        if (this.mBundle == null) {
            return null;
        }
        try {
            return this.mBundle.getString(key);
        }
        catch (MissingResourceException e) {
            return "???" + key + "???";
        }
    }

    public boolean isReadOnly() {
        return this.mPipeline.isReadOnly();
    }

    public void setReadOnly(boolean readOnly) {
        if (this.mPipeline.isReadOnly() == readOnly) {
            return;
        }
        this.mPipeline.setReadOnly(readOnly);
        this.invalidateWidgets();
    }

    public int getMaximumInspectionDepth() {
        return this.mPipeline.getMaximumInspectionDepth();
    }

    public void setMaximumInspectionDepth(int maximumInspectionDepth) {
        this.mPipeline.setMaximumInspectionDepth(maximumInspectionDepth);
        this.invalidateWidgets();
    }

    public List<JComponent> fetchExistingUnusedComponents() {
        return this.mExistingUnusedComponents;
    }

    @Override
    public Dimension getPreferredSize() {
        this.buildWidgets();
        return super.getPreferredSize();
    }

    @Override
    public void setBounds(Rectangle rectangle) {
        this.buildWidgets();
        super.setBounds(rectangle);
    }

    @Override
    public Rectangle getBounds(Rectangle rectangle) {
        this.buildWidgets();
        return super.getBounds(rectangle);
    }

    @Override
    public Component getComponent(int index) {
        this.buildWidgets();
        return super.getComponent(index);
    }

    @Override
    public Component[] getComponents() {
        this.buildWidgets();
        return super.getComponents();
    }

    @Override
    public int getComponentCount() {
        this.buildWidgets();
        return super.getComponentCount();
    }

    @Override
    public LayoutManager getLayout() {
        this.buildWidgets();
        return super.getLayout();
    }

    @Override
    public void addNotify() {
        this.buildWidgets();
        super.addNotify();
    }

    public <T> T getValue(String ... names) {
        ComponentAndValueProperty componentAndValueProperty = this.getComponentAndValueProperty(names);
        return (T)ClassUtils.getProperty((Object)componentAndValueProperty.getComponent(), (String)componentAndValueProperty.getValueProperty());
    }

    public void setValue(Object value, String ... names) {
        ComponentAndValueProperty componentAndValueProperty = this.getComponentAndValueProperty(names);
        ClassUtils.setProperty((Object)componentAndValueProperty.getComponent(), (String)componentAndValueProperty.getValueProperty(), (Object)value);
    }

    public String getValueProperty(Component component) {
        return this.getValueProperty(component, (WidgetBuilder<JComponent, SwingMetawidget>)this.mPipeline.getWidgetBuilder());
    }

    public <T extends Component> T getComponent(String ... names) {
        if (names == null || names.length == 0) {
            return null;
        }
        Component topComponent = this;
        int length = names.length;
        for (int loop = 0; loop < length; ++loop) {
            String name = names[loop];
            if (topComponent instanceof SwingMetawidget) {
                topComponent.buildWidgets();
            }
            topComponent = this.getComponent((Container)topComponent, name);
            if (loop == length - 1) {
                return (T)topComponent;
            }
            if (topComponent != null) continue;
            throw MetawidgetException.newException((String)("No such component '" + name + "' of '" + ArrayUtils.toString((Object)names, (String)"', '") + "'"));
        }
        return (T)topComponent;
    }

    public Facet getFacet(String name) {
        this.buildWidgets();
        return this.mFacets.get(name);
    }

    @Override
    public void remove(Component component) {
        super.remove(component);
        if (!this.mIgnoreAddRemove) {
            this.invalidateWidgets();
            if (component instanceof Facet) {
                this.mFacets.remove(((Facet)component).getName());
            } else {
                this.mExistingComponents.remove(component);
            }
        }
    }

    @Override
    public void remove(int index) {
        Component component = this.getComponent(index);
        super.remove(index);
        if (!this.mIgnoreAddRemove) {
            this.invalidateWidgets();
            if (component instanceof Facet) {
                this.mFacets.remove(((Facet)component).getName());
            } else {
                this.mExistingComponents.remove(component);
            }
        }
    }

    @Override
    public void removeAll() {
        super.removeAll();
        if (!this.mIgnoreAddRemove) {
            this.invalidateWidgets();
            this.mFacets.clear();
            this.mExistingComponents.clear();
        }
    }

    public void initNestedMetawidget(SwingMetawidget nestedMetawidget, Map<String, String> attributes) {
        this.mPipeline.initNestedPipeline((BasePipeline)nestedMetawidget.mPipeline, attributes);
        nestedMetawidget.setPath(this.mPath + '/' + attributes.get("name"));
        nestedMetawidget.setBundle(this.mBundle);
        nestedMetawidget.setOpaque(this.isOpaque());
        nestedMetawidget.setToInspect(this.mToInspect);
    }

    protected Pipeline newPipeline() {
        return new Pipeline();
    }

    protected String getDefaultConfiguration() {
        return ClassUtils.getPackagesAsFolderNames(SwingMetawidget.class) + "/metawidget-swing-default.xml";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(Graphics graphics) {
        this.buildWidgets();
        super.paintComponent(graphics);
        if (Beans.isDesignTime()) {
            Graphics2D graphics2d = (Graphics2D)graphics;
            Stroke strokeBefore = graphics2d.getStroke();
            try {
                graphics2d.setStroke(STROKE_DOTTED);
                int height = this.getHeight();
                graphics2d.drawRect(0, 0, this.getWidth() - 1, height - 1);
                graphics2d.drawString("Metawidget", 10, height / 2);
            }
            finally {
                graphics2d.setStroke(strokeBefore);
            }
        }
    }

    protected void invalidateInspection() {
        this.mLastInspectionResult = null;
        this.invalidateWidgets();
    }

    protected void invalidateWidgets() {
        if (this.mNeedToBuildWidgets) {
            return;
        }
        super.removeAll();
        this.mNeedToBuildWidgets = true;
        this.repaint();
    }

    @Override
    protected void addImpl(Component component, Object constraints, int index) {
        if (!this.mIgnoreAddRemove) {
            this.invalidateWidgets();
            if (component instanceof Facet) {
                this.mFacets.put(component.getName(), (Facet)component);
                return;
            }
            if (component instanceof JComponent) {
                this.mExistingComponents.add((JComponent)component);
            }
        }
        super.addImpl(component, constraints, index);
    }

    protected void buildWidgets() {
        if (!this.mNeedToBuildWidgets || Beans.isDesignTime()) {
            return;
        }
        this.mPipeline.configureOnce();
        this.mNeedToBuildWidgets = false;
        this.mIgnoreAddRemove = true;
        try {
            if (this.mLastInspectionResult == null) {
                this.mLastInspectionResult = this.inspect();
            }
            this.mPipeline.buildWidgets(this.mLastInspectionResult);
        }
        catch (Exception e) {
            throw MetawidgetException.newException((Throwable)e);
        }
        finally {
            this.mIgnoreAddRemove = false;
        }
    }

    protected void startBuild() {
        this.mExistingUnusedComponents = CollectionUtils.newArrayList(this.mExistingComponents);
    }

    protected void layoutWidget(Component component, String elementName, Map<String, String> attributes) {
        component.setName(attributes.get("name"));
        this.remove(component);
        Map<String, String> additionalAttributes = this.mPipeline.getAdditionalAttributes((JComponent)component);
        if (additionalAttributes != null) {
            attributes.putAll(additionalAttributes);
        }
    }

    protected void endBuild() {
        if (this.mExistingUnusedComponents != null) {
            for (JComponent componentExisting : this.mExistingUnusedComponents) {
                if (componentExisting instanceof Facet) continue;
                HashMap attributes = CollectionUtils.newHashMap();
                attributes.put("section", "");
                this.mPipeline.layoutWidget(componentExisting, "property", (Map<String, String>)attributes);
            }
        }
    }

    private Element inspect() {
        if (this.mPath == null) {
            return null;
        }
        PathUtils.TypeAndNames typeAndNames = PathUtils.parsePath((String)this.mPath);
        return (Element)this.mPipeline.inspectAsDom(this.mToInspect, typeAndNames.getType(), typeAndNames.getNamesAsArray());
    }

    private ComponentAndValueProperty getComponentAndValueProperty(String ... names) {
        String componentProperty;
        Object component = this.getComponent(names);
        if (component == null) {
            throw MetawidgetException.newException((String)("No component named '" + ArrayUtils.toString((Object)names, (String)"', '") + "'"));
        }
        if (component instanceof JScrollPane) {
            component = ((JScrollPane)component).getViewport().getView();
        }
        if ((componentProperty = this.getValueProperty((Component)component)) == null) {
            throw MetawidgetException.newException((String)("Don't know how to getValue from a " + component.getClass().getName()));
        }
        return new ComponentAndValueProperty((Component)component, componentProperty);
    }

    private String getValueProperty(Component component, WidgetBuilder<JComponent, SwingMetawidget> widgetBuilder) {
        try {
            if (widgetBuilder instanceof CompositeWidgetBuilder) {
                for (WidgetBuilder widgetBuilderChild : ((CompositeWidgetBuilder)widgetBuilder).getWidgetBuilders()) {
                    String valueProperty = this.getValueProperty(component, (WidgetBuilder<JComponent, SwingMetawidget>)widgetBuilderChild);
                    if (valueProperty == null) continue;
                    return valueProperty;
                }
                return null;
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        if (widgetBuilder instanceof SwingValuePropertyProvider) {
            return ((SwingValuePropertyProvider)widgetBuilder).getValueProperty(component);
        }
        return null;
    }

    private Component getComponent(Container container, String name) {
        for (Component childComponent : container.getComponents()) {
            if (!(childComponent.getName() == null && childComponent instanceof Container ? (childComponent = this.getComponent((Container)childComponent, name)) != null : name.equals(childComponent.getName()))) continue;
            return childComponent;
        }
        return null;
    }

    private static class ComponentAndValueProperty
    implements Immutable {
        private Component mComponent;
        private String mValueProperty;

        public ComponentAndValueProperty(Component component, String valueProperty) {
            this.mComponent = component;
            this.mValueProperty = valueProperty;
        }

        public Component getComponent() {
            return this.mComponent;
        }

        public String getValueProperty() {
            return this.mValueProperty;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Pipeline
    extends W3CPipeline<JComponent, JComponent, SwingMetawidget> {
        protected Pipeline() {
        }

        protected SwingMetawidget getPipelineOwner() {
            return SwingMetawidget.this;
        }

        protected String getDefaultConfiguration() {
            return SwingMetawidget.this.getDefaultConfiguration();
        }

        protected void configure() {
            if (Beans.isDesignTime()) {
                return;
            }
            super.configure();
        }

        protected void configureDefaults() {
            super.configureDefaults();
            if (this.getLayout() == null) {
                this.getConfigReader().configure(this.getDefaultConfiguration(), (Object)this.getPipelineOwner(), new String[]{"metawidgetLayout"});
            }
        }

        protected void startBuild() {
            super.startBuild();
            SwingMetawidget.this.startBuild();
        }

        protected void layoutWidget(JComponent component, String elementName, Map<String, String> attributes) {
            SwingMetawidget.this.layoutWidget(component, elementName, attributes);
            if (this.getLayout() == null) {
                SwingMetawidget.this.add(component);
            } else {
                super.layoutWidget((Object)component, elementName, attributes);
            }
            if (component instanceof SwingMetawidget) {
                ((SwingMetawidget)component).buildWidgets();
            }
        }

        protected Map<String, String> getAdditionalAttributes(JComponent component) {
            if (component instanceof Stub) {
                return ((Stub)component).getAttributes();
            }
            return null;
        }

        public SwingMetawidget buildNestedMetawidget(Map<String, String> attributes) throws Exception {
            SwingMetawidget nestedMetawidget = (SwingMetawidget)SwingMetawidget.this.getClass().newInstance();
            SwingMetawidget.this.initNestedMetawidget(nestedMetawidget, attributes);
            return nestedMetawidget;
        }

        protected void endBuild() {
            SwingMetawidget.this.endBuild();
            super.endBuild();
            SwingMetawidget.this.validate();
        }
    }
}

