/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.swing.widgetbuilder;

import java.util.Collection;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.metawidget.util.ClassUtils;
import org.metawidget.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CollectionTableModel<T>
extends AbstractTableModel {
    private List<T> mList;
    private List<String> mColumns;
    private List<String> mColumnNames;

    public CollectionTableModel(Collection<T> collection, List<String> columns, List<String> columnNames) {
        if (collection instanceof List) {
            this.mList = (List)collection;
        } else if (collection != null) {
            this.mList = CollectionUtils.newArrayList(collection);
        }
        this.mColumns = columns;
        this.mColumnNames = columnNames;
    }

    @Override
    public int getColumnCount() {
        return this.mColumns.size();
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex >= this.getColumnCount()) {
            return null;
        }
        return this.mColumnNames.get(columnIndex);
    }

    @Override
    public int getRowCount() {
        if (this.mList == null) {
            return 0;
        }
        return this.mList.size();
    }

    public T getValueAt(int rowIndex) {
        if (rowIndex >= this.getRowCount()) {
            return null;
        }
        return this.mList.get(rowIndex);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex >= this.getColumnCount()) {
            return null;
        }
        T t = this.getValueAt(rowIndex);
        if (t == null) {
            return null;
        }
        String column = this.mColumns.get(columnIndex);
        if ("toString".equals(column)) {
            return t.toString();
        }
        return ClassUtils.getProperty(t, (String)column);
    }
}

