/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.swing.layout;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.Border;
import org.metawidget.swing.SwingMetawidget;
import org.metawidget.swing.layout.SeparatorLayoutDecoratorConfig;
import org.metawidget.swing.layout.SwingFlatSectionLayoutDecorator;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.simple.StringUtils;

public class SeparatorLayoutDecorator
extends SwingFlatSectionLayoutDecorator {
    private static final Border BORDER_SECTION = BorderFactory.createEmptyBorder(5, 0, 5, 0);
    private static final Insets INSETS_SECTION_LABEL_LEFT = new Insets(0, 0, 0, 5);
    private static final Insets INSETS_SECTION_LABEL_RIGHT = new Insets(0, 5, 0, 0);
    private final int mAlignment;

    public SeparatorLayoutDecorator(SeparatorLayoutDecoratorConfig config) {
        super(config);
        this.mAlignment = config.getAlignment();
    }

    protected void addSectionWidget(String section, int level, JComponent container, SwingMetawidget metawidget) {
        JPanel separatorPanel = new JPanel();
        separatorPanel.setBorder(BORDER_SECTION);
        separatorPanel.setLayout(new GridBagLayout());
        separatorPanel.setOpaque(false);
        String localizedSection = metawidget.getLocalizedKey(StringUtils.camelCase((String)section));
        if (localizedSection == null) {
            localizedSection = section;
        }
        GridBagConstraints labelConstraints = new GridBagConstraints();
        GridBagConstraints separatorConstraints = new GridBagConstraints();
        separatorConstraints.fill = 2;
        separatorConstraints.weightx = 1.0;
        if (this.mAlignment == 4) {
            separatorConstraints.gridx = 0;
            labelConstraints.gridx = 1;
            labelConstraints.insets = INSETS_SECTION_LABEL_RIGHT;
        } else {
            labelConstraints.insets = INSETS_SECTION_LABEL_LEFT;
        }
        separatorPanel.add((Component)new JLabel(localizedSection), labelConstraints);
        separatorPanel.add((Component)new JSeparator(0), separatorConstraints);
        HashMap separatorPanelAttributes = CollectionUtils.newHashMap();
        separatorPanelAttributes.put("label", "");
        separatorPanelAttributes.put("wide", "true");
        this.getDelegate().layoutWidget((Object)separatorPanel, "property", (Map)separatorPanelAttributes, (Object)container, (Object)metawidget);
    }
}

