/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.swing.layout;

import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import org.metawidget.swing.SwingMetawidget;
import org.metawidget.swing.layout.SwingNestedSectionLayoutDecorator;
import org.metawidget.swing.layout.TabbedPaneLayoutDecoratorConfig;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.simple.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TabbedPaneLayoutDecorator
extends SwingNestedSectionLayoutDecorator {
    private static final Border TABBED_PANE_BORDER = BorderFactory.createEmptyBorder(5, 0, 5, 0);
    private static final Border TAB_PANEL_BORDER = BorderFactory.createEmptyBorder(3, 3, 3, 3);
    private final int mTabPlacement;

    public TabbedPaneLayoutDecorator(TabbedPaneLayoutDecoratorConfig config) {
        super(config);
        this.mTabPlacement = config.getTabPlacement();
    }

    protected JComponent createSectionWidget(JComponent previousSectionWidget, String section, Map<String, String> attributes, JComponent container, SwingMetawidget metawidget) {
        JTabbedPane tabbedPane;
        if (previousSectionWidget == null) {
            tabbedPane = new JTabbedPane();
            tabbedPane.setBorder(TABBED_PANE_BORDER);
            tabbedPane.setTabPlacement(this.mTabPlacement);
            HashMap tabbedPaneAttributes = CollectionUtils.newHashMap();
            tabbedPaneAttributes.put("label", "");
            tabbedPaneAttributes.put("large", "true");
            this.getDelegate().layoutWidget((Object)tabbedPane, "property", (Map)tabbedPaneAttributes, (Object)container, (Object)metawidget);
        } else {
            tabbedPane = (JTabbedPane)previousSectionWidget.getParent();
        }
        JPanel tabPanel = new JPanel();
        tabPanel.setBorder(TAB_PANEL_BORDER);
        String localizedSection = metawidget.getLocalizedKey(StringUtils.camelCase((String)section));
        if (localizedSection == null) {
            localizedSection = section;
        }
        tabbedPane.addTab(localizedSection, tabPanel);
        return tabPanel;
    }
}

