/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executor;
import org.modeshape.common.SystemFailureException;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.component.ClassLoaderFactory;
import org.modeshape.common.component.StandardClassLoaderFactory;
import org.modeshape.common.component.ThreadPoolFactory;
import org.modeshape.common.component.ThreadPools;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.SecureHash;
import org.modeshape.jcr.api.mimetype.MimeTypeDetector;
import org.modeshape.jcr.mimetype.MimeTypeDetectors;
import org.modeshape.jcr.security.SecurityContext;
import org.modeshape.jcr.value.NamespaceRegistry;
import org.modeshape.jcr.value.PropertyFactory;
import org.modeshape.jcr.value.ValueFactories;
import org.modeshape.jcr.value.basic.BasicPropertyFactory;
import org.modeshape.jcr.value.basic.SimpleNamespaceRegistry;
import org.modeshape.jcr.value.basic.StandardValueFactories;
import org.modeshape.jcr.value.basic.ThreadSafeNamespaceRegistry;
import org.modeshape.jcr.value.binary.BinaryStore;
import org.modeshape.jcr.value.binary.TransientBinaryStore;

@Immutable
public class ExecutionContext
implements ClassLoaderFactory,
ThreadPoolFactory,
Cloneable {
    public static final ExecutionContext DEFAULT_CONTEXT = new ExecutionContext();
    private final ClassLoaderFactory classLoaderFactory;
    private final ThreadPoolFactory threadPools;
    private final PropertyFactory propertyFactory;
    private final ValueFactories valueFactories;
    private final NamespaceRegistry namespaceRegistry;
    private final MimeTypeDetector mimeTypeDetector;
    private final SecurityContext securityContext;
    private final BinaryStore binaryStore;
    private final String id = ExecutionContext.sha1(UUID.randomUUID().toString()).substring(0, 9);
    private final String processId;
    private final Map<String, String> data;

    private static String sha1(String name) {
        try {
            byte[] sha1 = SecureHash.getHash((SecureHash.Algorithm)SecureHash.Algorithm.SHA_1, (byte[])name.getBytes());
            return SecureHash.asHexString((byte[])sha1);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SystemFailureException((Throwable)e);
        }
    }

    public ExecutionContext() {
        this(new NullSecurityContext(), null, null, null, null, null, null, null, null, null);
        this.initializeDefaultNamespaces(this.getNamespaceRegistry());
        assert (this.securityContext != null);
    }

    public ExecutionContext(ExecutionContext original) {
        CheckArg.isNotNull((Object)original, (String)"original");
        this.securityContext = original.getSecurityContext();
        this.namespaceRegistry = original.getNamespaceRegistry();
        this.valueFactories = original.getValueFactories();
        this.propertyFactory = original.getPropertyFactory();
        this.classLoaderFactory = original.getClassLoaderFactory();
        this.threadPools = original.getThreadPoolFactory();
        this.mimeTypeDetector = original.getMimeTypeDetector();
        this.data = original.getData();
        this.processId = original.getProcessId();
        this.binaryStore = TransientBinaryStore.get();
    }

    protected ExecutionContext(ExecutionContext original, SecurityContext securityContext) {
        CheckArg.isNotNull((Object)original, (String)"original");
        CheckArg.isNotNull((Object)securityContext, (String)"securityContext");
        this.securityContext = securityContext;
        this.namespaceRegistry = original.getNamespaceRegistry();
        this.valueFactories = original.getValueFactories();
        this.propertyFactory = original.getPropertyFactory();
        this.classLoaderFactory = original.getClassLoaderFactory();
        this.threadPools = original.getThreadPoolFactory();
        this.mimeTypeDetector = original.getMimeTypeDetector();
        this.data = original.getData();
        this.processId = original.getProcessId();
        this.binaryStore = original.getBinaryStore();
    }

    protected ExecutionContext(SecurityContext securityContext, NamespaceRegistry namespaceRegistry, ValueFactories valueFactories, PropertyFactory propertyFactory, MimeTypeDetector mimeTypeDetector, ClassLoaderFactory classLoaderFactory, ThreadPoolFactory threadPoolFactory, BinaryStore binaryStore, Map<String, String> data, String processId) {
        assert (securityContext != null);
        this.securityContext = securityContext;
        if (binaryStore == null) {
            binaryStore = TransientBinaryStore.get();
        }
        this.binaryStore = binaryStore;
        this.namespaceRegistry = namespaceRegistry != null ? namespaceRegistry : new ThreadSafeNamespaceRegistry(new SimpleNamespaceRegistry());
        this.valueFactories = valueFactories == null ? new StandardValueFactories(this.namespaceRegistry, binaryStore) : valueFactories;
        this.propertyFactory = propertyFactory == null ? new BasicPropertyFactory(this.valueFactories) : propertyFactory;
        this.classLoaderFactory = classLoaderFactory == null ? new StandardClassLoaderFactory() : classLoaderFactory;
        this.threadPools = threadPoolFactory == null ? new ThreadPools() : threadPoolFactory;
        this.mimeTypeDetector = mimeTypeDetector != null ? mimeTypeDetector : new MimeTypeDetectors();
        this.data = data != null ? data : Collections.emptyMap();
        this.processId = processId != null ? processId : UUID.randomUUID().toString();
    }

    protected ClassLoaderFactory getClassLoaderFactory() {
        return this.classLoaderFactory;
    }

    protected ThreadPoolFactory getThreadPoolFactory() {
        return this.threadPools;
    }

    public Logger getLogger(Class<?> clazz) {
        return Logger.getLogger(clazz);
    }

    public Logger getLogger(String name) {
        return Logger.getLogger((String)name);
    }

    public MimeTypeDetector getMimeTypeDetector() {
        return this.mimeTypeDetector;
    }

    public SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public NamespaceRegistry getNamespaceRegistry() {
        return this.namespaceRegistry;
    }

    public final PropertyFactory getPropertyFactory() {
        return this.propertyFactory;
    }

    public ValueFactories getValueFactories() {
        return this.valueFactories;
    }

    public BinaryStore getBinaryStore() {
        return this.binaryStore;
    }

    public ClassLoader getClassLoader(String ... classpath) {
        return this.classLoaderFactory.getClassLoader(classpath);
    }

    public Executor getThreadPool(String name) {
        return this.threadPools.getThreadPool(name);
    }

    public void releaseThreadPool(Executor pool) {
        this.threadPools.releaseThreadPool(pool);
    }

    public String getId() {
        return this.id;
    }

    public String getProcessId() {
        return this.processId;
    }

    public Map<String, String> getData() {
        return Collections.unmodifiableMap(this.data);
    }

    public ExecutionContext with(BinaryStore binaryStore) {
        if (binaryStore == null) {
            binaryStore = TransientBinaryStore.get();
        }
        return new ExecutionContext(this.getSecurityContext(), this.getNamespaceRegistry(), this.valueFactories, this.getPropertyFactory(), this.getMimeTypeDetector(), this.getClassLoaderFactory(), this.getThreadPoolFactory(), binaryStore, this.getData(), this.getProcessId());
    }

    public ExecutionContext with(NamespaceRegistry namespaceRegistry) {
        return new ExecutionContext(this.getSecurityContext(), namespaceRegistry, null, this.getPropertyFactory(), this.getMimeTypeDetector(), this.getClassLoaderFactory(), this.getThreadPoolFactory(), this.getBinaryStore(), this.getData(), this.getProcessId());
    }

    public ExecutionContext with(MimeTypeDetector mimeTypeDetector) {
        return new ExecutionContext(this.getSecurityContext(), this.getNamespaceRegistry(), this.getValueFactories(), this.getPropertyFactory(), mimeTypeDetector, this.getClassLoaderFactory(), this.getThreadPoolFactory(), this.getBinaryStore(), this.getData(), this.getProcessId());
    }

    public ExecutionContext with(ClassLoaderFactory classLoaderFactory) {
        return new ExecutionContext(this.getSecurityContext(), this.getNamespaceRegistry(), this.getValueFactories(), this.getPropertyFactory(), this.getMimeTypeDetector(), classLoaderFactory, this.getThreadPoolFactory(), this.getBinaryStore(), this.getData(), this.getProcessId());
    }

    public ExecutionContext with(ThreadPoolFactory threadPoolFactory) {
        return new ExecutionContext(this.getSecurityContext(), this.getNamespaceRegistry(), this.getValueFactories(), this.getPropertyFactory(), this.getMimeTypeDetector(), this.getClassLoaderFactory(), threadPoolFactory, this.getBinaryStore(), this.getData(), this.getProcessId());
    }

    public ExecutionContext with(PropertyFactory propertyFactory) {
        return new ExecutionContext(this.getSecurityContext(), this.getNamespaceRegistry(), this.getValueFactories(), propertyFactory, this.getMimeTypeDetector(), this.getClassLoaderFactory(), this.getThreadPoolFactory(), this.getBinaryStore(), this.getData(), this.getProcessId());
    }

    public ExecutionContext with(SecurityContext securityContext) {
        return new ExecutionContext(this, securityContext);
    }

    public ExecutionContext with(Map<String, String> data) {
        Map<String, String> newData = data;
        if (data == null) {
            if (this.data.isEmpty()) {
                return this;
            }
        } else {
            newData = Collections.unmodifiableMap(new HashMap<String, String>(data));
        }
        return new ExecutionContext(this.getSecurityContext(), this.getNamespaceRegistry(), this.getValueFactories(), this.getPropertyFactory(), this.getMimeTypeDetector(), this.getClassLoaderFactory(), this.getThreadPoolFactory(), this.getBinaryStore(), newData, this.getProcessId());
    }

    public ExecutionContext with(String key, String value) {
        Map<String, String> newData = this.data;
        if (value == null) {
            if (this.data.isEmpty() || !this.data.containsKey(key)) {
                return this;
            }
            newData = new HashMap<String, String>(this.data);
            newData.remove(key);
            newData = Collections.unmodifiableMap(newData);
        } else {
            newData = new HashMap<String, String>(this.data);
            newData.put(key, value);
            newData = Collections.unmodifiableMap(newData);
        }
        return new ExecutionContext(this.getSecurityContext(), this.getNamespaceRegistry(), this.getValueFactories(), this.getPropertyFactory(), this.getMimeTypeDetector(), this.getClassLoaderFactory(), this.getThreadPoolFactory(), this.getBinaryStore(), newData, this.getProcessId());
    }

    public ExecutionContext with(String processId) {
        return new ExecutionContext(this.getSecurityContext(), this.getNamespaceRegistry(), this.getValueFactories(), this.getPropertyFactory(), this.getMimeTypeDetector(), this.getClassLoaderFactory(), this.getThreadPoolFactory(), this.getBinaryStore(), this.getData(), processId);
    }

    public ExecutionContext clone() {
        return new ExecutionContext(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Execution context for ");
        if (this.getSecurityContext() == null) {
            sb.append("null");
        } else {
            sb.append(this.getSecurityContext().getUserName());
        }
        sb.append(" (").append(this.id).append(')');
        return sb.toString();
    }

    protected void initializeDefaultNamespaces(NamespaceRegistry namespaceRegistry) {
        if (namespaceRegistry == null) {
            return;
        }
        namespaceRegistry.register("jcr", "http://www.jcp.org/jcr/1.0");
        namespaceRegistry.register("mix", "http://www.jcp.org/jcr/mix/1.0");
        namespaceRegistry.register("nt", "http://www.jcp.org/jcr/nt/1.0");
        namespaceRegistry.register("mode", "http://www.modeshape.org/1.0");
    }

    private static class NullSecurityContext
    implements SecurityContext {
        private NullSecurityContext() {
        }

        @Override
        public boolean isAnonymous() {
            return true;
        }

        @Override
        public String getUserName() {
            return null;
        }

        @Override
        public boolean hasRole(String roleName) {
            return false;
        }

        @Override
        public void logout() {
        }
    }
}

