/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.Item;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.MergeException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import javax.jcr.version.VersionManager;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.common.i18n.I18n;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.AbstractJcrProperty;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.JcrEmptyNodeIterator;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.JcrMixLexicon;
import org.modeshape.jcr.JcrNodeListIterator;
import org.modeshape.jcr.JcrNtLexicon;
import org.modeshape.jcr.JcrPropertyDefinition;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.JcrValue;
import org.modeshape.jcr.JcrVersionHistoryNode;
import org.modeshape.jcr.JcrVersionNode;
import org.modeshape.jcr.JcrWorkspace;
import org.modeshape.jcr.RepositoryNodeTypeManager;
import org.modeshape.jcr.SystemContent;
import org.modeshape.jcr.api.value.DateTime;
import org.modeshape.jcr.cache.CachedNode;
import org.modeshape.jcr.cache.ChildReference;
import org.modeshape.jcr.cache.ChildReferences;
import org.modeshape.jcr.cache.MutableCachedNode;
import org.modeshape.jcr.cache.NodeCache;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.SessionCache;
import org.modeshape.jcr.value.DateTimeFactory;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.NameFactory;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.PathFactory;
import org.modeshape.jcr.value.Property;
import org.modeshape.jcr.value.PropertyFactory;
import org.modeshape.jcr.value.Reference;
import org.modeshape.jcr.value.ReferenceFactory;

final class JcrVersionManager
implements VersionManager {
    static final Set<Name> IGNORED_PROP_NAMES_FOR_RESTORE = Collections.unmodifiableSet(new HashSet<Name>(Arrays.asList(JcrLexicon.FROZEN_PRIMARY_TYPE, JcrLexicon.FROZEN_MIXIN_TYPES, JcrLexicon.FROZEN_UUID, JcrLexicon.PRIMARY_TYPE, JcrLexicon.MIXIN_TYPES, JcrLexicon.UUID)));
    private final JcrSession session;
    private final Path versionStoragePath;
    private final PathAlgorithm versionHistoryPathAlgorithm;
    private final SystemContent readableSystem;

    public JcrVersionManager(JcrSession session) {
        this.session = session;
        this.versionStoragePath = this.absolutePath(JcrLexicon.SYSTEM, JcrLexicon.VERSION_STORAGE);
        ExecutionContext context = session.context();
        this.versionHistoryPathAlgorithm = new HiearchicalPathAlgorithm(this.versionStoragePath, context);
        this.readableSystem = new SystemContent(this.session.cache());
    }

    final ExecutionContext context() {
        return this.session.context();
    }

    final Name name(String s) {
        return (Name)this.session().nameFactory().create(s);
    }

    final String string(Object propertyValue) {
        return this.session.stringFactory().create(propertyValue);
    }

    final Name name(Object ob) {
        return (Name)this.session.nameFactory().create(ob);
    }

    final Path path(Path root, Name child) {
        return this.session.pathFactory().create(root, child);
    }

    final Path path(Path root, Path.Segment childSegment) {
        return this.session.pathFactory().create(root, childSegment);
    }

    final Path absolutePath(Name ... absolutePathSegments) {
        return this.session.pathFactory().createAbsolutePath(absolutePathSegments);
    }

    final PropertyFactory propertyFactory() {
        return this.session.propertyFactory();
    }

    final SessionCache cache() {
        return this.session.cache();
    }

    final JcrRepository repository() {
        return this.session.repository();
    }

    final JcrSession session() {
        return this.session;
    }

    final JcrWorkspace workspace() {
        return this.session.workspace();
    }

    Path versionHistoryPathFor(NodeKey key) {
        return this.versionHistoryPathAlgorithm.versionHistoryPathFor(key.getIdentifierHash());
    }

    public JcrVersionHistoryNode getVersionHistory(String absPath) throws RepositoryException {
        return this.getVersionHistory(this.session.getNode(absPath));
    }

    JcrVersionHistoryNode getVersionHistory(AbstractJcrNode node) throws RepositoryException {
        this.checkVersionable(node);
        NodeKey historyKey = this.readableSystem.versionHistoryNodeKeyFor(node.key());
        SessionCache cache = this.session.cache();
        CachedNode historyNode = cache.getNode(historyKey);
        if (historyNode != null) {
            return (JcrVersionHistoryNode)this.session.node(historyNode, AbstractJcrNode.Type.VERSION_HISTORY);
        }
        if (node.isNew()) {
            String msg = JcrI18n.noVersionHistoryForTransientVersionableNodes.text(new Object[]{node.location()});
            throw new InvalidItemStateException(msg);
        }
        CachedNode cachedNode = node.node();
        if (cachedNode instanceof MutableCachedNode) {
            Set<Name> mixinTypes;
            Name primaryType;
            MutableCachedNode mutable = (MutableCachedNode)cachedNode;
            RepositoryNodeTypeManager.NodeTypes nodeTypeCapabilities = this.repository().nodeTypeManager().getNodeTypes();
            if (nodeTypeCapabilities.isVersionable(primaryType = mutable.getPrimaryType(cache), mixinTypes = mutable.getAddedMixins(cache))) {
                String msg = JcrI18n.versionHistoryForNewlyVersionableNodesNotAvailableUntilSave.text(new Object[]{node.location()});
                throw new UnsupportedRepositoryOperationException(msg);
            }
        }
        this.initializeVersionHistoryFor(node, historyKey, cache);
        historyNode = cache.getNode(historyKey);
        return (JcrVersionHistoryNode)this.session.node(historyNode, AbstractJcrNode.Type.VERSION_HISTORY);
    }

    private void initializeVersionHistoryFor(AbstractJcrNode node, NodeKey historyKey, SessionCache cache) throws RepositoryException {
        SystemContent content = new SystemContent(this.session.createSystemCache(false));
        CachedNode cachedNode = node.node();
        Name primaryTypeName = cachedNode.getPrimaryType(cache);
        Set<Name> mixinTypeNames = cachedNode.getMixinTypes(cache);
        NodeKey versionedKey = cachedNode.getKey();
        Path versionHistoryPath = this.versionHistoryPathFor(versionedKey);
        DateTime now = this.session().dateFactory().create();
        content.initializeVersionStorage(versionedKey, historyKey, null, primaryTypeName, mixinTypeNames, versionHistoryPath, null, now);
        content.save();
    }

    private void checkVersionable(AbstractJcrNode node) throws UnsupportedRepositoryOperationException, RepositoryException {
        if (!node.isNodeType(JcrMixLexicon.VERSIONABLE)) {
            throw new UnsupportedRepositoryOperationException(JcrI18n.requiresVersionable.text(new Object[0]));
        }
    }

    public Version getBaseVersion(String absPath) throws UnsupportedRepositoryOperationException, RepositoryException {
        return this.session.getNode(absPath).getBaseVersion();
    }

    public boolean isCheckedOut(String absPath) throws RepositoryException {
        return this.session.getNode(absPath).isCheckedOut();
    }

    public Version checkin(String absPath) throws VersionException, UnsupportedRepositoryOperationException, InvalidItemStateException, LockException, RepositoryException {
        return this.checkin(this.session.getNode(absPath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JcrVersionNode checkin(AbstractJcrNode node) throws RepositoryException {
        this.checkVersionable(node);
        if (node.isNew() || node.isModified()) {
            throw new InvalidItemStateException(JcrI18n.noPendingChangesAllowed.text(new Object[0]));
        }
        if (node.isLocked() && !node.holdsLock()) {
            throw new LockException(JcrI18n.lockTokenNotHeld.text(new Object[]{node.getPath()}));
        }
        if (node.getProperty(JcrLexicon.MERGE_FAILED) != null) {
            throw new VersionException(JcrI18n.pendingMergeConflicts.text(new Object[]{node.getPath()}));
        }
        AbstractJcrProperty isCheckedOut = node.getProperty(JcrLexicon.IS_CHECKED_OUT);
        if (!isCheckedOut.getBoolean()) {
            return node.getBaseVersion();
        }
        SessionCache cache = this.cache();
        NodeKey versionedKey = node.key();
        Path versionHistoryPath = this.versionHistoryPathFor(versionedKey);
        CachedNode cachedNode = node.node();
        DateTime now = this.session().dateFactory().create();
        SessionCache systemSession = this.session.createSystemCache(false);
        SystemContent systemContent = new SystemContent(systemSession);
        MutableCachedNode version = null;
        ArrayList<Property> versionableProps = new ArrayList<Property>();
        this.addVersionedPropertiesFor(node, false, versionableProps);
        AtomicReference<MutableCachedNode> frozen = new AtomicReference<MutableCachedNode>();
        version = systemContent.recordNewVersion(cachedNode, cache, versionHistoryPath, null, versionableProps, now, frozen);
        NodeKey historyKey = version.getParentKey(systemSession);
        SessionCache versionSession = this.session.spawnSessionCache(false);
        MutableCachedNode versionableNode = versionSession.mutable(versionedKey);
        PropertyFactory props = this.propertyFactory();
        ReferenceFactory refFactory = this.session.referenceFactory();
        Reference historyRef = refFactory.create(historyKey, true);
        Reference baseVersionRef = refFactory.create(version.getKey(), true);
        versionableNode.setProperty(versionSession, props.create(JcrLexicon.VERSION_HISTORY, historyRef));
        versionableNode.setProperty(versionSession, props.create(JcrLexicon.BASE_VERSION, baseVersionRef));
        versionableNode.setProperty(versionSession, props.create(JcrLexicon.IS_CHECKED_OUT, Boolean.FALSE));
        versionableNode.setProperty(versionSession, props.create(JcrLexicon.PREDECESSORS, new Object[0]));
        MutableCachedNode frozenNode = frozen.get();
        for (ChildReference childRef : cachedNode.getChildReferences(versionSession)) {
            AbstractJcrNode child = this.session.node(childRef.getKey(), null);
            this.versionNodeAt(child, frozenNode, false, versionSession, systemSession);
        }
        versionSession.save(systemSession, null);
        return (JcrVersionNode)this.session.node((CachedNode)version, AbstractJcrNode.Type.VERSION);
    }

    private void versionNodeAt(AbstractJcrNode node, MutableCachedNode parentInVersionHistory, boolean forceCopy, SessionCache nodeCache, SessionCache versionHistoryCache) throws RepositoryException {
        int onParentVersion = 0;
        onParentVersion = forceCopy ? 1 : node.getDefinition().getOnParentVersion();
        NodeKey key = parentInVersionHistory.getKey().withRandomId();
        switch (onParentVersion) {
            case 6: {
                throw new VersionException(JcrI18n.cannotCheckinNodeWithAbortChildNode.text(new Object[]{node.getName(), node.getParent().getName()}));
            }
            case 2: {
                if (node.isNodeType(JcrMixLexicon.VERSIONABLE)) {
                    JcrVersionHistoryNode history = node.getVersionHistory();
                    Property primaryType = this.propertyFactory().create(JcrLexicon.PRIMARY_TYPE, JcrNtLexicon.VERSIONED_CHILD);
                    Property childVersionHistory = this.propertyFactory().create(JcrLexicon.CHILD_VERSION_HISTORY, history.key().toString());
                    parentInVersionHistory.createChild(versionHistoryCache, key, node.name(), primaryType, childVersionHistory);
                    return;
                }
            }
            case 1: {
                forceCopy = true;
                Name primaryTypeName = node.getPrimaryTypeName();
                Set<Name> mixinTypeNames = node.getMixinTypeNames();
                PropertyFactory factory = this.propertyFactory();
                LinkedList<Property> props = new LinkedList<Property>();
                props.add(factory.create(JcrLexicon.PRIMARY_TYPE, JcrNtLexicon.FROZEN_NODE));
                props.add(factory.create(JcrLexicon.FROZEN_PRIMARY_TYPE, primaryTypeName));
                props.add(factory.create(JcrLexicon.FROZEN_MIXIN_TYPES, mixinTypeNames));
                props.add(factory.create(JcrLexicon.FROZEN_UUID, node.getIdentifier()));
                props.add(factory.create(JcrLexicon.UUID, key));
                this.addVersionedPropertiesFor(node, forceCopy, props);
                MutableCachedNode newCopy = parentInVersionHistory.createChild(versionHistoryCache, key, node.name(), props);
                for (ChildReference childRef : node.node().getChildReferences(nodeCache)) {
                    AbstractJcrNode child = this.session.node(childRef.getKey(), null);
                    this.versionNodeAt(child, newCopy, forceCopy, nodeCache, versionHistoryCache);
                }
                return;
            }
            case 3: 
            case 4: 
            case 5: {
                return;
            }
        }
        throw new IllegalStateException("Unexpected value: " + onParentVersion);
    }

    private void addVersionedPropertiesFor(AbstractJcrNode node, boolean forceCopy, List<Property> props) throws RepositoryException {
        PropertyIterator iter = node.getProperties();
        while (iter.hasNext()) {
            AbstractJcrProperty property = (AbstractJcrProperty)iter.nextProperty();
            Name name = property.name();
            if (JcrLexicon.PRIMARY_TYPE.equals(name) || JcrLexicon.MIXIN_TYPES.equals(name) || JcrLexicon.UUID.equals(name)) continue;
            Property prop = property.property();
            if (forceCopy) {
                props.add(prop);
                continue;
            }
            JcrPropertyDefinition propDefn = property.propertyDefinition();
            switch (propDefn.getOnParentVersion()) {
                case 6: {
                    I18n msg = JcrI18n.cannotCheckinNodeWithAbortProperty;
                    throw new VersionException(msg.text(new Object[]{property.getName(), node.getName()}));
                }
                case 1: 
                case 2: {
                    props.add(prop);
                    break;
                }
            }
        }
    }

    public void checkout(String absPath) throws LockException, RepositoryException {
        this.checkout(this.session.getNode(absPath));
    }

    void checkout(AbstractJcrNode node) throws LockException, RepositoryException {
        this.checkVersionable(node);
        if (node.isLocked() && !node.holdsLock()) {
            throw new LockException(JcrI18n.lockTokenNotHeld.text(new Object[]{node.getPath()}));
        }
        if (!node.hasProperty(JcrLexicon.BASE_VERSION)) {
            return;
        }
        if (node.getProperty(JcrLexicon.IS_CHECKED_OUT).getBoolean()) {
            return;
        }
        SessionCache versionSession = this.session.spawnSessionCache(false);
        MutableCachedNode versionable = versionSession.mutable(node.key());
        NodeKey baseVersionKey = node.getBaseVersion().key();
        PropertyFactory props = this.propertyFactory();
        Reference baseVersionRef = this.session.referenceFactory().create(baseVersionKey, true);
        versionable.setProperty(versionSession, props.create(JcrLexicon.PREDECESSORS, new Object[]{baseVersionRef}));
        versionable.setProperty(versionSession, props.create(JcrLexicon.IS_CHECKED_OUT, Boolean.TRUE));
        versionSession.save();
    }

    public Version checkpoint(String absPath) throws VersionException, UnsupportedRepositoryOperationException, InvalidItemStateException, LockException, RepositoryException {
        Version version = this.checkin(absPath);
        this.checkout(absPath);
        return version;
    }

    public void restore(Version[] versions, boolean removeExisting) throws ItemExistsException, UnsupportedRepositoryOperationException, VersionException, LockException, InvalidItemStateException, RepositoryException {
        this.validateSessionLiveWithoutPendingChanges();
        JcrSession restoreSession = this.session.spawnSession(false);
        HashMap<JcrVersionNode, AbstractJcrNode> existingVersions = new HashMap<JcrVersionNode, AbstractJcrNode>(versions.length);
        HashSet<Path> versionRootPaths = new HashSet<Path>(versions.length);
        ArrayList<Version> nonExistingVersions = new ArrayList<Version>(versions.length);
        for (int i = 0; i < versions.length; ++i) {
            VersionHistory history = versions[i].getContainingHistory();
            if (history.getRootVersion().isSame((Item)versions[i])) {
                throw new VersionException(JcrI18n.cannotRestoreRootVersion.text(new Object[]{versions[i].getPath()}));
            }
            try {
                AbstractJcrNode existingNode = restoreSession.getNodeByIdentifier(history.getVersionableIdentifier());
                existingVersions.put((JcrVersionNode)versions[i], existingNode);
                versionRootPaths.add(existingNode.path());
                continue;
            }
            catch (ItemNotFoundException infe) {
                nonExistingVersions.add(versions[i]);
            }
        }
        if (existingVersions.isEmpty()) {
            throw new VersionException(JcrI18n.noExistingVersionForRestore.text(new Object[0]));
        }
        RestoreCommand op = new RestoreCommand(restoreSession, existingVersions, versionRootPaths, nonExistingVersions, null, removeExisting);
        op.execute();
        restoreSession.save();
    }

    public void restore(String absPath, String versionName, boolean removeExisting) throws VersionException, ItemExistsException, UnsupportedRepositoryOperationException, LockException, InvalidItemStateException, RepositoryException {
        this.validateSessionLiveWithoutPendingChanges();
        JcrSession restoreSession = this.session.spawnSession(false);
        Version version = null;
        Path path = restoreSession.absolutePathFor(absPath);
        AbstractJcrNode existingNode = restoreSession.node(path);
        JcrVersionHistoryNode historyNode = existingNode.getVersionHistory();
        version = historyNode.getVersion(versionName);
        assert (version != null);
        this.restore(restoreSession, path, version, null, removeExisting);
    }

    private void validateSessionLiveWithoutPendingChanges() throws RepositoryException {
        this.session.checkLive();
        if (this.session.hasPendingChanges()) {
            throw new InvalidItemStateException(JcrI18n.noPendingChangesAllowed.text(new Object[0]));
        }
    }

    public void restore(Version version, boolean removeExisting) throws VersionException, ItemExistsException, InvalidItemStateException, UnsupportedRepositoryOperationException, LockException, RepositoryException {
        this.validateSessionLiveWithoutPendingChanges();
        JcrSession restoreSession = this.session.spawnSession(false);
        AbstractJcrNode node = restoreSession.getNodeByIdentifier(version.getContainingHistory().getVersionableIdentifier());
        Path path = node.path();
        this.restore(restoreSession, path, version, null, removeExisting);
    }

    public void restore(String absPath, Version version, boolean removeExisting) throws PathNotFoundException, ItemExistsException, VersionException, ConstraintViolationException, UnsupportedRepositoryOperationException, LockException, InvalidItemStateException, RepositoryException {
        this.restoreAtAbsPath(absPath, version, removeExisting, true);
    }

    protected void restoreAtAbsPath(String absPath, Version version, boolean removeExisting, boolean failIfNodeAlreadyExists) throws RepositoryException {
        this.validateSessionLiveWithoutPendingChanges();
        JcrSession restoreSession = this.session.spawnSession(false);
        Path path = restoreSession.absolutePathFor(absPath);
        if (failIfNodeAlreadyExists) {
            try {
                AbstractJcrNode existingNode = restoreSession.node(path);
                throw new VersionException(JcrI18n.unableToRestoreAtAbsPathNodeAlreadyExists.text(new Object[]{absPath, existingNode.key()}));
            }
            catch (PathNotFoundException e) {
                // empty catch block
            }
        }
        this.restore(restoreSession, path, version, null, removeExisting);
    }

    public void restoreByLabel(String absPath, String versionLabel, boolean removeExisting) throws VersionException, ItemExistsException, UnsupportedRepositoryOperationException, LockException, InvalidItemStateException, RepositoryException {
        this.validateSessionLiveWithoutPendingChanges();
        JcrSession restoreSession = this.session.spawnSession(false);
        restoreSession.getNode(absPath).restoreByLabel(versionLabel, removeExisting);
    }

    public NodeIterator merge(String absPath, String srcWorkspace, boolean bestEffort) throws NoSuchWorkspaceException, AccessDeniedException, MergeException, LockException, InvalidItemStateException, RepositoryException {
        return this.merge(absPath, srcWorkspace, bestEffort, false);
    }

    public NodeIterator merge(String absPath, String srcWorkspace, boolean bestEffort, boolean isShallow) throws NoSuchWorkspaceException, AccessDeniedException, MergeException, LockException, InvalidItemStateException, RepositoryException {
        CheckArg.isNotNull((Object)srcWorkspace, (String)"source workspace name");
        JcrSession mergeSession = this.session.spawnSession(false);
        AbstractJcrNode node = mergeSession.getNode(absPath);
        return this.merge(node, srcWorkspace, bestEffort, isShallow);
    }

    public void doneMerge(String absPath, Version version) throws VersionException, InvalidItemStateException, UnsupportedRepositoryOperationException, RepositoryException {
        JcrSession mergeSession = this.session.spawnSession(false);
        this.doneMerge(mergeSession.getNode(absPath), version);
    }

    public void cancelMerge(String absPath, Version version) throws VersionException, InvalidItemStateException, UnsupportedRepositoryOperationException, RepositoryException {
        JcrSession cancelSession = this.session.spawnSession(false);
        this.cancelMerge(cancelSession.getNode(absPath), version);
    }

    void restore(JcrSession session, Path path, Version version, String labelToRestore, boolean removeExisting) throws RepositoryException {
        AbstractJcrNode nodeToCheckLock;
        AbstractJcrNode parentNode = session.node(path.getParent());
        AbstractJcrNode existingNode = null;
        JcrVersionNode jcrVersion = (JcrVersionNode)version;
        SessionCache cache = session.cache();
        PropertyFactory propFactory = session.propertyFactory();
        try {
            nodeToCheckLock = existingNode = parentNode.childNode(path.getLastSegment(), null);
            JcrVersionHistoryNode versionHistory = existingNode.getVersionHistory();
            if (!versionHistory.isSame(jcrVersion.getParent())) {
                throw new VersionException(JcrI18n.invalidVersion.text(new Object[]{version.getPath(), versionHistory.getPath()}));
            }
            if (!versionHistory.isSame(existingNode.getVersionHistory())) {
                throw new VersionException(JcrI18n.invalidVersion.text(new Object[]{version.getPath(), existingNode.getVersionHistory().getPath()}));
            }
            if (jcrVersion.isSame(versionHistory.getRootVersion())) {
                throw new VersionException(JcrI18n.cannotRestoreRootVersion.text(new Object[]{existingNode.getPath()}));
            }
        }
        catch (PathNotFoundException pnfe) {
            if (!parentNode.isCheckedOut()) {
                String parentPath = path.getString(session.context().getNamespaceRegistry());
                throw new VersionException(JcrI18n.nodeIsCheckedIn.text(new Object[]{parentPath}));
            }
            AbstractJcrNode sourceNode = session.workspace().getVersionManager().frozenNodeFor(version);
            Name primaryTypeName = (Name)session.nameFactory().create(sourceNode.getProperty(JcrLexicon.FROZEN_PRIMARY_TYPE).property().getFirstValue());
            AbstractJcrProperty uuidProp = sourceNode.getProperty(JcrLexicon.FROZEN_UUID);
            String frozenUuidString = session.stringFactory().create(uuidProp.property().getFirstValue());
            NodeKey desiredKey = parentNode.key().withId(frozenUuidString);
            Property primaryType = propFactory.create(JcrLexicon.PRIMARY_TYPE, primaryTypeName);
            MutableCachedNode newChild = parentNode.mutable().createChild(cache, desiredKey, path.getLastSegment().getName(), primaryType, new Property[0]);
            existingNode = session.node((CachedNode)newChild, (AbstractJcrNode.Type)null);
            nodeToCheckLock = parentNode;
        }
        if (nodeToCheckLock.isLocked() && !nodeToCheckLock.holdsLock()) {
            throw new LockException(JcrI18n.lockTokenNotHeld.text(new Object[]{nodeToCheckLock.getPath()}));
        }
        RestoreCommand op = new RestoreCommand(session, Collections.singletonMap(jcrVersion, existingNode), Collections.singleton(existingNode.path()), Collections.<Version>emptySet(), labelToRestore, removeExisting);
        op.execute();
        this.clearCheckoutStatus(existingNode.mutable(), jcrVersion.key(), cache, this.propertyFactory());
        ReferenceFactory refFactory = session.referenceFactory();
        Reference baseVersionRef = refFactory.create(jcrVersion.key(), true);
        MutableCachedNode mutable = existingNode.mutable();
        mutable.setProperty(cache, propFactory.create(JcrLexicon.IS_CHECKED_OUT, Boolean.FALSE));
        mutable.setProperty(cache, propFactory.create(JcrLexicon.BASE_VERSION, baseVersionRef));
        session.save();
    }

    protected final void clearCheckoutStatus(MutableCachedNode node, NodeKey baseVersion, SessionCache cache, PropertyFactory propFactory) {
        Reference baseVersionRef = (Reference)this.session.referenceFactory().create(baseVersion);
        node.setProperty(cache, propFactory.create(JcrLexicon.IS_CHECKED_OUT, Boolean.FALSE));
        node.setProperty(cache, propFactory.create(JcrLexicon.BASE_VERSION, baseVersionRef));
    }

    AbstractJcrNode frozenNodeFor(Version version) throws RepositoryException {
        return ((AbstractJcrNode)version).getNode(JcrLexicon.FROZEN_NODE);
    }

    NodeIterator merge(AbstractJcrNode targetNode, String srcWorkspace, boolean bestEffort, boolean isShallow) throws RepositoryException {
        targetNode.session().checkLive();
        if (this.session().hasPendingChanges()) {
            throw new InvalidItemStateException(JcrI18n.noPendingChangesAllowed.text(new Object[0]));
        }
        try {
            targetNode.correspondingNodePath(srcWorkspace);
        }
        catch (ItemNotFoundException infe) {
            return JcrEmptyNodeIterator.INSTANCE;
        }
        JcrSession sourceSession = targetNode.session().spawnSession(srcWorkspace, true);
        MergeCommand op = new MergeCommand(targetNode, sourceSession, bestEffort, isShallow);
        op.execute();
        targetNode.session().save();
        return op.getFailures();
    }

    void doneMerge(AbstractJcrNode targetNode, Version version) throws RepositoryException {
        targetNode.session().checkLive();
        this.checkVersionable(targetNode);
        if (targetNode.isNew() || targetNode.isModified()) {
            throw new InvalidItemStateException(JcrI18n.noPendingChangesAllowedForNode.text(new Object[0]));
        }
        if (!targetNode.isNodeType(JcrMixLexicon.VERSIONABLE)) {
            throw new VersionException(JcrI18n.requiresVersionable.text(new Object[0]));
        }
        AbstractJcrProperty prop = targetNode.getProperty(JcrLexicon.PREDECESSORS);
        JcrValue[] values = prop.getValues();
        Value[] newValues = new JcrValue[values.length + 1];
        System.arraycopy(values, 0, newValues, 0, values.length);
        newValues[values.length] = targetNode.valueFrom((Node)version);
        targetNode.setProperty(JcrLexicon.PREDECESSORS, newValues, 9, false);
        this.removeVersionFromMergeFailedProperty(targetNode, version);
        targetNode.session().save();
    }

    void cancelMerge(AbstractJcrNode targetNode, Version version) throws RepositoryException {
        targetNode.session().checkLive();
        this.checkVersionable(targetNode);
        if (targetNode.isNew() || targetNode.isModified()) {
            throw new InvalidItemStateException(JcrI18n.noPendingChangesAllowedForNode.text(new Object[0]));
        }
        if (!targetNode.isNodeType(JcrMixLexicon.VERSIONABLE)) {
            throw new UnsupportedRepositoryOperationException(JcrI18n.requiresVersionable.text(new Object[0]));
        }
        this.removeVersionFromMergeFailedProperty(targetNode, version);
        targetNode.session().save();
    }

    private void removeVersionFromMergeFailedProperty(AbstractJcrNode targetNode, Version version) throws RepositoryException {
        if (!targetNode.hasProperty(JcrLexicon.MERGE_FAILED)) {
            throw new VersionException(JcrI18n.versionNotInMergeFailed.text(new Object[]{version.getName(), targetNode.getPath()}));
        }
        AbstractJcrProperty prop = targetNode.getProperty(JcrLexicon.MERGE_FAILED);
        JcrValue[] values = prop.getValues();
        String uuidString = version.getUUID();
        int matchIndex = -1;
        for (int i = 0; i < values.length; ++i) {
            if (!uuidString.equals(values[i].getString())) continue;
            matchIndex = i;
            break;
        }
        if (matchIndex == -1) {
            throw new VersionException(JcrI18n.versionNotInMergeFailed.text(new Object[]{version.getName(), targetNode.getPath()}));
        }
        if (values.length == 1) {
            prop.remove();
        } else {
            Value[] newValues = new JcrValue[values.length - 2];
            if (matchIndex == 0) {
                System.arraycopy(values, 1, newValues, 0, values.length - 1);
            } else if (matchIndex == values.length - 1) {
                System.arraycopy(values, 0, newValues, 0, values.length - 2);
            } else {
                System.arraycopy(values, 0, newValues, 0, matchIndex);
                System.arraycopy(values, matchIndex + 1, newValues, matchIndex, values.length - matchIndex - 1);
            }
            prop.setValue(newValues);
        }
    }

    public Node createConfiguration(String absPath) throws UnsupportedRepositoryOperationException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public Node setActivity(Node activity) throws UnsupportedRepositoryOperationException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public Node getActivity() throws UnsupportedRepositoryOperationException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public Node createActivity(String title) throws UnsupportedRepositoryOperationException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public void removeActivity(Node activityNode) throws UnsupportedRepositoryOperationException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public NodeIterator merge(Node activityNode) throws RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    @NotThreadSafe
    private class MergeCommand {
        private final Collection<AbstractJcrNode> failures;
        private final AbstractJcrNode targetNode;
        private final boolean bestEffort;
        private final boolean isShallow;
        private final JcrSession sourceSession;
        private final SessionCache cache;
        private final String workspaceName;

        public MergeCommand(AbstractJcrNode targetNode, JcrSession sourceSession, boolean bestEffort, boolean isShallow) {
            this.targetNode = targetNode;
            this.sourceSession = sourceSession;
            this.cache = this.sourceSession.cache();
            this.bestEffort = bestEffort;
            this.isShallow = isShallow;
            this.workspaceName = sourceSession.getWorkspace().getName();
            this.failures = new LinkedList<AbstractJcrNode>();
        }

        final NodeIterator getFailures() {
            return new JcrNodeListIterator(this.failures.iterator(), this.failures.size());
        }

        void execute() throws RepositoryException {
            this.doMerge(this.targetNode);
        }

        private void doMerge(AbstractJcrNode targetNode) throws RepositoryException {
            JcrVersionNode targetVersion;
            AbstractJcrNode sourceNode;
            Path sourcePath = targetNode.correspondingNodePath(this.workspaceName);
            try {
                sourceNode = this.sourceSession.node(sourcePath);
            }
            catch (ItemNotFoundException infe) {
                this.doLeave(targetNode);
                return;
            }
            if (!targetNode.isNodeType(JcrMixLexicon.VERSIONABLE)) {
                this.doUpdate(targetNode, sourceNode);
                return;
            }
            if (!sourceNode.isNodeType(JcrMixLexicon.VERSIONABLE)) {
                this.doLeave(targetNode);
                return;
            }
            JcrVersionNode sourceVersion = sourceNode.getBaseVersion();
            if (sourceVersion.isSuccessorOf(targetVersion = targetNode.getBaseVersion()) && !targetNode.isCheckedOut()) {
                this.doUpdate(targetNode, sourceNode);
                return;
            }
            if (targetVersion.isSuccessorOf(sourceVersion) || targetVersion.key().equals(sourceVersion.key())) {
                this.doLeave(targetNode);
                return;
            }
            this.doFail(targetNode, sourceVersion);
        }

        private void doLeave(AbstractJcrNode targetNode) throws RepositoryException {
            if (!this.isShallow) {
                NodeIterator iter = targetNode.getNodes();
                while (iter.hasNext()) {
                    this.doMerge((AbstractJcrNode)iter.nextNode());
                }
            }
        }

        private void doUpdate(AbstractJcrNode targetNode, AbstractJcrNode sourceNode) throws RepositoryException {
            this.restoreProperties(sourceNode, targetNode);
            LinkedHashMap<String, AbstractJcrNode> sourceNodes = this.childNodeMapFor(sourceNode);
            LinkedHashMap<String, AbstractJcrNode> targetNodes = this.childNodeMapFor(targetNode);
            LinkedHashMap<String, AbstractJcrNode> sourceOnly = new LinkedHashMap<String, AbstractJcrNode>(sourceNodes);
            sourceOnly.keySet().removeAll(targetNodes.keySet());
            for (AbstractJcrNode node : sourceOnly.values()) {
                JcrVersionManager.this.workspace().copy(this.workspaceName, node.getPath(), targetNode.getPath() + "/" + node.getName());
            }
            LinkedHashMap<String, AbstractJcrNode> targetOnly = new LinkedHashMap<String, AbstractJcrNode>(targetNodes);
            targetOnly.keySet().removeAll(targetOnly.keySet());
            for (AbstractJcrNode node : targetOnly.values()) {
                node.remove();
            }
            HashMap<String, AbstractJcrNode> presentInBoth = new HashMap<String, AbstractJcrNode>(targetNodes);
            presentInBoth.keySet().retainAll(sourceNodes.keySet());
            for (AbstractJcrNode node : presentInBoth.values()) {
                if (this.isShallow && node.isNodeType(JcrMixLexicon.VERSIONABLE)) continue;
                this.doMerge(node);
            }
        }

        private LinkedHashMap<String, AbstractJcrNode> childNodeMapFor(AbstractJcrNode node) throws RepositoryException {
            LinkedHashMap<String, AbstractJcrNode> childNodes = new LinkedHashMap<String, AbstractJcrNode>();
            NodeIterator iter = node.getNodes();
            while (iter.hasNext()) {
                AbstractJcrNode child = (AbstractJcrNode)iter.nextNode();
                childNodes.put(child.getName(), child);
            }
            return childNodes;
        }

        private void doFail(AbstractJcrNode targetNode, JcrVersionNode sourceVersion) throws RepositoryException {
            if (!this.bestEffort) {
                throw new MergeException();
            }
            if (targetNode.hasProperty(JcrLexicon.MERGE_FAILED)) {
                JcrValue[] existingValues = targetNode.getProperty(JcrLexicon.MERGE_FAILED).getValues();
                boolean found = false;
                String sourceKeyString = sourceVersion.getIdentifier();
                for (int i = 0; i < existingValues.length; ++i) {
                    if (!sourceKeyString.equals(existingValues[i].getString())) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    Value[] newValues = new JcrValue[existingValues.length + 1];
                    System.arraycopy(existingValues, 0, newValues, 0, existingValues.length);
                    newValues[newValues.length - 1] = targetNode.valueFrom(sourceVersion);
                    targetNode.setProperty(JcrLexicon.MERGE_FAILED, newValues, 9, true, false);
                }
            } else {
                Value[] newValues = new JcrValue[]{targetNode.valueFrom(sourceVersion)};
                targetNode.setProperty(JcrLexicon.MERGE_FAILED, newValues, 9, true, false);
            }
            this.failures.add(targetNode);
            if (!this.isShallow) {
                NodeIterator iter = targetNode.getNodes();
                while (iter.hasNext()) {
                    AbstractJcrNode childNode = (AbstractJcrNode)iter.nextNode();
                    if (!childNode.isNodeType(JcrMixLexicon.VERSIONABLE)) continue;
                    this.doMerge(childNode);
                }
            }
        }

        private void restoreProperties(AbstractJcrNode sourceNode, AbstractJcrNode targetNode) throws RepositoryException {
            HashMap<Name, Property> sourceProperties = new HashMap<Name, Property>();
            Iterator<Property> iter = sourceNode.node().getProperties(this.cache);
            while (iter.hasNext()) {
                Property property = iter.next();
                if (IGNORED_PROP_NAMES_FOR_RESTORE.contains(property.getName())) continue;
                sourceProperties.put(property.getName(), property);
            }
            MutableCachedNode mutable = targetNode.mutable();
            SessionCache mutableCache = targetNode.session().cache();
            PropertyIterator existingPropIter = targetNode.getProperties();
            while (existingPropIter.hasNext()) {
                AbstractJcrProperty jcrProp = (AbstractJcrProperty)existingPropIter.nextProperty();
                Name propName = jcrProp.name();
                Property prop = (Property)sourceProperties.remove(propName);
                if (prop != null) {
                    mutable.setProperty(mutableCache, prop);
                    continue;
                }
                JcrPropertyDefinition propDefn = jcrProp.getDefinition();
                switch (propDefn.getOnParentVersion()) {
                    case 1: 
                    case 2: 
                    case 6: {
                        targetNode.removeProperty(jcrProp);
                        break;
                    }
                }
            }
            for (Property sourceProperty : sourceProperties.values()) {
                mutable.setProperty(mutableCache, sourceProperty);
            }
        }
    }

    @NotThreadSafe
    private class RestoreCommand {
        private final JcrSession session;
        private final SessionCache cache;
        private final PropertyFactory propFactory;
        private Map<JcrVersionNode, AbstractJcrNode> existingVersions;
        private Set<Path> versionRootPaths;
        private Collection<Version> nonExistingVersions;
        private boolean removeExisting;
        private String labelToRestore;
        private Map<AbstractJcrNode, AbstractJcrNode> changedNodes;

        public RestoreCommand(JcrSession session, Map<JcrVersionNode, AbstractJcrNode> existingVersions, Set<Path> versionRootPaths, Collection<Version> nonExistingVersions, String labelToRestore, boolean removeExisting) {
            this.session = session;
            this.cache = session.cache();
            this.propFactory = session.propertyFactory();
            this.existingVersions = existingVersions;
            this.versionRootPaths = versionRootPaths;
            this.nonExistingVersions = nonExistingVersions;
            this.removeExisting = removeExisting;
            this.labelToRestore = labelToRestore;
            this.changedNodes = new HashMap<AbstractJcrNode, AbstractJcrNode>(100);
        }

        final String string(Object value) {
            return this.session.stringFactory().create(value);
        }

        final Name name(Object value) {
            return (Name)this.session.nameFactory().create(value);
        }

        final DateTime date(Calendar value) {
            return (DateTime)this.session.dateFactory().create(value);
        }

        void execute() throws RepositoryException {
            ArrayList<JcrVersionNode> versionsToCheck = new ArrayList<JcrVersionNode>(this.existingVersions.keySet());
            JcrVersionManager versionManager = this.session.workspace().getVersionManager();
            for (JcrVersionNode jcrVersionNode : versionsToCheck) {
                AbstractJcrNode root = this.existingVersions.get(jcrVersionNode);
                if (root == null) continue;
                AbstractJcrNode frozenNode = versionManager.frozenNodeFor(jcrVersionNode);
                MutableCachedNode mutableRoot = root.mutable();
                this.restoreNodeMixins(frozenNode.node(), mutableRoot, this.cache);
                this.restoreNode(frozenNode, root, this.date(jcrVersionNode.getCreated()));
                JcrVersionManager.this.clearCheckoutStatus(mutableRoot, jcrVersionNode.key(), this.cache, this.propFactory);
            }
            if (!this.nonExistingVersions.isEmpty()) {
                StringBuilder versions = new StringBuilder();
                boolean bl = true;
                for (Version version : this.nonExistingVersions) {
                    boolean bl2;
                    if (!bl2) {
                        versions.append(", ");
                    } else {
                        bl2 = false;
                    }
                    versions.append(version.getName());
                }
                throw new VersionException(JcrI18n.unrootedVersionsInRestore.text(new Object[]{versions.toString()}));
            }
            for (Map.Entry entry : this.changedNodes.entrySet()) {
                this.restoreProperties((AbstractJcrNode)entry.getKey(), (AbstractJcrNode)entry.getValue());
            }
        }

        private void restoreNode(AbstractJcrNode sourceNode, AbstractJcrNode targetNode, DateTime checkinTime) throws RepositoryException {
            Object child;
            this.changedNodes.put(sourceNode, targetNode);
            MutableCachedNode target = targetNode.mutable();
            CachedNode source = sourceNode.node();
            HashSet<CachedNode> versionedChildrenThatShouldNotBeRestored = new HashSet<CachedNode>();
            HashMap<NodeKey, CachedNode> presentInBoth = new HashMap<NodeKey, CachedNode>();
            List<NodeKey> inTargetOnly = this.asList(target.getChildReferences(this.cache));
            HashMap<Object, CachedNode> inSourceOnly = new HashMap<Object, CachedNode>();
            for (ChildReference sourceChild : source.getChildReferences(this.cache)) {
                child = this.cache.getNode(sourceChild);
                boolean isVersionedChild = JcrNtLexicon.VERSIONED_CHILD.equals(this.name(child.getPrimaryType(this.cache)));
                CachedNode resolvedNode = this.resolveSourceNode((CachedNode)child, checkinTime, this.cache);
                CachedNode match = this.findMatchFor(resolvedNode, this.cache);
                if (match != null) {
                    if (isVersionedChild) {
                        if (!this.removeExisting) {
                            throw new ItemExistsException(JcrI18n.itemAlreadyExistsWithUuid.text(new Object[]{match.getKey(), this.session.workspace().getName(), match.getPath(this.cache)}));
                        }
                        versionedChildrenThatShouldNotBeRestored.add(match);
                    }
                    inTargetOnly.remove(match.getKey());
                    presentInBoth.put(child.getKey(), match);
                    continue;
                }
                inSourceOnly.put(child, resolvedNode);
            }
            for (NodeKey childKey : inTargetOnly) {
                child = this.session.node(childKey, null);
                switch (((AbstractJcrNode)child).getDefinition().getOnParentVersion()) {
                    case 1: 
                    case 2: 
                    case 6: {
                        target.removeChild(this.cache, childKey);
                        this.cache.destroy(childKey);
                        break;
                    }
                }
            }
            LinkedList<ChildReference> reversedChildren = new LinkedList<ChildReference>();
            for (ChildReference sourceChildRef : source.getChildReferences(this.cache)) {
                reversedChildren.addFirst(sourceChildRef);
            }
            NodeKey prevChildKey = null;
            for (ChildReference sourceChildRef : reversedChildren) {
                AbstractJcrNode targetChildNode;
                AbstractJcrNode sourceChildNode;
                CachedNode sourceChild = this.cache.getNode(sourceChildRef);
                CachedNode targetChild = (CachedNode)presentInBoth.get(sourceChildRef.getKey());
                CachedNode resolvedChild = null;
                Name resolvedPrimaryTypeName = null;
                boolean shouldRestore = !versionedChildrenThatShouldNotBeRestored.contains(targetChild);
                boolean shouldRestoreMixinsAndUuid = false;
                if (targetChild != null) {
                    resolvedChild = this.resolveSourceNode(sourceChild, checkinTime, this.cache);
                    resolvedPrimaryTypeName = this.name(resolvedChild.getPrimaryType(this.cache));
                    sourceChildNode = this.session.node(resolvedChild, (AbstractJcrNode.Type)null);
                    targetChildNode = this.session.node(targetChild, (AbstractJcrNode.Type)null);
                } else {
                    Property idProp;
                    resolvedChild = (CachedNode)inSourceOnly.get(sourceChild);
                    resolvedPrimaryTypeName = this.name(resolvedChild.getPrimaryType(this.cache));
                    sourceChildNode = this.session.node(resolvedChild, (AbstractJcrNode.Type)null);
                    shouldRestoreMixinsAndUuid = true;
                    Name primaryTypeName = null;
                    NodeKey desiredKey = null;
                    Name desiredName = null;
                    if (JcrNtLexicon.FROZEN_NODE.equals(resolvedPrimaryTypeName)) {
                        primaryTypeName = this.name(resolvedChild.getProperty(JcrLexicon.FROZEN_PRIMARY_TYPE, this.cache).getFirstValue());
                        idProp = resolvedChild.getProperty(JcrLexicon.FROZEN_UUID, this.cache);
                        String frozenUuid = this.string(idProp.getFirstValue());
                        desiredKey = target.getKey().withId(frozenUuid);
                        desiredName = this.session.node(sourceChild, (AbstractJcrNode.Type)null).name();
                    } else {
                        primaryTypeName = resolvedChild.getPrimaryType(this.cache);
                        idProp = resolvedChild.getProperty(JcrLexicon.UUID, this.cache);
                        if (idProp == null || idProp.isEmpty()) {
                            desiredKey = target.getKey().withRandomId();
                        } else {
                            String uuid = this.string(idProp.getFirstValue());
                            desiredKey = target.getKey().withId(uuid);
                        }
                        desiredName = sourceChildNode.name();
                    }
                    Property primaryType = this.propFactory.create(JcrLexicon.PRIMARY_TYPE, primaryTypeName);
                    targetChild = target.createChild(this.cache, desiredKey, desiredName, primaryType, new Property[0]);
                    targetChildNode = this.session.node(targetChild, (AbstractJcrNode.Type)null);
                    assert (shouldRestore);
                }
                if (shouldRestore) {
                    AbstractJcrNode parent;
                    MutableCachedNode mutableTarget;
                    MutableCachedNode mutableCachedNode = mutableTarget = targetChild instanceof MutableCachedNode ? (MutableCachedNode)targetChild : this.cache.mutable(targetChild.getKey());
                    if (shouldRestoreMixinsAndUuid) {
                        if (JcrNtLexicon.FROZEN_NODE.equals(resolvedPrimaryTypeName)) {
                            this.restoreNodeMixinsFromProperty(resolvedChild, mutableTarget, this.cache, JcrLexicon.FROZEN_MIXIN_TYPES);
                        } else {
                            this.restoreNodeMixins(sourceChild, mutableTarget, this.cache);
                        }
                    }
                    if ((parent = sourceChildNode.getParent()).isNodeType(JcrNtLexicon.VERSION)) {
                        JcrVersionManager.this.clearCheckoutStatus(mutableTarget, parent.key(), this.cache, this.propFactory);
                    }
                    this.restoreNode(sourceChildNode, targetChildNode, checkinTime);
                }
                if (prevChildKey != null) {
                    target.reorderChild(this.cache, targetChildNode.key(), prevChildKey);
                }
                prevChildKey = targetChildNode.key();
            }
        }

        private void restoreNodeMixins(CachedNode sourceNode, MutableCachedNode targetNode, SessionCache cache) throws RepositoryException {
            this.restoreNodeMixinsFromProperty(sourceNode, targetNode, cache, JcrLexicon.FROZEN_MIXIN_TYPES);
        }

        private void restoreNodeMixinsFromProperty(CachedNode sourceNode, MutableCachedNode targetNode, SessionCache cache, Name sourceNodeMixinTypesPropertyName) {
            Property mixinTypesProp = sourceNode.getProperty(sourceNodeMixinTypesPropertyName, cache);
            if (mixinTypesProp == null || mixinTypesProp.isEmpty()) {
                return;
            }
            Object[] mixinTypeNames = mixinTypesProp.getValuesAsArray();
            HashSet<Name> currentMixinTypes = new HashSet<Name>(targetNode.getMixinTypes(cache));
            for (Object mixinTypeName1 : mixinTypeNames) {
                Name mixinTypeName = this.name(mixinTypeName1);
                if (currentMixinTypes.remove(mixinTypeName)) continue;
                targetNode.addMixin(cache, mixinTypeName);
            }
        }

        private void restoreProperties(AbstractJcrNode sourceNode, AbstractJcrNode targetNode) throws RepositoryException {
            HashMap<Name, Property> sourceProperties = new HashMap<Name, Property>();
            Iterator<Property> iter = sourceNode.node().getProperties(this.cache);
            while (iter.hasNext()) {
                Property property = iter.next();
                if (IGNORED_PROP_NAMES_FOR_RESTORE.contains(property.getName())) continue;
                sourceProperties.put(property.getName(), property);
            }
            MutableCachedNode mutable = targetNode.mutable();
            PropertyIterator existingPropIter = targetNode.getProperties();
            while (existingPropIter.hasNext()) {
                AbstractJcrProperty jcrProp = (AbstractJcrProperty)existingPropIter.nextProperty();
                Name propName = jcrProp.name();
                Property prop = (Property)sourceProperties.remove(propName);
                if (prop != null) {
                    mutable.setProperty(this.cache, prop);
                    continue;
                }
                JcrPropertyDefinition propDefn = jcrProp.getDefinition();
                switch (propDefn.getOnParentVersion()) {
                    case 1: 
                    case 2: 
                    case 6: {
                        targetNode.removeProperty(jcrProp);
                        break;
                    }
                }
            }
            for (Property sourceProperty : sourceProperties.values()) {
                mutable.setProperty(this.cache, sourceProperty);
            }
        }

        private CachedNode resolveSourceNode(CachedNode sourceNode, DateTime checkinTime, NodeCache cache) throws RepositoryException {
            Name sourcePrimaryTypeName = this.name(sourceNode.getPrimaryType(cache));
            if (JcrNtLexicon.FROZEN_NODE.equals(sourcePrimaryTypeName)) {
                return sourceNode;
            }
            if (!JcrNtLexicon.VERSIONED_CHILD.equals(sourcePrimaryTypeName)) {
                return sourceNode;
            }
            Property historyRefProp = sourceNode.getProperty(JcrLexicon.CHILD_VERSION_HISTORY, cache);
            String keyStr = this.string(historyRefProp.getFirstValue());
            assert (keyStr != null);
            for (Version version : this.nonExistingVersions) {
                if (!keyStr.equals(version.getContainingHistory().getIdentifier())) continue;
                JcrVersionNode versionNode = (JcrVersionNode)version;
                this.nonExistingVersions.remove(version);
                return versionNode.getFrozenNode().node();
            }
            for (JcrVersionNode jcrVersionNode : this.existingVersions.keySet()) {
                if (!keyStr.equals(jcrVersionNode.getContainingHistory().getIdentifier())) continue;
                JcrVersionNode versionNode = jcrVersionNode;
                this.existingVersions.remove(jcrVersionNode);
                return versionNode.getFrozenNode().node();
            }
            JcrVersionHistoryNode versionHistory = (JcrVersionHistoryNode)this.session.getNodeByIdentifier(keyStr);
            if (this.labelToRestore != null) {
                try {
                    JcrVersionNode jcrVersionNode = versionHistory.getVersionByLabel(this.labelToRestore);
                    return jcrVersionNode.getFrozenNode().node();
                }
                catch (VersionException versionException) {
                    // empty catch block
                }
            }
            AbstractJcrNode abstractJcrNode = this.closestMatchFor(versionHistory, checkinTime);
            return abstractJcrNode.node();
        }

        private CachedNode findMatchFor(CachedNode sourceNode, NodeCache cache) throws ItemExistsException, RepositoryException {
            Property idProp = sourceNode.getProperty(JcrLexicon.FROZEN_UUID, cache);
            if (idProp == null) {
                return null;
            }
            String idStr = this.string(idProp.getFirstValue());
            try {
                AbstractJcrNode match = this.session.getNodeByIdentifier(idStr);
                if (this.nodeIsOutsideRestoredForest(match)) {
                    return null;
                }
                return match.node();
            }
            catch (ItemNotFoundException infe) {
                return null;
            }
        }

        private List<NodeKey> asList(ChildReferences references) {
            assert (references.size() < Integer.MAX_VALUE);
            ArrayList<NodeKey> newList = new ArrayList<NodeKey>((int)references.size());
            for (ChildReference ref : references) {
                newList.add(ref.getKey());
            }
            return newList;
        }

        private boolean nodeIsOutsideRestoredForest(AbstractJcrNode node) throws ItemExistsException, RepositoryException {
            Path nodePath = node.path();
            for (Path rootPath : this.versionRootPaths) {
                if (!nodePath.isAtOrBelow(rootPath)) continue;
                return false;
            }
            if (!this.removeExisting) {
                throw new ItemExistsException(JcrI18n.itemAlreadyExistsWithUuid.text(new Object[]{node.key(), this.session.workspace().getName(), node.getPath()}));
            }
            node.remove();
            return true;
        }

        private AbstractJcrNode closestMatchFor(JcrVersionHistoryNode versionHistory, DateTime checkinTime) throws RepositoryException {
            DateTimeFactory dateFactory = this.session.context().getValueFactories().getDateFactory();
            VersionIterator iter = versionHistory.getAllVersions();
            HashMap versions = new HashMap((int)iter.getSize());
            while (iter.hasNext()) {
                Version version = iter.nextVersion();
                versions.put(dateFactory.create(version.getCreated()), version);
            }
            ArrayList versionDates = new ArrayList(versions.keySet());
            Collections.sort(versionDates);
            for (int i = versionDates.size() - 1; i >= 0; --i) {
                if (!((DateTime)versionDates.get(i)).isBefore(checkinTime)) continue;
                Version version = (Version)versions.get(versionDates.get(i));
                return ((JcrVersionNode)version).getFrozenNode();
            }
            throw new IllegalStateException("First checkin must be before the checkin time of the node to be restored");
        }
    }

    protected static class FlatPathAlgorithm
    extends BasePathAlgorithm {
        protected FlatPathAlgorithm(Path versionStoragePath, ExecutionContext context) {
            super(versionStoragePath, context);
        }

        @Override
        public Path versionHistoryPathFor(String sha1OrUuid) {
            return this.paths.createAbsolutePath(JcrLexicon.SYSTEM, JcrLexicon.VERSION_STORAGE, (Name)this.names.create(sha1OrUuid));
        }
    }

    protected static class HiearchicalPathAlgorithm
    extends BasePathAlgorithm {
        protected HiearchicalPathAlgorithm(Path versionStoragePath, ExecutionContext context) {
            super(versionStoragePath, context);
        }

        @Override
        public Path versionHistoryPathFor(String sha1OrUuid) {
            Name p1 = (Name)this.names.create(sha1OrUuid.substring(0, 2));
            Name p2 = (Name)this.names.create(sha1OrUuid.substring(2, 4));
            Name p3 = (Name)this.names.create(sha1OrUuid.substring(4, 6));
            Name p4 = (Name)this.names.create(sha1OrUuid);
            return this.paths.createAbsolutePath(JcrLexicon.SYSTEM, JcrLexicon.VERSION_STORAGE, p1, p2, p3, p4);
        }
    }

    protected static abstract class BasePathAlgorithm
    implements PathAlgorithm {
        protected final PathFactory paths;
        protected final NameFactory names;
        protected final Path versionStoragePath;

        protected BasePathAlgorithm(Path versionStoragePath, ExecutionContext context) {
            this.paths = context.getValueFactories().getPathFactory();
            this.names = context.getValueFactories().getNameFactory();
            this.versionStoragePath = versionStoragePath;
        }
    }

    protected static interface PathAlgorithm {
        public Path versionHistoryPathFor(String var1);
    }
}

