/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.spi;

import java.security.acl.Group;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.jboss.security.auth.spi.UsernamePasswordLoginModule;
import org.jboss.security.auth.spi.Users;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLLoginModule
extends UsernamePasswordLoginModule {
    private Users users;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        try {
            this.users = (Users)options.get("userInfo");
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to load users/passwords/role files", (Throwable)e);
        }
    }

    @Override
    public boolean login() throws LoginException {
        if (this.users == null) {
            throw new LoginException("PB00015: Null Value:Missing usersInfo user/role mapping");
        }
        return super.login();
    }

    @Override
    protected Group[] getRoleSets() throws LoginException {
        String targetUser = this.getUsername();
        Users.User user = this.users.getUser(targetUser);
        Group[] roleSets = new Group[]{};
        if (user != null) {
            roleSets = user.getRoleSets();
        }
        return roleSets;
    }

    @Override
    protected String getUsersPassword() {
        String username = this.getUsername();
        Users.User user = this.users.getUser(username);
        String password = null;
        if (user != null) {
            password = user.getPassword();
        }
        return password;
    }
}

