/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.model;

import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.query.model.DynamicOperand;
import org.modeshape.jcr.query.model.LanguageObject;
import org.modeshape.jcr.query.model.Order;
import org.modeshape.jcr.query.model.Visitor;
import org.modeshape.jcr.query.model.Visitors;

@Immutable
public class Ordering
implements LanguageObject,
javax.jcr.query.qom.Ordering {
    private static final long serialVersionUID = 1L;
    private final DynamicOperand operand;
    private final Order order;

    public Ordering(DynamicOperand operand, Order order) {
        CheckArg.isNotNull((Object)operand, (String)"operand");
        CheckArg.isNotNull((Object)order, (String)"order");
        this.operand = operand;
        this.order = order;
    }

    public DynamicOperand getOperand() {
        return this.operand;
    }

    public Order order() {
        return this.order;
    }

    public String getOrder() {
        switch (this.order()) {
            case ASCENDING: {
                return "jcr.order.ascending";
            }
            case DESCENDING: {
                return "jcr.order.descending";
            }
        }
        assert (false);
        return null;
    }

    public String toString() {
        return Visitors.readable(this);
    }

    public int hashCode() {
        return this.operand.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Ordering) {
            Ordering that = (Ordering)obj;
            if (this.order != that.order) {
                return false;
            }
            return this.operand.equals(that.operand);
        }
        return false;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

