/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic.internal.delta;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.marshall.SerializeWith;
import org.infinispan.schematic.document.Path;
import org.infinispan.schematic.internal.SchematicExternalizer;
import org.infinispan.schematic.internal.delta.ArrayOperation;
import org.infinispan.schematic.internal.document.MutableArray;
import org.infinispan.schematic.internal.document.MutableDocument;
import org.infinispan.util.Util;

@SerializeWith(value=Externalizer.class)
public class RemoveValueOperation
extends ArrayOperation {
    protected final Object value;
    protected transient int actualIndex = -1;

    public RemoveValueOperation(Path parentPath, Object value) {
        super(parentPath);
        this.value = value;
    }

    @Override
    public RemoveValueOperation clone() {
        return new RemoveValueOperation(this.getParentPath(), this.cloneValue(this.value));
    }

    @Override
    public void rollback(MutableDocument delegate) {
        if (this.actualIndex > -1) {
            MutableArray array = this.mutableParent(delegate);
            array.add(this.actualIndex, this.value);
        }
    }

    public Object getRemovedValue() {
        return this.value;
    }

    public int getActualIndex() {
        return this.actualIndex;
    }

    @Override
    public void replay(MutableDocument delegate) {
        MutableArray array = this.mutableParent(delegate);
        this.actualIndex = array.indexOf(this.value);
        array.remove(this.actualIndex);
    }

    public String toString() {
        return "Remove at '" + this.parentPath + "' the value '" + this.value + "'";
    }

    public static final class Externalizer
    extends SchematicExternalizer<RemoveValueOperation> {
        private static final long serialVersionUID = 1L;

        public void writeObject(ObjectOutput output, RemoveValueOperation put) throws IOException {
            output.writeObject(put.parentPath);
            output.writeObject(put.value);
        }

        public RemoveValueOperation readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            Path path = (Path)input.readObject();
            Object value = input.readObject();
            return new RemoveValueOperation(path, value);
        }

        @Override
        public Integer getId() {
            return 1609;
        }

        @Override
        public Set<Class<? extends RemoveValueOperation>> getTypeClasses() {
            return Util.asSet((Object[])new Class[]{RemoveValueOperation.class});
        }
    }
}

