/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.security.SecureRandom;
import org.jgroups.util.UUID;
import org.jgroups.util.Util;

public class PayloadUUID
extends UUID {
    private static final long serialVersionUID = -7920418038143502913L;
    protected String payload;

    public PayloadUUID() {
    }

    protected PayloadUUID(byte[] data, String payload) {
        super(data);
        this.payload = payload;
    }

    public static PayloadUUID randomUUID(String payload) {
        return new PayloadUUID(PayloadUUID.generateRandomBytes(), payload);
    }

    public static PayloadUUID randomUUID(String logical_name, String payload) {
        PayloadUUID retval = new PayloadUUID(PayloadUUID.generateRandomBytes(), payload);
        UUID.add(retval, logical_name);
        return retval;
    }

    public String getPayload() {
        return this.payload;
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }

    protected static byte[] generateRandomBytes() {
        SecureRandom ng = numberGenerator;
        if (ng == null) {
            numberGenerator = ng = new SecureRandom();
        }
        byte[] randomBytes = new byte[16];
        ng.nextBytes(randomBytes);
        return randomBytes;
    }

    @Override
    public int size() {
        int retval = super.size() + 1;
        if (this.payload != null) {
            retval += this.payload.length() + 2;
        }
        return retval;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        try {
            this.payload = Util.readString(in);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        try {
            Util.writeString(this.payload, out);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public void writeTo(DataOutput out) throws Exception {
        super.writeTo(out);
        Util.writeString(this.payload, out);
    }

    @Override
    public void readFrom(DataInput in) throws Exception {
        super.readFrom(in);
        this.payload = Util.readString(in);
    }

    @Override
    public String toString() {
        if (print_uuids) {
            return this.toStringLong() + (this.payload == null ? "" : "(" + this.payload + ")");
        }
        return super.toString() + (this.payload == null ? "" : "(" + this.payload + ")");
    }
}

