/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries.versioned;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.container.entries.MortalCacheEntry;
import org.infinispan.container.entries.versioned.Versioned;
import org.infinispan.container.entries.versioned.VersionedMortalCacheValue;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.io.UnsignedNumeric;
import org.infinispan.marshall.AbstractExternalizer;
import org.infinispan.util.Util;

public class VersionedMortalCacheEntry
extends MortalCacheEntry
implements Versioned {
    public VersionedMortalCacheEntry(Object key, Object value, EntryVersion version, long lifespan, long created) {
        super(key, new VersionedMortalCacheValue(value, version, created, lifespan));
    }

    public VersionedMortalCacheEntry(Object key, Object value, EntryVersion version, long lifespan) {
        this(key, value, version, lifespan, System.currentTimeMillis());
    }

    VersionedMortalCacheEntry(Object key, VersionedMortalCacheValue cacheValue) {
        super(key, cacheValue);
    }

    @Override
    public EntryVersion getVersion() {
        return ((Versioned)((Object)this.cacheValue)).getVersion();
    }

    @Override
    public void setVersion(EntryVersion version) {
        ((Versioned)((Object)this.cacheValue)).setVersion(version);
    }

    public static class Externalizer
    extends AbstractExternalizer<VersionedMortalCacheEntry> {
        @Override
        public void writeObject(ObjectOutput output, VersionedMortalCacheEntry ice) throws IOException {
            output.writeObject(ice.key);
            output.writeObject(((VersionedMortalCacheEntry)ice).cacheValue.value);
            output.writeObject(((Versioned)((Object)ice.cacheValue)).getVersion());
            UnsignedNumeric.writeUnsignedLong(output, ice.cacheValue.getCreated());
            output.writeLong(ice.cacheValue.getLifespan());
        }

        @Override
        public VersionedMortalCacheEntry readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            Object k = input.readObject();
            Object v = input.readObject();
            EntryVersion version = (EntryVersion)input.readObject();
            long created = UnsignedNumeric.readUnsignedLong(input);
            Long lifespan = input.readLong();
            return new VersionedMortalCacheEntry(k, v, version, created, lifespan);
        }

        @Override
        public Integer getId() {
            return 77;
        }

        @Override
        public Set<Class<? extends VersionedMortalCacheEntry>> getTypeClasses() {
            return Util.asSet(VersionedMortalCacheEntry.class);
        }
    }
}

