/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.value.basic;

import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URI;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.text.TextDecoder;
import org.modeshape.jcr.GraphI18n;
import org.modeshape.jcr.api.value.DateTime;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.value.BinaryValue;
import org.modeshape.jcr.value.IoException;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.PropertyType;
import org.modeshape.jcr.value.Reference;
import org.modeshape.jcr.value.ReferenceFactory;
import org.modeshape.jcr.value.ValueFactories;
import org.modeshape.jcr.value.ValueFormatException;
import org.modeshape.jcr.value.basic.AbstractValueFactory;
import org.modeshape.jcr.value.basic.NodeKeyReference;
import org.modeshape.jcr.value.basic.StringReference;
import org.modeshape.jcr.value.basic.UuidReference;

@Immutable
public class ReferenceValueFactory
extends AbstractValueFactory<Reference>
implements ReferenceFactory {
    protected final boolean weak;
    protected final boolean simple;

    public static ReferenceValueFactory newInstance(TextDecoder decoder, ValueFactories factories, boolean weak, boolean simple) {
        if (simple) {
            return new ReferenceValueFactory(PropertyType.SIMPLEREFERENCE, decoder, factories, weak, simple);
        }
        return new ReferenceValueFactory(weak ? PropertyType.WEAKREFERENCE : PropertyType.REFERENCE, decoder, factories, weak, simple);
    }

    protected ReferenceValueFactory(PropertyType type, TextDecoder decoder, ValueFactories valueFactories, boolean weak, boolean simple) {
        super(type, decoder, valueFactories);
        this.weak = weak;
        this.simple = simple;
    }

    @Override
    public ReferenceFactory with(ValueFactories valueFactories) {
        return this.valueFactories == valueFactories ? this : new ReferenceValueFactory(super.getPropertyType(), super.getDecoder(), valueFactories, this.weak, this.simple);
    }

    @Override
    public Reference create(String value) {
        if (value == null) {
            return null;
        }
        if (NodeKey.isValidFormat(value)) {
            return new NodeKeyReference(new NodeKey(value), this.weak, false, this.simple);
        }
        if (this.simple) {
            throw new ValueFormatException(value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), String.class.getSimpleName(), value}));
        }
        try {
            UUID uuid = UUID.fromString(value);
            return new UuidReference(uuid, this.weak);
        }
        catch (IllegalArgumentException err) {
            return new StringReference(value, this.weak);
        }
    }

    @Override
    public Reference create(String value, TextDecoder decoder) {
        return this.create(this.getDecoder(decoder).decode(value));
    }

    @Override
    public Reference create(int value) {
        throw new ValueFormatException(value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Integer.class.getSimpleName(), value}));
    }

    @Override
    public Reference create(long value) {
        throw new ValueFormatException(value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Long.class.getSimpleName(), value}));
    }

    @Override
    public Reference create(boolean value) {
        throw new ValueFormatException(value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Boolean.class.getSimpleName(), value}));
    }

    @Override
    public Reference create(float value) {
        throw new ValueFormatException(Float.valueOf(value), this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Float.class.getSimpleName(), Float.valueOf(value)}));
    }

    @Override
    public Reference create(double value) {
        throw new ValueFormatException(value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Double.class.getSimpleName(), value}));
    }

    @Override
    public Reference create(BigDecimal value) {
        throw new ValueFormatException(value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), BigDecimal.class.getSimpleName(), value}));
    }

    @Override
    public Reference create(Calendar value) {
        throw new ValueFormatException(value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Calendar.class.getSimpleName(), value}));
    }

    @Override
    public Reference create(Date value) {
        throw new ValueFormatException(value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Date.class.getSimpleName(), value}));
    }

    @Override
    public Reference create(DateTime value) throws ValueFormatException {
        throw new ValueFormatException(value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), DateTime.class.getSimpleName(), value}));
    }

    @Override
    public Reference create(Name value) {
        throw new ValueFormatException(value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Name.class.getSimpleName(), value}));
    }

    @Override
    public Reference create(Path value) {
        throw new ValueFormatException(value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Path.class.getSimpleName(), value}));
    }

    @Override
    public Reference create(Path.Segment value) {
        throw new ValueFormatException(value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Path.Segment.class.getSimpleName(), value}));
    }

    @Override
    public Reference create(Reference value) {
        return value;
    }

    @Override
    public Reference create(UUID value) {
        if (value == null) {
            return null;
        }
        if (this.simple) {
            throw new ValueFormatException(value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), UUID.class.getSimpleName(), value}));
        }
        return new UuidReference(value, this.weak);
    }

    @Override
    public Reference create(NodeKey value) throws ValueFormatException {
        return new NodeKeyReference(value, this.weak, false, this.simple);
    }

    @Override
    public Reference create(NodeKey value, boolean foreign) throws ValueFormatException {
        return new NodeKeyReference(value, this.weak, foreign, this.simple);
    }

    @Override
    public Reference[] create(NodeKey[] values, boolean foreign) throws ValueFormatException {
        if (values == null) {
            return null;
        }
        int length = values.length;
        Reference[] result = this.createEmptyArray(length);
        for (int i = 0; i != length; ++i) {
            result[i] = this.create(values[i], foreign);
        }
        return result;
    }

    @Override
    public Reference create(URI value) {
        throw new ValueFormatException(value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Date.class.getSimpleName(), value}));
    }

    @Override
    public Reference create(byte[] value) {
        return this.create(this.getStringValueFactory().create(value));
    }

    @Override
    public Reference create(BinaryValue value) throws ValueFormatException, IoException {
        return this.create(this.getStringValueFactory().create(value));
    }

    @Override
    public Reference create(InputStream stream) throws IoException {
        return this.create(this.getStringValueFactory().create(stream));
    }

    public Reference[] createEmptyArray(int length) {
        return new Reference[length];
    }
}

