/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.context;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.InfinispanCollections;

public final class SingleKeyNonTxInvocationContext
implements InvocationContext {
    private boolean isLocked;
    private final boolean isOriginLocal;
    private Object key;
    private CacheEntry cacheEntry;
    private ClassLoader classLoader;
    private Address origin;

    public SingleKeyNonTxInvocationContext(boolean originLocal) {
        this.isOriginLocal = originLocal;
    }

    @Override
    public boolean isOriginLocal() {
        return this.isOriginLocal;
    }

    @Override
    public boolean isInTxScope() {
        return false;
    }

    @Override
    public Object getLockOwner() {
        return Thread.currentThread();
    }

    @Override
    public Set<Object> getLockedKeys() {
        return this.isLocked && this.key != null ? Collections.singleton(this.key) : InfinispanCollections.emptySet();
    }

    @Override
    public void clearLockedKeys() {
        this.key = null;
        this.cacheEntry = null;
        this.isLocked = false;
    }

    @Override
    public void addLockedKey(Object key) {
        if (this.cacheEntry != null && !key.equals(this.key)) {
            throw this.illegalStateException();
        }
        this.isLocked = true;
    }

    private IllegalStateException illegalStateException() {
        return new IllegalStateException("This is a single key invocation context, using multiple keys shouldn't be possible");
    }

    @Override
    public CacheEntry lookupEntry(Object key) {
        if (key != null && this.key != null && key.equals(this.key)) {
            return this.cacheEntry;
        }
        return null;
    }

    @Override
    public Map<Object, CacheEntry> getLookedUpEntries() {
        return this.key == null ? InfinispanCollections.emptyMap() : Collections.singletonMap(this.key, this.cacheEntry);
    }

    @Override
    public void putLookedUpEntry(Object key, CacheEntry e) {
        this.key = key;
        this.cacheEntry = e;
    }

    @Override
    public void removeLookedUpEntry(Object key) {
        if (key.equals(this.key)) {
            this.clearLockedKeys();
        }
    }

    public Object getKey() {
        return this.key;
    }

    public CacheEntry getCacheEntry() {
        return this.cacheEntry;
    }

    @Override
    public Address getOrigin() {
        return this.origin;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public boolean hasLockedKey(Object key) {
        return this.isLocked && key.equals(this.key);
    }

    @Override
    public boolean replaceValue(Object key, Object value) {
        CacheEntry ce = this.lookupEntry(key);
        if (ce == null || ce.isNull() || ce.isLockPlaceholder() || ce.getValue() == null) {
            if (ce != null && ce.isChanged()) {
                ce.setValue(value);
            } else {
                return false;
            }
        }
        return true;
    }

    @Override
    public SingleKeyNonTxInvocationContext clone() {
        try {
            return (SingleKeyNonTxInvocationContext)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Impossible!");
        }
    }
}

