/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.InvalidNodeTypeDefinitionException;
import javax.jcr.nodetype.NodeTypeDefinition;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.collection.HashMultimap;
import org.modeshape.common.collection.Multimap;
import org.modeshape.common.i18n.I18n;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrItemDefinition;
import org.modeshape.jcr.JcrMixLexicon;
import org.modeshape.jcr.JcrNodeDefinition;
import org.modeshape.jcr.JcrNodeType;
import org.modeshape.jcr.JcrNtLexicon;
import org.modeshape.jcr.JcrPropertyDefinition;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.JcrValue;
import org.modeshape.jcr.NodeDefinitionId;
import org.modeshape.jcr.PropertyDefinitionId;
import org.modeshape.jcr.api.PropertyType;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.NameFactory;

@Immutable
public class NodeTypes {
    private final Map<Name, JcrNodeType> nodeTypes = new HashMap<Name, JcrNodeType>();
    private final Map<PropertyDefinitionId, JcrPropertyDefinition> propertyDefinitions = new HashMap<PropertyDefinitionId, JcrPropertyDefinition>();
    private final Map<NodeDefinitionId, JcrNodeDefinition> childNodeDefinitions = new HashMap<NodeDefinitionId, JcrNodeDefinition>();
    private final Collection<JcrNodeType> unmodifiableNodeTypes;
    private final Collection<JcrNodeType> unmodifiableMixinNodeTypes;
    private final Collection<JcrNodeType> unmodifiablePrimaryNodeTypes;
    private final Set<Name> unmodifiableNodeTypeNames;
    private final Set<Name> unmodifiableMixinTypeNames;
    private final int nodeTypesVersion;
    private final JcrNodeDefinition ntUnstructuredSnsChildDefinition;
    private final JcrNodeDefinition ntUnstructuredSingleChildDefinition;
    private final ExecutionContext context;
    private final NameFactory nameFactory;
    private static final Set<Name> fullyDefinedNodeTypes = new HashSet<Name>();
    private final Set<Name> createdNodeTypeNames = new HashSet<Name>();
    private final Set<Name> lastModifiedNodeTypeNames = new HashSet<Name>();
    private final Set<Name> resourceNodeTypeNames = new HashSet<Name>();
    private final Set<Name> etagNodeTypeNames = new HashSet<Name>();
    private final Set<Name> versionableNodeTypeNames = new HashSet<Name>();
    private final Set<Name> nodeTypeNamesThatAllowSameNameSiblings = new HashSet<Name>();
    private final Set<Name> nodeTypeNamesThatAreReferenceable = new HashSet<Name>();
    private final Multimap<Name, JcrPropertyDefinition> mandatoryPropertiesNodeTypes = HashMultimap.create();
    private final Multimap<Name, JcrNodeDefinition> mandatoryChildrenNodeTypes = HashMultimap.create();
    private final Multimap<Name, JcrPropertyDefinition> autoCreatedPropertiesNodeTypes = HashMultimap.create();
    private final Multimap<Name, JcrNodeDefinition> autoCreatedChildrenNodeTypes = HashMultimap.create();

    protected NodeTypes(ExecutionContext context) {
        this(context, null, 0);
    }

    protected NodeTypes(ExecutionContext context, Iterable<JcrNodeType> nodeTypes, int version) {
        this.nodeTypesVersion = version;
        this.context = context;
        this.nameFactory = context.getValueFactories().getNameFactory();
        HashSet<Name> mixinNames = new HashSet<Name>();
        ArrayList<JcrNodeType> mixins = new ArrayList<JcrNodeType>();
        ArrayList<JcrNodeType> primaries = new ArrayList<JcrNodeType>();
        if (nodeTypes != null) {
            JcrNodeType ntUnstructured = null;
            for (JcrNodeType nodeType : nodeTypes) {
                Name name = nodeType.getInternalName();
                this.nodeTypes.put(name, nodeType);
                for (JcrNodeDefinition childDefinition : nodeType.childNodeDefinitions()) {
                    this.childNodeDefinitions.put(childDefinition.getId(), childDefinition);
                }
                for (JcrPropertyDefinition propertyDefinition : nodeType.propertyDefinitions()) {
                    this.propertyDefinitions.put(propertyDefinition.getId(), propertyDefinition);
                }
                if (nodeType.isMixin()) {
                    mixins.add(nodeType);
                    mixinNames.add(name);
                } else {
                    primaries.add(nodeType);
                }
                if (name.equals(JcrNtLexicon.UNSTRUCTURED)) {
                    ntUnstructured = nodeType;
                    this.nodeTypeNamesThatAllowSameNameSiblings.add(name);
                }
                if (nodeType.isNodeType(JcrMixLexicon.REFERENCEABLE)) {
                    this.nodeTypeNamesThatAreReferenceable.add(name);
                }
                boolean fullyDefined = true;
                if (nodeType.isNodeType(JcrMixLexicon.CREATED)) {
                    this.createdNodeTypeNames.add(name);
                    fullyDefined = false;
                }
                if (nodeType.isNodeType(JcrMixLexicon.LAST_MODIFIED)) {
                    this.lastModifiedNodeTypeNames.add(name);
                    fullyDefined = false;
                }
                if (nodeType.isNodeType(JcrNtLexicon.RESOURCE)) {
                    this.resourceNodeTypeNames.add(name);
                    fullyDefined = false;
                }
                if (nodeType.isNodeType(JcrMixLexicon.ETAG)) {
                    this.etagNodeTypeNames.add(name);
                    fullyDefined = false;
                }
                if (nodeType.isNodeType(JcrMixLexicon.VERSIONABLE)) {
                    this.versionableNodeTypeNames.add(name);
                    fullyDefined = false;
                }
                for (JcrPropertyDefinition propDefn : nodeType.allPropertyDefinitions()) {
                    if (propDefn.isMandatory() && !propDefn.isProtected()) {
                        this.mandatoryPropertiesNodeTypes.put((Object)name, (Object)propDefn);
                        fullyDefined = false;
                    }
                    if (!propDefn.isAutoCreated() || propDefn.isProtected()) continue;
                    this.autoCreatedPropertiesNodeTypes.put((Object)name, (Object)propDefn);
                }
                Collection<JcrNodeDefinition> allChildNodeDefinitions = nodeType.allChildNodeDefinitions();
                boolean allowsResidualWithSameNameSiblings = false;
                boolean allowsOnlySameNameSiblings = true;
                boolean mixinWithNoChildNodeDefinitions = nodeType.isMixin() && allChildNodeDefinitions.isEmpty();
                for (JcrNodeDefinition childDefn : allChildNodeDefinitions) {
                    if (childDefn.isMandatory() && !childDefn.isProtected()) {
                        this.mandatoryChildrenNodeTypes.put((Object)name, (Object)childDefn);
                        fullyDefined = false;
                    }
                    if (childDefn.isAutoCreated() && !childDefn.isProtected()) {
                        this.autoCreatedChildrenNodeTypes.put((Object)name, (Object)childDefn);
                    }
                    if (childDefn.allowsSameNameSiblings()) {
                        if (!childDefn.isResidual() || childDefn.hasRequiredPrimaryTypes()) continue;
                        allowsResidualWithSameNameSiblings = true;
                        continue;
                    }
                    allowsOnlySameNameSiblings = false;
                }
                if (!nodeType.isAbstract() && (allowsResidualWithSameNameSiblings || allowsOnlySameNameSiblings || mixinWithNoChildNodeDefinitions)) {
                    this.nodeTypeNamesThatAllowSameNameSiblings.add(name);
                }
                if (!fullyDefined) continue;
                fullyDefinedNodeTypes.add(name);
            }
            assert (ntUnstructured != null);
            Collection<JcrNodeDefinition> childDefns = ntUnstructured.allChildNodeDefinitions(JcrNodeType.RESIDUAL_NAME, true);
            assert (childDefns.size() == 1);
            this.ntUnstructuredSnsChildDefinition = childDefns.iterator().next();
            assert (this.ntUnstructuredSnsChildDefinition != null);
            childDefns = ntUnstructured.allChildNodeDefinitions(JcrNodeType.RESIDUAL_NAME, false);
            assert (childDefns.size() == 1);
            this.ntUnstructuredSingleChildDefinition = childDefns.iterator().next();
            assert (this.ntUnstructuredSingleChildDefinition != null);
        } else {
            this.ntUnstructuredSnsChildDefinition = null;
            this.ntUnstructuredSingleChildDefinition = null;
        }
        this.unmodifiableNodeTypes = Collections.unmodifiableCollection(this.nodeTypes.values());
        this.unmodifiableNodeTypeNames = Collections.unmodifiableSet(this.nodeTypes.keySet());
        this.unmodifiableMixinTypeNames = Collections.unmodifiableSet(mixinNames);
        this.unmodifiableMixinNodeTypes = Collections.unmodifiableList(mixins);
        this.unmodifiablePrimaryNodeTypes = Collections.unmodifiableList(primaries);
    }

    protected NodeTypes without(Collection<JcrNodeType> removedNodeTypes) {
        if (removedNodeTypes.isEmpty()) {
            return this;
        }
        HashSet<JcrNodeType> nodeTypes = new HashSet<JcrNodeType>(this.nodeTypes.values());
        nodeTypes.removeAll(removedNodeTypes);
        return new NodeTypes(this.context, nodeTypes, this.getVersion() + 1);
    }

    protected NodeTypes with(Collection<JcrNodeType> addedNodeTypes) {
        if (addedNodeTypes.isEmpty()) {
            return this;
        }
        HashSet<JcrNodeType> nodeTypes = new HashSet<JcrNodeType>(this.nodeTypes.values());
        nodeTypes.removeAll(addedNodeTypes);
        nodeTypes.addAll(addedNodeTypes);
        return new NodeTypes(this.context, nodeTypes, this.getVersion() + 1);
    }

    protected final NameFactory nameFactory() {
        return this.nameFactory;
    }

    public int getVersion() {
        return this.nodeTypesVersion;
    }

    public boolean isFullyDefinedType(Name primaryTypeName, Set<Name> mixinTypeNames) {
        if (!fullyDefinedNodeTypes.contains(primaryTypeName)) {
            return false;
        }
        if (!mixinTypeNames.isEmpty()) {
            for (Name nodeTypeName : mixinTypeNames) {
                if (fullyDefinedNodeTypes.contains(nodeTypeName)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isTypeOrSubtype(Name nodeTypeName, Name candidateSupertypeName) {
        if (nodeTypeName.equals(candidateSupertypeName)) {
            return true;
        }
        JcrNodeType primaryType = this.getNodeType(nodeTypeName);
        return primaryType.isNodeType(candidateSupertypeName);
    }

    public boolean isTypeOrSubtype(Set<Name> nodeTypeNames, Name candidateSupertypeName) {
        for (Name nodeTypeName : nodeTypeNames) {
            if (!this.isTypeOrSubtype(nodeTypeName, candidateSupertypeName)) continue;
            return true;
        }
        return false;
    }

    public boolean isTypeOrSubtype(Name[] nodeTypeNames, Name candidateSupertypeName) {
        for (Name nodeTypeName : nodeTypeNames) {
            if (!this.isTypeOrSubtype(nodeTypeName, candidateSupertypeName)) continue;
            return true;
        }
        return false;
    }

    public boolean isCreated(Name primaryType, Set<Name> mixinTypes) {
        if (this.createdNodeTypeNames.contains(primaryType)) {
            return true;
        }
        if (mixinTypes != null) {
            for (Name mixinType : mixinTypes) {
                if (!this.createdNodeTypeNames.contains(mixinType)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isLastModified(Name primaryType, Set<Name> mixinTypes) {
        if (this.lastModifiedNodeTypeNames.contains(primaryType)) {
            return true;
        }
        if (mixinTypes != null) {
            for (Name mixinType : mixinTypes) {
                if (!this.lastModifiedNodeTypeNames.contains(mixinType)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isNtResource(Name primaryType) {
        return this.resourceNodeTypeNames.contains(primaryType);
    }

    public boolean isETag(Name primaryType, Set<Name> mixinTypes) {
        if (this.etagNodeTypeNames.contains(primaryType)) {
            return true;
        }
        if (mixinTypes != null) {
            for (Name mixinType : mixinTypes) {
                if (!this.etagNodeTypeNames.contains(mixinType)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isReferenceable(Name primaryType, Set<Name> mixinTypes) {
        if (this.nodeTypeNamesThatAreReferenceable.contains(primaryType)) {
            return true;
        }
        if (mixinTypes != null) {
            for (Name mixinType : mixinTypes) {
                if (!this.nodeTypeNamesThatAreReferenceable.contains(mixinType)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean disallowsSameNameSiblings(Name primaryType, Set<Name> mixinTypes) {
        if (!this.nodeTypeNamesThatAllowSameNameSiblings.contains(primaryType)) {
            return true;
        }
        for (Name mixinType : mixinTypes) {
            if (this.nodeTypeNamesThatAllowSameNameSiblings.contains(mixinType)) continue;
            return true;
        }
        return false;
    }

    public boolean isVersionable(Name primaryType, Set<Name> mixinTypes) {
        if (primaryType != null && this.versionableNodeTypeNames.contains(primaryType)) {
            return true;
        }
        for (Name mixinType : mixinTypes) {
            if (!this.versionableNodeTypeNames.contains(mixinType)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMandatoryPropertyDefinitions(Name primaryType, Set<Name> mixinTypes) {
        if (this.mandatoryPropertiesNodeTypes.containsKey((Object)primaryType)) {
            return true;
        }
        for (Name mixinType : mixinTypes) {
            if (!this.mandatoryPropertiesNodeTypes.containsKey((Object)mixinType)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMandatoryChildNodeDefinitions(Name primaryType, Set<Name> mixinTypes) {
        if (this.mandatoryChildrenNodeTypes.containsKey((Object)primaryType)) {
            return true;
        }
        for (Name mixinType : mixinTypes) {
            if (!this.mandatoryChildrenNodeTypes.containsKey((Object)mixinType)) continue;
            return true;
        }
        return false;
    }

    public Collection<JcrPropertyDefinition> getMandatoryPropertyDefinitions(Name primaryType, Set<Name> mixinTypes) {
        if (mixinTypes.isEmpty()) {
            return this.mandatoryPropertiesNodeTypes.get((Object)primaryType);
        }
        HashSet<JcrPropertyDefinition> defn = new HashSet<JcrPropertyDefinition>();
        defn.addAll(this.mandatoryPropertiesNodeTypes.get((Object)primaryType));
        for (Name mixinType : mixinTypes) {
            defn.addAll(this.mandatoryPropertiesNodeTypes.get((Object)mixinType));
        }
        return defn;
    }

    public Collection<JcrNodeDefinition> getMandatoryChildNodeDefinitions(Name primaryType, Set<Name> mixinTypes) {
        if (mixinTypes.isEmpty()) {
            return this.mandatoryChildrenNodeTypes.get((Object)primaryType);
        }
        HashSet<JcrNodeDefinition> defn = new HashSet<JcrNodeDefinition>();
        defn.addAll(this.mandatoryChildrenNodeTypes.get((Object)primaryType));
        for (Name mixinType : mixinTypes) {
            defn.addAll(this.mandatoryChildrenNodeTypes.get((Object)mixinType));
        }
        return defn;
    }

    public Collection<JcrPropertyDefinition> getAutoCreatedPropertyDefinitions(Name nodeType) {
        return this.autoCreatedPropertiesNodeTypes.get((Object)nodeType);
    }

    public Collection<JcrNodeDefinition> getAutoCreatedChildNodeDefinitions(Name nodeType) {
        return this.autoCreatedChildrenNodeTypes.get((Object)nodeType);
    }

    public Collection<JcrNodeType> getAllNodeTypes() {
        return this.unmodifiableNodeTypes;
    }

    public Set<Name> getAllNodeTypeNames() {
        return this.unmodifiableNodeTypeNames;
    }

    public Collection<JcrNodeType> getMixinNodeTypes() {
        return this.unmodifiableMixinNodeTypes;
    }

    public boolean isMixin(Name nodeTypeName) {
        return this.unmodifiableMixinTypeNames.contains(nodeTypeName);
    }

    public Collection<JcrNodeType> getPrimaryNodeTypes() {
        return this.unmodifiablePrimaryNodeTypes;
    }

    public JcrPropertyDefinition getPropertyDefinition(PropertyDefinitionId id) {
        return this.propertyDefinitions.get(id);
    }

    public Collection<JcrPropertyDefinition> getAllPropertyDefinitions() {
        return this.propertyDefinitions.values();
    }

    public JcrNodeDefinition getChildNodeDefinition(NodeDefinitionId id) {
        return this.childNodeDefinitions.get(id);
    }

    JcrNodeType getNodeType(Name nodeTypeName) {
        return this.nodeTypes.get(nodeTypeName);
    }

    boolean hasNodeType(Name nodeTypeName) {
        return this.nodeTypes.containsKey(nodeTypeName);
    }

    JcrPropertyDefinition findPropertyDefinition(JcrSession session, Name primaryTypeName, Collection<Name> mixinTypeNames, Name propertyName, Value value, boolean checkMultiValuedDefinitions, boolean skipProtected) {
        return this.findPropertyDefinition(session, primaryTypeName, mixinTypeNames, propertyName, value, checkMultiValuedDefinitions, skipProtected, true);
    }

    JcrPropertyDefinition findPropertyDefinition(JcrSession session, Name primaryTypeName, Collection<Name> mixinTypeNames, Name propertyName, Value value, boolean checkMultiValuedDefinitions, boolean skipProtected, boolean checkTypeAndConstraints) {
        int type;
        boolean setToEmpty = value == null;
        boolean matchedOnName = false;
        JcrNodeType primaryType = this.getNodeType(primaryTypeName);
        if (primaryType != null) {
            int type2;
            for (JcrPropertyDefinition definition : primaryType.allSingleValuePropertyDefinitions(propertyName)) {
                matchedOnName = true;
                if (skipProtected && definition.isProtected()) {
                    return null;
                }
                if (setToEmpty) {
                    if (definition.isMandatory()) continue;
                    return definition;
                }
                assert (value != null);
                type2 = definition.getRequiredType();
                if (type2 == 9 && type2 == value.getType()) {
                    return definition;
                }
                if (type2 == 10 && type2 == value.getType()) {
                    return definition;
                }
                if (type2 == 100 && type2 == value.getType()) {
                    return definition;
                }
                if (type2 != 0 && type2 != value.getType()) continue;
                if (!checkTypeAndConstraints) {
                    return definition;
                }
                if (!definition.satisfiesConstraints(value, session)) continue;
                return definition;
            }
            if (matchedOnName) {
                if (value != null) {
                    for (JcrPropertyDefinition definition : primaryType.allSingleValuePropertyDefinitions(propertyName)) {
                        if (skipProtected && definition.isProtected()) {
                            return null;
                        }
                        type2 = definition.getRequiredType();
                        if (type2 == 9 && definition.canCastToType(value)) {
                            return definition;
                        }
                        if (type2 == 10 && definition.canCastToType(value)) {
                            return definition;
                        }
                        if (type2 == 100 && definition.canCastToType(value)) {
                            return definition;
                        }
                        if (!checkTypeAndConstraints) {
                            return definition;
                        }
                        if (!definition.canCastToTypeAndSatisfyConstraints(value, session)) continue;
                        return definition;
                    }
                }
                if (checkMultiValuedDefinitions) {
                    for (JcrPropertyDefinition definition : primaryType.allMultiValuePropertyDefinitions(propertyName)) {
                        if (skipProtected && definition.isProtected()) {
                            return null;
                        }
                        if (setToEmpty) {
                            if (definition.isMandatory()) continue;
                            return definition;
                        }
                        assert (value != null);
                        type2 = definition.getRequiredType();
                        if (type2 == 9 && type2 == value.getType()) {
                            return definition;
                        }
                        if (type2 == 10 && type2 == value.getType()) {
                            return definition;
                        }
                        if (type2 == 100 && type2 == value.getType()) {
                            return definition;
                        }
                        if (type2 != 0 && type2 != value.getType()) continue;
                        if (!checkTypeAndConstraints) {
                            return definition;
                        }
                        if (!definition.satisfiesConstraints(value, session)) continue;
                        return definition;
                    }
                    if (value != null) {
                        for (JcrPropertyDefinition definition : primaryType.allMultiValuePropertyDefinitions(propertyName)) {
                            if (skipProtected && definition.isProtected()) {
                                return null;
                            }
                            assert (definition.getRequiredType() != 0);
                            type2 = definition.getRequiredType();
                            if (type2 == 9 && definition.canCastToType(value)) {
                                return definition;
                            }
                            if (type2 == 10 && definition.canCastToType(value)) {
                                return definition;
                            }
                            if (type2 == 100 && definition.canCastToType(value)) {
                                return definition;
                            }
                            if (!checkTypeAndConstraints) {
                                return definition;
                            }
                            if (!definition.canCastToTypeAndSatisfyConstraints(value, session)) continue;
                            return definition;
                        }
                    }
                }
                return null;
            }
        }
        LinkedList<JcrNodeType> mixinTypes = null;
        if (mixinTypeNames != null) {
            mixinTypes = new LinkedList<JcrNodeType>();
            for (Name mixinTypeName : mixinTypeNames) {
                JcrNodeType mixinType = this.getNodeType(mixinTypeName);
                if (mixinType == null) continue;
                mixinTypes.add(mixinType);
                for (JcrPropertyDefinition definition : mixinType.allSingleValuePropertyDefinitions(propertyName)) {
                    matchedOnName = true;
                    if (skipProtected && definition.isProtected()) {
                        return null;
                    }
                    if (setToEmpty) {
                        if (definition.isMandatory()) continue;
                        return definition;
                    }
                    assert (value != null);
                    type = definition.getRequiredType();
                    if (type == 9 && type == value.getType()) {
                        return definition;
                    }
                    if (type == 10 && type == value.getType()) {
                        return definition;
                    }
                    if (type == 100 && type == value.getType()) {
                        return definition;
                    }
                    if (type != 0 && type != value.getType()) continue;
                    if (!checkTypeAndConstraints) {
                        return definition;
                    }
                    if (!definition.satisfiesConstraints(value, session)) continue;
                    return definition;
                }
                if (!matchedOnName) continue;
                if (value != null) {
                    for (JcrPropertyDefinition definition : mixinType.allSingleValuePropertyDefinitions(propertyName)) {
                        if (skipProtected && definition.isProtected()) {
                            return null;
                        }
                        assert (definition.getRequiredType() != 0);
                        type = definition.getRequiredType();
                        if (type == 9 && definition.canCastToType(value)) {
                            return definition;
                        }
                        if (type == 10 && definition.canCastToType(value)) {
                            return definition;
                        }
                        if (type == 100 && definition.canCastToType(value)) {
                            return definition;
                        }
                        if (!checkTypeAndConstraints) {
                            return definition;
                        }
                        if (!definition.canCastToTypeAndSatisfyConstraints(value, session)) continue;
                        return definition;
                    }
                }
                if (checkMultiValuedDefinitions) {
                    for (JcrPropertyDefinition definition : mixinType.allMultiValuePropertyDefinitions(propertyName)) {
                        if (skipProtected && definition.isProtected()) {
                            return null;
                        }
                        if (setToEmpty) {
                            if (definition.isMandatory()) continue;
                            return definition;
                        }
                        assert (value != null);
                        type = definition.getRequiredType();
                        if (type == 9 && type == value.getType()) {
                            return definition;
                        }
                        if (type == 10 && type == value.getType()) {
                            return definition;
                        }
                        if (type == 100 && type == value.getType()) {
                            return definition;
                        }
                        if (type != 0 && type != value.getType()) continue;
                        if (!checkTypeAndConstraints) {
                            return definition;
                        }
                        if (!definition.satisfiesConstraints(value, session)) continue;
                        return definition;
                    }
                    if (value != null) {
                        for (JcrPropertyDefinition definition : mixinType.allMultiValuePropertyDefinitions(propertyName)) {
                            matchedOnName = true;
                            if (skipProtected && definition.isProtected()) {
                                return null;
                            }
                            assert (definition.getRequiredType() != 0);
                            type = definition.getRequiredType();
                            if (type == 9 && definition.canCastToType(value)) {
                                return definition;
                            }
                            if (type == 10 && definition.canCastToType(value)) {
                                return definition;
                            }
                            if (type == 100 && definition.canCastToType(value)) {
                                return definition;
                            }
                            if (!checkTypeAndConstraints) {
                                return definition;
                            }
                            if (!definition.canCastToTypeAndSatisfyConstraints(value, session)) continue;
                            return definition;
                        }
                    }
                }
                return null;
            }
        }
        if (checkMultiValuedDefinitions) {
            if (primaryType != null) {
                for (JcrPropertyDefinition definition : primaryType.allMultiValuePropertyDefinitions(propertyName)) {
                    matchedOnName = true;
                    if (skipProtected && definition.isProtected()) {
                        return null;
                    }
                    if (setToEmpty) {
                        if (definition.isMandatory()) continue;
                        return definition;
                    }
                    assert (value != null);
                    int type3 = definition.getRequiredType();
                    if (type3 == 9 && type3 == value.getType()) {
                        return definition;
                    }
                    if (type3 == 10 && type3 == value.getType()) {
                        return definition;
                    }
                    if (type3 == 100 && type3 == value.getType()) {
                        return definition;
                    }
                    if (type3 != 0 && type3 != value.getType()) continue;
                    if (!checkTypeAndConstraints) {
                        return definition;
                    }
                    if (!definition.satisfiesConstraints(value, session)) continue;
                    return definition;
                }
                if (value != null) {
                    for (JcrPropertyDefinition definition : primaryType.allMultiValuePropertyDefinitions(propertyName)) {
                        matchedOnName = true;
                        if (skipProtected && definition.isProtected()) {
                            return null;
                        }
                        assert (definition.getRequiredType() != 0);
                        int type4 = definition.getRequiredType();
                        if (type4 == 9 && definition.canCastToType(value)) {
                            return definition;
                        }
                        if (type4 == 10 && definition.canCastToType(value)) {
                            return definition;
                        }
                        if (type4 == 100 && definition.canCastToType(value)) {
                            return definition;
                        }
                        if (!checkTypeAndConstraints) {
                            return definition;
                        }
                        if (!definition.canCastToTypeAndSatisfyConstraints(value, session)) continue;
                        return definition;
                    }
                }
            }
            if (matchedOnName) {
                return null;
            }
            if (mixinTypeNames != null) {
                mixinTypes = new LinkedList();
                for (Name mixinTypeName : mixinTypeNames) {
                    JcrNodeType mixinType = this.getNodeType(mixinTypeName);
                    if (mixinType == null) continue;
                    mixinTypes.add(mixinType);
                    for (JcrPropertyDefinition definition : mixinType.allMultiValuePropertyDefinitions(propertyName)) {
                        matchedOnName = true;
                        if (skipProtected && definition.isProtected()) {
                            return null;
                        }
                        if (setToEmpty) {
                            if (definition.isMandatory()) continue;
                            return definition;
                        }
                        assert (value != null);
                        type = definition.getRequiredType();
                        if (type == 9 && type == value.getType()) {
                            return definition;
                        }
                        if (type == 10 && type == value.getType()) {
                            return definition;
                        }
                        if (type == 100 && type == value.getType()) {
                            return definition;
                        }
                        if (type != 0 && type != value.getType()) continue;
                        if (!checkTypeAndConstraints) {
                            return definition;
                        }
                        if (!definition.satisfiesConstraints(value, session)) continue;
                        return definition;
                    }
                    if (value == null) continue;
                    for (JcrPropertyDefinition definition : mixinType.allMultiValuePropertyDefinitions(propertyName)) {
                        matchedOnName = true;
                        if (skipProtected && definition.isProtected()) {
                            return null;
                        }
                        assert (definition.getRequiredType() != 0);
                        type = definition.getRequiredType();
                        if (type == 9 && definition.canCastToType(value)) {
                            return definition;
                        }
                        if (type == 10 && definition.canCastToType(value)) {
                            return definition;
                        }
                        if (type == 100 && definition.canCastToType(value)) {
                            return definition;
                        }
                        if (!checkTypeAndConstraints) {
                            return definition;
                        }
                        if (!definition.canCastToTypeAndSatisfyConstraints(value, session)) continue;
                        return definition;
                    }
                }
            }
            if (matchedOnName) {
                return null;
            }
        }
        if (!propertyName.equals(JcrNodeType.RESIDUAL_NAME)) {
            return this.findPropertyDefinition(session, primaryTypeName, mixinTypeNames, JcrNodeType.RESIDUAL_NAME, value, checkMultiValuedDefinitions, skipProtected, checkTypeAndConstraints);
        }
        return null;
    }

    JcrPropertyDefinition findPropertyDefinition(JcrSession session, Name primaryTypeName, Collection<Name> mixinTypeNames, Name propertyName, Value[] values, boolean skipProtected) {
        return this.findPropertyDefinition(session, primaryTypeName, mixinTypeNames, propertyName, values, skipProtected, true);
    }

    JcrPropertyDefinition findPropertyDefinition(JcrSession session, Name primaryTypeName, Collection<Name> mixinTypeNames, Name propertyName, Value[] values, boolean skipProtected, boolean checkTypeAndConstraints) {
        boolean setToEmpty = values == null;
        int propertyType = values == null || values.length == 0 ? 1 : values[0].getType();
        boolean matchedOnName = false;
        JcrNodeType primaryType = this.getNodeType(primaryTypeName);
        if (primaryType != null) {
            for (JcrPropertyDefinition definition : primaryType.allMultiValuePropertyDefinitions(propertyName)) {
                matchedOnName = true;
                if (skipProtected && definition.isProtected()) {
                    return null;
                }
                if (setToEmpty) {
                    if (definition.isMandatory()) continue;
                    return definition;
                }
                assert (values != null);
                int type = definition.getRequiredType();
                boolean typeMatches = values.length == 0 || type == 0 || type == propertyType;
                if (!typeMatches) continue;
                if (type == 9) {
                    return definition;
                }
                if (type == 10) {
                    return definition;
                }
                if (type == 100) {
                    return definition;
                }
                if (!checkTypeAndConstraints) {
                    return definition;
                }
                if (!definition.satisfiesConstraints(values, session)) continue;
                return definition;
            }
            if (matchedOnName) {
                if (values != null && values.length != 0) {
                    for (JcrPropertyDefinition definition : primaryType.allMultiValuePropertyDefinitions(propertyName)) {
                        if (skipProtected && definition.isProtected()) {
                            return null;
                        }
                        assert (definition.getRequiredType() != 0);
                        if (definition.getRequiredType() == 9 && definition.canCastToType(values)) {
                            return definition;
                        }
                        if (definition.getRequiredType() == 10 && definition.canCastToType(values)) {
                            return definition;
                        }
                        if (definition.getRequiredType() == 100 && definition.canCastToType(values)) {
                            return definition;
                        }
                        if (!checkTypeAndConstraints) {
                            return definition;
                        }
                        if (!definition.canCastToTypeAndSatisfyConstraints(values, session)) continue;
                        return definition;
                    }
                }
                return null;
            }
        }
        LinkedList<JcrNodeType> mixinTypes = null;
        if (mixinTypeNames != null) {
            mixinTypes = new LinkedList<JcrNodeType>();
            for (Name mixinTypeName : mixinTypeNames) {
                JcrNodeType mixinType = this.getNodeType(mixinTypeName);
                if (mixinType == null) continue;
                mixinTypes.add(mixinType);
                for (JcrPropertyDefinition definition : mixinType.allMultiValuePropertyDefinitions(propertyName)) {
                    matchedOnName = true;
                    if (skipProtected && definition.isProtected()) {
                        return null;
                    }
                    if (setToEmpty) {
                        if (definition.isMandatory()) continue;
                        return definition;
                    }
                    assert (values != null);
                    int type = definition.getRequiredType();
                    boolean typeMatches = values.length == 0 || type == 0 || type == propertyType;
                    if (!typeMatches) continue;
                    if (type == 9) {
                        return definition;
                    }
                    if (type == 10) {
                        return definition;
                    }
                    if (type == 100) {
                        return definition;
                    }
                    if (!checkTypeAndConstraints) {
                        return definition;
                    }
                    if (!definition.satisfiesConstraints(values, session)) continue;
                    return definition;
                }
                if (!matchedOnName) continue;
                if (values != null && values.length != 0) {
                    for (JcrPropertyDefinition definition : mixinType.allMultiValuePropertyDefinitions(propertyName)) {
                        if (skipProtected && definition.isProtected()) {
                            return null;
                        }
                        assert (definition.getRequiredType() != 0);
                        if (definition.getRequiredType() == 9 && definition.canCastToType(values)) {
                            return definition;
                        }
                        if (definition.getRequiredType() == 10 && definition.canCastToType(values)) {
                            return definition;
                        }
                        if (definition.getRequiredType() == 100 && definition.canCastToType(values)) {
                            return definition;
                        }
                        if (!checkTypeAndConstraints) {
                            return definition;
                        }
                        if (!definition.canCastToTypeAndSatisfyConstraints(values, session)) continue;
                        return definition;
                    }
                }
                return null;
            }
        }
        if (!propertyName.equals(JcrNodeType.RESIDUAL_NAME)) {
            return this.findPropertyDefinition(session, primaryTypeName, mixinTypeNames, JcrNodeType.RESIDUAL_NAME, values, skipProtected, checkTypeAndConstraints);
        }
        return null;
    }

    List<JcrPropertyDefinition> findPropertyDefinitions(List<Name> typeNamesToCheck, Name propertyName, PropertyCardinality typeToCheck, List<JcrNodeType> pendingTypes) {
        assert (typeNamesToCheck != null);
        Collection<JcrPropertyDefinition> propDefs = null;
        ArrayList<JcrPropertyDefinition> matchingDefs = new ArrayList<JcrPropertyDefinition>();
        for (Name typeNameToCheck : typeNamesToCheck) {
            JcrNodeType typeName = this.findTypeInMapOrList(typeNameToCheck, pendingTypes);
            if (typeName == null) continue;
            switch (typeToCheck) {
                case SINGLE_VALUED_ONLY: {
                    propDefs = typeName.allSingleValuePropertyDefinitions(propertyName);
                    break;
                }
                case MULTI_VALUED_ONLY: {
                    propDefs = typeName.allMultiValuePropertyDefinitions(propertyName);
                    break;
                }
                case ANY: {
                    propDefs = typeName.allPropertyDefinitions(propertyName);
                    break;
                }
                default: {
                    throw new IllegalStateException("Should be unreachable: " + (Object)((Object)typeToCheck));
                }
            }
            if (propDefs.isEmpty()) continue;
            matchingDefs.addAll(propDefs);
        }
        return matchingDefs;
    }

    boolean canRemoveProperty(Name primaryTypeNameOfParent, List<Name> mixinTypeNamesOfParent, Name propertyName, boolean skipProtected) {
        JcrNodeType primaryType = this.getNodeType(primaryTypeNameOfParent);
        if (primaryType != null) {
            for (JcrPropertyDefinition definition : primaryType.allPropertyDefinitions(propertyName)) {
                if (skipProtected && definition.isProtected()) continue;
                return !definition.isMandatory();
            }
        }
        if (mixinTypeNamesOfParent != null && !mixinTypeNamesOfParent.isEmpty()) {
            for (Name mixinTypeName : mixinTypeNamesOfParent) {
                JcrNodeType mixinType = this.getNodeType(mixinTypeName);
                if (mixinType == null) continue;
                for (JcrPropertyDefinition definition : mixinType.allPropertyDefinitions(propertyName)) {
                    if (skipProtected && definition.isProtected()) continue;
                    return !definition.isMandatory();
                }
            }
        }
        if (!propertyName.equals(JcrNodeType.RESIDUAL_NAME)) {
            return this.canRemoveProperty(primaryTypeNameOfParent, mixinTypeNamesOfParent, JcrNodeType.RESIDUAL_NAME, skipProtected);
        }
        return false;
    }

    boolean canRemoveItem(Name primaryTypeNameOfParent, List<Name> mixinTypeNamesOfParent, Name itemName, boolean skipProtected) {
        JcrNodeType mixinType;
        JcrNodeType primaryType = this.getNodeType(primaryTypeNameOfParent);
        if (primaryType != null) {
            for (JcrPropertyDefinition jcrPropertyDefinition : primaryType.allPropertyDefinitions(itemName)) {
                if (skipProtected && jcrPropertyDefinition.isProtected()) continue;
                return !jcrPropertyDefinition.isMandatory();
            }
        }
        if (primaryType != null) {
            for (JcrNodeDefinition jcrNodeDefinition : primaryType.allChildNodeDefinitions(itemName)) {
                if (skipProtected && jcrNodeDefinition.isProtected()) continue;
                return !jcrNodeDefinition.isMandatory();
            }
        }
        if (mixinTypeNamesOfParent != null && !mixinTypeNamesOfParent.isEmpty()) {
            for (Name name : mixinTypeNamesOfParent) {
                mixinType = this.getNodeType(name);
                if (mixinType == null) continue;
                for (JcrPropertyDefinition jcrPropertyDefinition : mixinType.allPropertyDefinitions(itemName)) {
                    if (skipProtected && jcrPropertyDefinition.isProtected()) continue;
                    return !jcrPropertyDefinition.isMandatory();
                }
            }
        }
        if (mixinTypeNamesOfParent != null && !mixinTypeNamesOfParent.isEmpty()) {
            for (Name name : mixinTypeNamesOfParent) {
                mixinType = this.getNodeType(name);
                if (mixinType == null) continue;
                for (JcrNodeDefinition jcrNodeDefinition : mixinType.allChildNodeDefinitions(itemName)) {
                    if (skipProtected && jcrNodeDefinition.isProtected()) continue;
                    return !jcrNodeDefinition.isMandatory();
                }
            }
        }
        if (!itemName.equals(JcrNodeType.RESIDUAL_NAME)) {
            return this.canRemoveItem(primaryTypeNameOfParent, mixinTypeNamesOfParent, JcrNodeType.RESIDUAL_NAME, skipProtected);
        }
        return false;
    }

    protected final JcrNodeDefinition findChildNodeDefinitionForUnstructured(boolean requireSns) {
        return requireSns ? this.ntUnstructuredSnsChildDefinition : this.ntUnstructuredSingleChildDefinition;
    }

    JcrNodeDefinition findChildNodeDefinition(Name primaryTypeNameOfParent, Collection<Name> mixinTypeNamesOfParent, Name childName, Name childPrimaryNodeType, int numberOfExistingChildrenWithSameName, boolean skipProtected) {
        boolean requireSns;
        JcrNodeType childType = childPrimaryNodeType != null ? this.getNodeType(childPrimaryNodeType) : null;
        boolean bl = requireSns = numberOfExistingChildrenWithSameName > 1;
        if ((mixinTypeNamesOfParent == null || mixinTypeNamesOfParent.isEmpty()) && JcrNtLexicon.UNSTRUCTURED.equals(primaryTypeNameOfParent)) {
            return this.findChildNodeDefinitionForUnstructured(requireSns);
        }
        JcrNodeType primaryType = this.getNodeType(primaryTypeNameOfParent);
        if (primaryType != null) {
            for (JcrNodeDefinition definition : primaryType.allChildNodeDefinitions(childName, requireSns)) {
                if (skipProtected && definition.isProtected() || !definition.allowsChildWithType(childType)) continue;
                return definition;
            }
        }
        if (mixinTypeNamesOfParent != null) {
            for (Name mixinTypeName : mixinTypeNamesOfParent) {
                JcrNodeType mixinType = this.getNodeType(mixinTypeName);
                if (mixinType == null) continue;
                for (JcrNodeDefinition definition : mixinType.allChildNodeDefinitions(childName, requireSns)) {
                    if (skipProtected && definition.isProtected() || !definition.allowsChildWithType(childType)) continue;
                    return definition;
                }
            }
        }
        if (!childName.equals(JcrNodeType.RESIDUAL_NAME)) {
            return this.findChildNodeDefinition(primaryTypeNameOfParent, mixinTypeNamesOfParent, JcrNodeType.RESIDUAL_NAME, childPrimaryNodeType, numberOfExistingChildrenWithSameName, skipProtected);
        }
        return null;
    }

    List<JcrNodeDefinition> findChildNodeDefinitions(List<Name> typeNamesToCheck, Name childNodeName, NodeCardinality typesToCheck, List<JcrNodeType> pendingTypes) {
        assert (typeNamesToCheck != null);
        Collection<JcrNodeDefinition> nodeDefs = null;
        ArrayList<JcrNodeDefinition> matchingDefs = new ArrayList<JcrNodeDefinition>();
        for (Name typeNameToCheck : typeNamesToCheck) {
            JcrNodeType typeName = this.findTypeInMapOrList(typeNameToCheck, pendingTypes);
            if (typeName == null) continue;
            switch (typesToCheck) {
                case NO_SAME_NAME_SIBLINGS: {
                    nodeDefs = typeName.allChildNodeDefinitions(childNodeName, false);
                    break;
                }
                case SAME_NAME_SIBLINGS: {
                    nodeDefs = typeName.allChildNodeDefinitions(childNodeName, true);
                    break;
                }
                case ANY: {
                    nodeDefs = typeName.allChildNodeDefinitions(childNodeName);
                }
            }
            assert (nodeDefs != null);
            for (JcrNodeDefinition definition : nodeDefs) {
                if (NodeCardinality.NO_SAME_NAME_SIBLINGS == typesToCheck && definition.allowsSameNameSiblings()) continue;
                matchingDefs.add(definition);
            }
        }
        return matchingDefs;
    }

    boolean canRemoveAllChildren(Name primaryTypeNameOfParent, Collection<Name> mixinTypeNamesOfParent, Name childName, boolean skipProtected) {
        JcrNodeType primaryType = this.getNodeType(primaryTypeNameOfParent);
        if (primaryType != null) {
            for (JcrNodeDefinition definition : primaryType.allChildNodeDefinitions(childName)) {
                if (skipProtected && definition.isProtected()) continue;
                return !definition.isMandatory();
            }
        }
        if (mixinTypeNamesOfParent != null) {
            for (Name mixinTypeName : mixinTypeNamesOfParent) {
                JcrNodeType mixinType = this.getNodeType(mixinTypeName);
                if (mixinType == null) continue;
                for (JcrNodeDefinition definition : mixinType.allChildNodeDefinitions(childName)) {
                    if (skipProtected && definition.isProtected()) continue;
                    return !definition.isMandatory();
                }
            }
        }
        if (!childName.equals(JcrNodeType.RESIDUAL_NAME)) {
            return this.canRemoveAllChildren(primaryTypeNameOfParent, mixinTypeNamesOfParent, JcrNodeType.RESIDUAL_NAME, skipProtected);
        }
        return false;
    }

    protected JcrNodeType findTypeInMapOrList(Name typeName, Collection<JcrNodeType> pendingList) {
        for (JcrNodeType pendingNodeType : pendingList) {
            if (!pendingNodeType.getInternalName().equals(typeName)) continue;
            return pendingNodeType;
        }
        return this.nodeTypes.get(typeName);
    }

    protected List<JcrNodeType> supertypesFor(NodeTypeDefinition nodeType, Collection<JcrNodeType> pendingTypes) throws RepositoryException {
        Name nodeName;
        assert (nodeType != null);
        LinkedList<JcrNodeType> supertypes = new LinkedList<JcrNodeType>();
        boolean isMixin = nodeType.isMixin();
        boolean needsPrimaryAncestor = !isMixin;
        String nodeTypeName = nodeType.getName();
        for (String supertypeNameStr : nodeType.getDeclaredSupertypeNames()) {
            Name supertypeName = (Name)this.nameFactory.create(supertypeNameStr);
            JcrNodeType supertype = this.findTypeInMapOrList(supertypeName, pendingTypes);
            if (supertype == null) {
                throw new InvalidNodeTypeDefinitionException(JcrI18n.invalidSupertypeName.text(new Object[]{supertypeNameStr, nodeTypeName}));
            }
            needsPrimaryAncestor &= supertype.isMixin();
            supertypes.add(supertype);
        }
        if (needsPrimaryAncestor && !JcrNtLexicon.BASE.equals(nodeName = (Name)this.nameFactory.create(nodeTypeName))) {
            JcrNodeType ntBase = this.findTypeInMapOrList(JcrNtLexicon.BASE, pendingTypes);
            assert (ntBase != null);
            supertypes.add(0, ntBase);
        }
        return supertypes;
    }

    final Collection<JcrNodeType> subtypesFor(JcrNodeType nodeType) {
        LinkedList<JcrNodeType> subtypes = new LinkedList<JcrNodeType>();
        for (JcrNodeType type : this.nodeTypes.values()) {
            if (!type.supertypes().contains(nodeType)) continue;
            subtypes.add(type);
        }
        return subtypes;
    }

    final Collection<JcrNodeType> declaredSubtypesFor(JcrNodeType nodeType) {
        CheckArg.isNotNull((Object)nodeType, (String)"nodeType");
        String nodeTypeName = nodeType.getName();
        LinkedList<JcrNodeType> subtypes = new LinkedList<JcrNodeType>();
        for (JcrNodeType type : this.nodeTypes.values()) {
            if (!Arrays.asList(type.getDeclaredSupertypeNames()).contains(nodeTypeName)) continue;
            subtypes.add(type);
        }
        return subtypes;
    }

    private void validateSupertypes(List<JcrNodeType> supertypes) throws RepositoryException {
        assert (supertypes != null);
        HashMap<PropertyDefinitionId, JcrPropertyDefinition> props = new HashMap<PropertyDefinitionId, JcrPropertyDefinition>();
        for (JcrNodeType supertype : supertypes) {
            for (JcrPropertyDefinition property : supertype.propertyDefinitions()) {
                String propTypeName;
                String oldPropTypeName;
                JcrPropertyDefinition oldProp = props.put(new PropertyDefinitionId(property.getInternalName(), property.getInternalName(), 0, property.isMultiple()), property);
                if (oldProp == null || (oldPropTypeName = oldProp.getDeclaringNodeType().getName()).equals(propTypeName = property.getDeclaringNodeType().getName())) continue;
                throw new InvalidNodeTypeDefinitionException(JcrI18n.supertypesConflict.text(new Object[]{oldPropTypeName, propTypeName, "property", property.getName()}));
            }
        }
        HashMap<NodeDefinitionId, JcrNodeDefinition> childNodes = new HashMap<NodeDefinitionId, JcrNodeDefinition>();
        for (JcrNodeType supertype : supertypes) {
            for (JcrNodeDefinition childNode : supertype.childNodeDefinitions()) {
                String childNodeTypeName;
                String oldNodeTypeName;
                JcrNodeDefinition oldNode = childNodes.put(new NodeDefinitionId(childNode.getInternalName(), childNode.getInternalName(), new Name[0]), childNode);
                if (oldNode == null || (oldNodeTypeName = oldNode.getDeclaringNodeType().getName()).equals(childNodeTypeName = childNode.getDeclaringNodeType().getName())) continue;
                throw new InvalidNodeTypeDefinitionException(JcrI18n.supertypesConflict.text(new Object[]{oldNodeTypeName, childNodeTypeName, "child node", childNode.getName()}));
            }
        }
    }

    protected void validate(JcrNodeType nodeType, List<JcrNodeType> supertypes, List<JcrNodeType> pendingTypes) throws RepositoryException {
        this.validateSupertypes(supertypes);
        ArrayList<Name> supertypeNames = new ArrayList<Name>(supertypes.size());
        for (JcrNodeType supertype : supertypes) {
            supertypeNames.add(supertype.getInternalName());
        }
        boolean foundExact = false;
        boolean foundResidual = false;
        Name primaryItemName = nodeType.getInternalPrimaryItemName();
        for (JcrNodeDefinition jcrNodeDefinition : nodeType.getDeclaredChildNodeDefinitions()) {
            this.validateChildNodeDefinition(jcrNodeDefinition, supertypeNames, pendingTypes);
            if (jcrNodeDefinition.isResidual()) {
                foundResidual = true;
            }
            if (primaryItemName == null || !primaryItemName.equals(jcrNodeDefinition.getInternalName())) continue;
            foundExact = true;
        }
        for (JcrItemDefinition jcrItemDefinition : nodeType.getDeclaredPropertyDefinitions()) {
            this.validatePropertyDefinition((JcrPropertyDefinition)jcrItemDefinition, supertypeNames, pendingTypes);
            if (jcrItemDefinition.isResidual()) {
                foundResidual = true;
            }
            if (primaryItemName == null || !primaryItemName.equals(jcrItemDefinition.getInternalName())) continue;
            if (foundExact) {
                throw new RepositoryException(JcrI18n.ambiguousPrimaryItemName.text(new Object[]{primaryItemName}));
            }
            foundExact = true;
        }
        if (primaryItemName != null && !foundExact && !foundResidual) {
            throw new RepositoryException(JcrI18n.invalidPrimaryItemName.text(new Object[]{primaryItemName}));
        }
    }

    private void validateChildNodeDefinition(JcrNodeDefinition childNodeDefinition, List<Name> supertypes, List<JcrNodeType> pendingTypes) throws RepositoryException {
        if (childNodeDefinition.isAutoCreated() && !childNodeDefinition.isProtected() && childNodeDefinition.defaultPrimaryTypeName() == null) {
            throw new InvalidNodeTypeDefinitionException(JcrI18n.autocreatedNodesNeedDefaults.text(new Object[]{childNodeDefinition.getName()}));
        }
        boolean residual = "*".equals(childNodeDefinition.getName());
        if (childNodeDefinition.isMandatory() && residual) {
            throw new InvalidNodeTypeDefinitionException(JcrI18n.residualNodeDefinitionsCannotBeMandatory.text(new Object[]{childNodeDefinition.getName()}));
        }
        if (childNodeDefinition.isAutoCreated() && residual) {
            throw new InvalidNodeTypeDefinitionException(JcrI18n.residualNodeDefinitionsCannotBeAutoCreated.text(new Object[]{childNodeDefinition.getName()}));
        }
        Name childNodeName = (Name)this.context.getValueFactories().getNameFactory().create(childNodeDefinition.getName());
        childNodeName = childNodeName == null ? JcrNodeType.RESIDUAL_NAME : childNodeName;
        List<JcrNodeDefinition> childNodesInAncestors = this.findChildNodeDefinitions(supertypes, childNodeName, NodeCardinality.ANY, pendingTypes);
        for (JcrNodeDefinition childNodeFromAncestor : childNodesInAncestors) {
            Name[] requiredPrimaryTypeNames;
            if (childNodeFromAncestor.isProtected()) {
                throw new InvalidNodeTypeDefinitionException(JcrI18n.cannotOverrideProtectedDefinition.text(new Object[]{childNodeFromAncestor.getDeclaringNodeType().getName(), "child node"}));
            }
            if (childNodeFromAncestor.isMandatory() && !childNodeDefinition.isMandatory()) {
                throw new InvalidNodeTypeDefinitionException(JcrI18n.cannotMakeMandatoryDefinitionOptional.text(new Object[]{childNodeFromAncestor.getDeclaringNodeType().getName(), "child node"}));
            }
            for (Name requiredPrimaryTypeName : requiredPrimaryTypeNames = childNodeFromAncestor.requiredPrimaryTypeNames()) {
                JcrNodeType requiredPrimaryTypeFromAncestor = this.findTypeInMapOrList(requiredPrimaryTypeName, pendingTypes);
                if (requiredPrimaryTypeFromAncestor == null) {
                    I18n msg = JcrI18n.couldNotFindDefinitionOfRequiredPrimaryType;
                    throw new InvalidNodeTypeDefinitionException(msg.text(new Object[]{requiredPrimaryTypeName, childNodeDefinition.getName(), childNodeDefinition.getDeclaringNodeType()}));
                }
                boolean found = false;
                for (Name name : childNodeDefinition.requiredPrimaryTypeNames()) {
                    JcrNodeType childNodePrimaryType = this.findTypeInMapOrList(name, pendingTypes);
                    if (childNodePrimaryType == null || !childNodePrimaryType.isNodeType(requiredPrimaryTypeFromAncestor.getName())) continue;
                    found = true;
                    break;
                }
                if (found || residual) continue;
                I18n msg = JcrI18n.cannotRedefineChildNodeWithIncompatibleDefinition;
                throw new InvalidNodeTypeDefinitionException(msg.text(new Object[]{childNodeName, requiredPrimaryTypeFromAncestor.getName(), childNodeDefinition.getDeclaringNodeType()}));
            }
        }
    }

    private void validatePropertyDefinition(JcrPropertyDefinition propertyDefinition, List<Name> supertypes, List<JcrNodeType> pendingTypes) throws RepositoryException {
        assert (propertyDefinition != null);
        assert (supertypes != null);
        assert (pendingTypes != null);
        boolean residual = "*".equals(propertyDefinition.getName());
        if (propertyDefinition.isMandatory() && !propertyDefinition.isProtected() && residual) {
            throw new InvalidNodeTypeDefinitionException(JcrI18n.residualPropertyDefinitionsCannotBeMandatory.text(new Object[]{propertyDefinition.getName()}));
        }
        if (propertyDefinition.isAutoCreated() && residual) {
            throw new InvalidNodeTypeDefinitionException(JcrI18n.residualPropertyDefinitionsCannotBeAutoCreated.text(new Object[]{propertyDefinition.getName()}));
        }
        JcrValue[] defaultValues = propertyDefinition.getDefaultValues();
        if (propertyDefinition.isAutoCreated() && !propertyDefinition.isProtected() && (defaultValues == null || defaultValues.length == 0)) {
            throw new InvalidNodeTypeDefinitionException(JcrI18n.autocreatedPropertyNeedsDefault.text(new Object[]{propertyDefinition.getName(), propertyDefinition.getDeclaringNodeType().getName()}));
        }
        if (!propertyDefinition.isMultiple() && defaultValues != null && defaultValues.length > 1) {
            throw new InvalidNodeTypeDefinitionException(JcrI18n.singleValuedPropertyNeedsSingleValuedDefault.text(new Object[]{propertyDefinition.getName(), propertyDefinition.getDeclaringNodeType().getName()}));
        }
        Name propName = (Name)this.context.getValueFactories().getNameFactory().create(propertyDefinition.getName());
        propName = propName == null ? JcrNodeType.RESIDUAL_NAME : propName;
        List<JcrPropertyDefinition> propertyDefinitionsFromAncestors = this.findPropertyDefinitions(supertypes, propName, propertyDefinition.isMultiple() ? PropertyCardinality.MULTI_VALUED_ONLY : PropertyCardinality.SINGLE_VALUED_ONLY, pendingTypes);
        for (JcrPropertyDefinition propertyDefinitionFromAncestor : propertyDefinitionsFromAncestors) {
            if (propertyDefinitionFromAncestor.isProtected()) {
                throw new InvalidNodeTypeDefinitionException(JcrI18n.cannotOverrideProtectedDefinition.text(new Object[]{propertyDefinitionFromAncestor.getDeclaringNodeType().getName(), "property"}));
            }
            if (propertyDefinitionFromAncestor.isMandatory() && !propertyDefinition.isMandatory()) {
                throw new InvalidNodeTypeDefinitionException(JcrI18n.cannotMakeMandatoryDefinitionOptional.text(new Object[]{propertyDefinitionFromAncestor.getDeclaringNodeType().getName(), "property"}));
            }
            if (!propertyDefinition.isAsOrMoreConstrainedThan(propertyDefinitionFromAncestor, this.context)) {
                throw new InvalidNodeTypeDefinitionException(JcrI18n.constraintsChangedInSubtype.text(new Object[]{propName, propertyDefinitionFromAncestor.getDeclaringNodeType().getName()}));
            }
            if (this.isAlwaysSafeConversion(propertyDefinition.getRequiredType(), propertyDefinitionFromAncestor.getRequiredType())) continue;
            throw new InvalidNodeTypeDefinitionException(JcrI18n.cannotRedefineProperty.text(new Object[]{propName, PropertyType.nameFromValue((int)propertyDefinition.getRequiredType()), propertyDefinitionFromAncestor.getDeclaringNodeType().getName(), PropertyType.nameFromValue((int)propertyDefinitionFromAncestor.getRequiredType())}));
        }
    }

    private boolean isAlwaysSafeConversion(int fromType, int toType) {
        if (fromType == toType) {
            return true;
        }
        switch (toType) {
            case 6: {
                return fromType == 2 || fromType == 1;
            }
            case 5: {
                return fromType == 4 || fromType == 3;
            }
            case 4: {
                return fromType == 3;
            }
            case 3: {
                return fromType == 4;
            }
            case 8: {
                return fromType == 7;
            }
            case 7: 
            case 9: 
            case 10: 
            case 100: {
                return false;
            }
            case 0: 
            case 1: 
            case 2: {
                return true;
            }
        }
        throw new IllegalStateException("Unexpected state: " + toType);
    }

    public String toString() {
        return this.getAllNodeTypes().toString();
    }

    public static enum NodeCardinality {
        NO_SAME_NAME_SIBLINGS,
        SAME_NAME_SIBLINGS,
        ANY;

    }

    public static enum PropertyCardinality {
        SINGLE_VALUED_ONLY,
        MULTI_VALUED_ONLY,
        ANY;

    }

    public static interface Supplier {
        public NodeTypes getNodeTypes();
    }
}

