/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.cache.document;

import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.schematic.SchematicEntry;
import org.infinispan.schematic.document.Document;
import org.infinispan.util.concurrent.TimeoutException;
import org.modeshape.common.logging.Logger;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.bus.ChangeBus;
import org.modeshape.jcr.cache.CachedNode;
import org.modeshape.jcr.cache.ChildReference;
import org.modeshape.jcr.cache.NodeCache;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.WorkspaceNotFoundException;
import org.modeshape.jcr.cache.change.ChangeSet;
import org.modeshape.jcr.cache.change.ChangeSetListener;
import org.modeshape.jcr.cache.document.DocumentCache;
import org.modeshape.jcr.cache.document.DocumentStore;
import org.modeshape.jcr.cache.document.DocumentTranslator;
import org.modeshape.jcr.cache.document.LazyCachedNode;
import org.modeshape.jcr.cache.document.NodeCacheIterator;
import org.modeshape.jcr.value.NameFactory;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.PathFactory;

public class WorkspaceCache
implements DocumentCache {
    protected static final Logger LOGGER = Logger.getLogger(WorkspaceCache.class);
    private final DocumentTranslator translator;
    private final ExecutionContext context;
    private final DocumentStore documentStore;
    private final ConcurrentMap<NodeKey, CachedNode> nodesByKey;
    private final NodeKey rootKey;
    private final ChildReference childReferenceForRoot;
    private final String repositoryKey;
    private final String workspaceName;
    private final String workspaceKey;
    private final String sourceKey;
    private final PathFactory pathFactory;
    private final NameFactory nameFactory;
    private final ChangeBus changeBus;
    private final ChangeSetListener systemChangeNotifier;
    private final ChangeSetListener nonSystemChangeNotifier;
    private volatile boolean closed = false;

    public WorkspaceCache(ExecutionContext context, String repositoryKey, String workspaceName, WorkspaceCache systemWorkspace, DocumentStore documentStore, DocumentTranslator translator, NodeKey rootKey, ConcurrentMap<NodeKey, CachedNode> cache, ChangeBus changeBus) {
        assert (context != null);
        assert (repositoryKey != null);
        assert (workspaceName != null);
        assert (documentStore != null);
        assert (translator != null);
        assert (rootKey != null);
        assert (cache != null);
        assert (changeBus != null);
        this.context = context;
        this.documentStore = documentStore;
        this.changeBus = changeBus;
        this.translator = translator;
        this.rootKey = rootKey;
        this.childReferenceForRoot = new ChildReference(rootKey, Path.ROOT_NAME, 1);
        this.repositoryKey = repositoryKey;
        this.workspaceName = workspaceName;
        this.workspaceKey = rootKey.getWorkspaceKey();
        this.sourceKey = rootKey.getSourceKey();
        this.pathFactory = context.getValueFactories().getPathFactory();
        this.nameFactory = context.getValueFactories().getNameFactory();
        this.nodesByKey = cache;
        if (systemWorkspace != null) {
            this.systemChangeNotifier = new SystemChangeNotifier(systemWorkspace.getWorkspaceName());
            this.nonSystemChangeNotifier = new NonSystemChangeNotifier(systemWorkspace.getWorkspaceName());
            this.changeBus.registerInThread(this.systemChangeNotifier);
            this.changeBus.register(this.nonSystemChangeNotifier);
        } else {
            this.nonSystemChangeNotifier = null;
            this.systemChangeNotifier = new SystemChangeNotifier(this.workspaceName);
            this.changeBus.registerInThread(this.systemChangeNotifier);
        }
    }

    protected WorkspaceCache(WorkspaceCache original, ConcurrentMap<NodeKey, CachedNode> cache) {
        this.context = original.context;
        this.documentStore = original.documentStore;
        this.translator = original.translator;
        this.rootKey = original.rootKey;
        this.childReferenceForRoot = original.childReferenceForRoot;
        this.repositoryKey = original.repositoryKey;
        this.workspaceName = original.workspaceName;
        this.workspaceKey = original.workspaceKey;
        this.sourceKey = original.sourceKey;
        this.pathFactory = original.pathFactory;
        this.nameFactory = original.nameFactory;
        this.nodesByKey = cache;
        this.systemChangeNotifier = null;
        this.nonSystemChangeNotifier = null;
        this.changeBus = null;
    }

    public void setMinimumStringLengthForBinaryStorage(long largeValueSize) {
        assert (largeValueSize > -1L);
        this.translator.setMinimumStringLengthForBinaryStorage(largeValueSize);
    }

    @Override
    public final WorkspaceCache workspaceCache() {
        return this;
    }

    public final String getProcessKey() {
        return this.context.getProcessId();
    }

    public final String getRepositoryKey() {
        return this.repositoryKey;
    }

    public final String getWorkspaceKey() {
        return this.workspaceKey;
    }

    public final String getWorkspaceName() {
        return this.workspaceName;
    }

    final DocumentTranslator translator() {
        return this.translator;
    }

    final ExecutionContext context() {
        return this.context;
    }

    final NameFactory nameFactory() {
        return this.nameFactory;
    }

    final PathFactory pathFactory() {
        return this.pathFactory;
    }

    final Path rootPath() {
        return this.pathFactory().createRootPath();
    }

    final DocumentStore documentStore() {
        return this.documentStore;
    }

    final Document documentFor(String key) {
        SchematicEntry entry = this.documentStore.get(key);
        if (entry == null) {
            return null;
        }
        try {
            return entry.getContentAsDocument();
        }
        catch (IllegalStateException e) {
            LOGGER.debug("The document '{0}' was concurrently removed; returning null.", new Object[]{key});
            return null;
        }
    }

    final Document blockFor(String key) {
        return this.documentStore.getChildrenBlock(key);
    }

    final Document documentFor(NodeKey key) {
        return this.documentFor(key.toString());
    }

    final ChildReference childReferenceForRoot() {
        return this.childReferenceForRoot;
    }

    final String sourceKey() {
        return this.sourceKey;
    }

    final void purge(Iterable<NodeKey> nodeKeys) {
        for (NodeKey nodeKey : nodeKeys) {
            this.nodesByKey.remove(nodeKey);
        }
    }

    @Override
    public NodeKey getRootKey() {
        this.checkNotClosed();
        return this.rootKey;
    }

    @Override
    public CachedNode getNode(NodeKey key) {
        this.checkNotClosed();
        CachedNode node = (CachedNode)this.nodesByKey.get(key);
        if (node == null) {
            Document doc;
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Node '{0}' is not found in the '{1}' workspace cache; looking in store", new Object[]{key, this.workspaceName});
            }
            if ((doc = this.documentFor(key)) != null) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Materialized document '{0}' in '{1}' workspace from store: {2}", new Object[]{key, this.workspaceName, doc});
                }
                LazyCachedNode newNode = new LazyCachedNode(key, doc);
                try {
                    Integer cacheTtlSeconds = this.translator().getCacheTtlSeconds(doc);
                    node = cacheTtlSeconds != null && this.nodesByKey instanceof BasicCache ? (CachedNode)((BasicCache)this.nodesByKey).putIfAbsent((Object)key, (Object)newNode, cacheTtlSeconds.longValue(), TimeUnit.SECONDS) : this.nodesByKey.putIfAbsent(key, newNode);
                }
                catch (TimeoutException e) {
                    node = null;
                }
                if (node == null) {
                    node = newNode;
                }
            }
        }
        return node;
    }

    @Override
    public CachedNode getNode(ChildReference reference) {
        this.checkNotClosed();
        return this.getNode(reference.getKey());
    }

    public ChildReference getChildReference(NodeKey parentKey, NodeKey childKey) {
        Document doc = this.documentStore.getChildReference(parentKey.toString(), childKey.toString());
        if (doc == null) {
            return null;
        }
        return this.translator.childReferenceFrom(doc);
    }

    @Override
    public Iterator<NodeKey> getAllNodeKeys() {
        return this.getAllNodeKeysAtAndBelow(this.getRootKey());
    }

    @Override
    public Iterator<NodeKey> getAllNodeKeysAtAndBelow(NodeKey startingKey) {
        return new NodeCacheIterator(this, startingKey);
    }

    @Override
    public void clear() {
        this.nodesByKey.clear();
    }

    protected void evictChangedNodes(ChangeSet changes) {
        if (!this.closed) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Cache for workspace '{0}' received {1} changes from remote sessions: {2}", new Object[]{this.workspaceName, changes.size(), changes});
            }
            for (NodeKey key : changes.changedNodes()) {
                if (this.closed) break;
                this.nodesByKey.remove(key);
            }
        }
    }

    public void changed(ChangeSet changes) {
        this.checkNotClosed();
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Cache for workspace '{0}' received {1} changes from local sessions: {2}", new Object[]{this.workspaceName, changes.size(), changes});
        }
        for (NodeKey key : changes.changedNodes()) {
            if (this.closed) break;
            this.nodesByKey.remove(key);
        }
        if (this.changeBus != null) {
            this.changeBus.notify(changes);
        }
    }

    @Override
    public NodeCache unwrap() {
        return this;
    }

    protected final void checkNotClosed() {
        if (this.closed) {
            throw new WorkspaceNotFoundException(JcrI18n.workspaceHasBeenDeleted.text(new Object[]{this.getWorkspaceName()}));
        }
    }

    public void signalDeleted() {
        this.closed = true;
        this.removeListeners();
        this.clear();
    }

    public void signalClosing() {
        this.closed = true;
        this.removeListeners();
    }

    public void signalClosed() {
        this.closed = true;
        this.clear();
    }

    private void removeListeners() {
        if (this.changeBus != null) {
            if (this.systemChangeNotifier != null) {
                this.changeBus.unregister(this.systemChangeNotifier);
            }
            if (this.nonSystemChangeNotifier != null) {
                this.changeBus.unregister(this.nonSystemChangeNotifier);
            }
        }
    }

    public boolean isEmpty() {
        CachedNode root = this.getNode(this.getRootKey());
        return root.getChildReferences(this).size() == 1L;
    }

    public String toString() {
        return this.workspaceName;
    }

    protected WorkspaceCache persistedCache(Iterable<NodeKey> nodeKeys) {
        ConcurrentHashMap<NodeKey, CachedNode> nodes = new ConcurrentHashMap<NodeKey, CachedNode>();
        for (NodeKey nodeKey : nodeKeys) {
            Document nodeData = this.documentFor(nodeKey);
            if (nodeData == null) continue;
            LazyCachedNode persistedNode = new LazyCachedNode(nodeKey, nodeData);
            nodes.put(nodeKey, persistedNode);
            this.nodesByKey.put(nodeKey, persistedNode);
        }
        return new WorkspaceCache(this, nodes);
    }

    protected final class NonSystemChangeNotifier
    implements ChangeSetListener {
        private final String systemWorkspaceName;

        protected NonSystemChangeNotifier(String systemWorkspaceName) {
            this.systemWorkspaceName = systemWorkspaceName;
        }

        @Override
        public void notify(ChangeSet changeSet) {
            if (this.systemWorkspaceName.equals(changeSet.getWorkspaceName())) {
                return;
            }
            WorkspaceCache.this.evictChangedNodes(changeSet);
        }
    }

    protected final class SystemChangeNotifier
    implements ChangeSetListener {
        private final String systemWorkspaceName;

        protected SystemChangeNotifier(String systemWorkspaceName) {
            this.systemWorkspaceName = systemWorkspaceName;
        }

        @Override
        public void notify(ChangeSet changeSet) {
            if (this.systemWorkspaceName.equals(changeSet.getWorkspaceName())) {
                WorkspaceCache.this.evictChangedNodes(changeSet);
            }
        }
    }
}

