/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.index.local;

import java.util.Collections;
import java.util.Map;
import javax.jcr.query.qom.BindVariableValue;
import javax.jcr.query.qom.StaticOperand;
import org.modeshape.jcr.index.local.LocalIndexException;
import org.modeshape.jcr.index.local.MapDB;
import org.modeshape.jcr.query.model.LiteralValue;
import org.modeshape.jcr.value.ValueFactory;

public class IndexValues {
    private static final Map<String, Object> NO_VARIABLES = Collections.emptyMap();

    public static <T> Converter<MapDB.UniqueKey<T>> uniqueKeyConverter(Converter<T> converter) {
        return new UniqueKeyConverter<T>(converter);
    }

    public static <T> Converter<T> converter(ValueFactory<T> factory, Map<String, Object> variables) {
        return new StandardConverter<T>(factory, variables);
    }

    public static <T> Converter<T> converter(ValueFactory<T> factory) {
        return new StandardConverter<T>(factory, NO_VARIABLES);
    }

    private IndexValues() {
    }

    protected static class StandardConverter<T>
    implements Converter<T> {
        private final ValueFactory<T> factory;
        private final Map<String, Object> variables;

        protected StandardConverter(ValueFactory<T> factory, Map<String, Object> variables) {
            this.factory = factory;
            this.variables = variables;
        }

        @Override
        public T toLowerValue(StaticOperand operand) {
            if (operand instanceof LiteralValue) {
                LiteralValue literal = (LiteralValue)operand;
                return this.factory.create(literal.value());
            }
            if (operand instanceof BindVariableValue) {
                BindVariableValue bind = (BindVariableValue)operand;
                return this.factory.create(this.variables.get(bind.getBindVariableName()));
            }
            throw new LocalIndexException("Unexpected static operand: " + operand);
        }

        @Override
        public T toUpperValue(StaticOperand operand) {
            if (operand instanceof LiteralValue) {
                LiteralValue literal = (LiteralValue)operand;
                return this.factory.create(literal.value());
            }
            if (operand instanceof BindVariableValue) {
                BindVariableValue bind = (BindVariableValue)operand;
                return this.factory.create(this.variables.get(bind.getBindVariableName()));
            }
            throw new LocalIndexException("Unexpected static operand: " + operand);
        }
    }

    static final class UniqueKeyConverter<T>
    implements Converter<MapDB.UniqueKey<T>> {
        private final Converter<T> valueConverter;

        protected UniqueKeyConverter(Converter<T> valueConverter) {
            this.valueConverter = valueConverter;
        }

        @Override
        public MapDB.UniqueKey<T> toLowerValue(StaticOperand operand) {
            T value = this.valueConverter.toLowerValue(operand);
            return value != null ? new MapDB.UniqueKey<T>(value, 0L) : null;
        }

        @Override
        public MapDB.UniqueKey<T> toUpperValue(StaticOperand operand) {
            T value = this.valueConverter.toLowerValue(operand);
            return value != null ? new MapDB.UniqueKey<T>(value, Long.MAX_VALUE) : null;
        }
    }

    public static interface Converter<T> {
        public T toLowerValue(StaticOperand var1);

        public T toUpperValue(StaticOperand var1);
    }
}

