/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.index.local;

import java.util.Comparator;
import java.util.concurrent.atomic.AtomicLong;
import org.mapdb.DB;
import org.mapdb.Serializer;
import org.modeshape.jcr.index.local.IndexValues;
import org.modeshape.jcr.index.local.LocalMapIndex;
import org.modeshape.jcr.index.local.MapDB;

final class LocalDuplicateIndex<T>
extends LocalMapIndex<MapDB.UniqueKey<T>, T> {
    private static final String NEXT_COUNTER = "next-counter";
    private final AtomicLong counter;

    static <T> LocalDuplicateIndex<T> create(String name, String workspaceName, String providerName, DB db, IndexValues.Converter<T> converter, Serializer<T> valueSerializer, Comparator<T> comparator) {
        return new LocalDuplicateIndex<T>(name, workspaceName, providerName, db, converter, valueSerializer, comparator);
    }

    protected LocalDuplicateIndex(String name, String workspaceName, String providerName, DB db, IndexValues.Converter<T> converter, Serializer<T> valueSerializer, Comparator<T> comparator) {
        super(name, workspaceName, providerName, db, IndexValues.uniqueKeyConverter(converter), MapDB.uniqueKeySerializer(valueSerializer, comparator));
        Long nextCounter = (Long)this.options.get(NEXT_COUNTER);
        this.counter = new AtomicLong(nextCounter != null ? nextCounter : 0L);
    }

    @Override
    public void close() {
        this.options.put(NEXT_COUNTER, this.counter.get());
        super.close();
    }

    @Override
    public void add(String nodeKey, T value) {
        this.keysByValue.put(new MapDB.UniqueKey<T>(value, this.counter.getAndIncrement()), (Object)nodeKey);
    }
}

