/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.index.local;

import java.io.File;
import javax.jcr.RepositoryException;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.modeshape.jcr.NodeTypes;
import org.modeshape.jcr.api.index.IndexDefinition;
import org.modeshape.jcr.spi.index.IndexFeedback;
import org.modeshape.jcr.spi.index.provider.IndexPlanner;
import org.modeshape.jcr.spi.index.provider.IndexProvider;
import org.modeshape.jcr.spi.index.provider.ManagedIndex;

public class LocalIndexProvider
extends IndexProvider {
    private static final String DB_FILENAME = "indexes.db";
    private String directory;
    private DB db;

    public String getDirectory() {
        return this.directory;
    }

    @Override
    protected void doInitialize() throws RepositoryException {
        assert (this.directory != null);
        File dir = new File(this.directory);
        if (!dir.exists()) {
            this.logger().debug("Attempting to create directory for local indexes in repository '{1}' at: {0}", new Object[]{dir.getAbsolutePath(), this.getRepositoryName()});
            dir.mkdirs();
        }
        if (!dir.canRead()) {
            throw new RepositoryException("The directory for local indexes at '{0}' in repository '{1}' must be readable.");
        }
        if (!dir.canWrite()) {
            throw new RepositoryException("The directory for local indexes at '{0}' in repository '{1}' must be writable.");
        }
        File file = new File(dir, DB_FILENAME);
        this.db = DBMaker.newFileDB((File)file).make();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void postShutdown() {
        if (this.db != null) {
            try {
                this.db.close();
            }
            finally {
                this.db = null;
            }
        }
    }

    @Override
    public IndexPlanner getIndexPlanner() {
        return null;
    }

    @Override
    protected ManagedIndex createIndex(IndexDefinition defn, String workspaceName, NodeTypes.Supplier nodeTypesSupplier, IndexFeedback feedback) {
        return null;
    }

    @Override
    protected ManagedIndex updateIndex(IndexDefinition oldDefn, IndexDefinition updatedDefn, ManagedIndex existingIndex, String workspaceName, NodeTypes.Supplier nodeTypesSupplier, IndexFeedback feedback) {
        return null;
    }

    @Override
    protected void removeIndex(IndexDefinition oldDefn, ManagedIndex existingIndex, String workspaceName) {
    }
}

