/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.index.local;

import java.util.NavigableSet;
import java.util.concurrent.ConcurrentMap;
import org.mapdb.BTreeKeySerializer;
import org.mapdb.BTreeMap;
import org.mapdb.Bind;
import org.mapdb.DB;
import org.mapdb.Fun;
import org.modeshape.jcr.index.local.IndexValues;
import org.modeshape.jcr.index.local.LocalIndex;
import org.modeshape.jcr.index.local.Operations;
import org.modeshape.jcr.spi.index.IndexConstraints;
import org.modeshape.jcr.spi.index.provider.Filter;

abstract class LocalMapIndex<T, V>
implements LocalIndex<V> {
    private final String name;
    private final String workspace;
    private final String providerName;
    protected final BTreeMap<T, String> keysByValue;
    protected final NavigableSet<Fun.Tuple2<String, T>> valuesByKey;
    protected final ConcurrentMap<String, Object> options;
    private final IndexValues.Converter<T> converter;

    LocalMapIndex(String name, String workspaceName, String providerName, DB db, IndexValues.Converter<T> converter, BTreeKeySerializer<T> valueSerializer) {
        this.name = name;
        this.workspace = workspaceName;
        this.providerName = providerName;
        this.converter = converter;
        if (db.exists(name)) {
            this.keysByValue = db.getTreeMap(name);
            this.valuesByKey = db.getTreeSet(name + "/inverse");
            this.options = db.getHashMap(name + "/options");
        } else {
            DB.BTreeMapMaker maker = db.createTreeMap(name).counterEnable();
            if (valueSerializer != null) {
                maker.keySerializer(valueSerializer);
            }
            this.keysByValue = maker.make();
            this.valuesByKey = db.createTreeSet(name + "/inverse").make();
            this.options = db.createHashMap(name + "/options").make();
        }
        Bind.mapInverse(this.keysByValue, this.valuesByKey);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getWorkspaceName() {
        return this.workspace;
    }

    @Override
    public String getProviderName() {
        return this.providerName;
    }

    @Override
    public boolean supportsFullTextConstraints() {
        return false;
    }

    protected final IndexValues.Converter<T> converter() {
        return this.converter;
    }

    @Override
    public Filter.Results filter(IndexConstraints filter) {
        return Operations.createOperation(this.keysByValue, this.converter, filter.getConstraints());
    }

    @Override
    public void remove(String nodeKey) {
        for (Object key : Fun.filter(this.valuesByKey, (Object)nodeKey)) {
            this.keysByValue.remove(key);
        }
    }

    @Override
    public void close() {
    }
}

